/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.lightsail.model.MetricDatapoint;

public class MetricDatapointUnmarshaller
implements Unmarshaller<MetricDatapoint, JsonUnmarshallerContext> {
    private static final MetricDatapointUnmarshaller INSTANCE = new MetricDatapointUnmarshaller();

    public MetricDatapoint unmarshall(JsonUnmarshallerContext context) throws Exception {
        MetricDatapoint.Builder metricDatapointBuilder = MetricDatapoint.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("average", targetDepth)) {
                    context.nextToken();
                    metricDatapointBuilder.average((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("maximum", targetDepth)) {
                    context.nextToken();
                    metricDatapointBuilder.maximum((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("minimum", targetDepth)) {
                    context.nextToken();
                    metricDatapointBuilder.minimum((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("sampleCount", targetDepth)) {
                    context.nextToken();
                    metricDatapointBuilder.sampleCount((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("sum", targetDepth)) {
                    context.nextToken();
                    metricDatapointBuilder.sum((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("timestamp", targetDepth)) {
                    context.nextToken();
                    metricDatapointBuilder.timestamp((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("unit", targetDepth)) {
                    context.nextToken();
                    metricDatapointBuilder.unit((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (MetricDatapoint)metricDatapointBuilder.build();
    }

    public static MetricDatapointUnmarshaller getInstance() {
        return INSTANCE;
    }
}

