/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.Blueprint;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BlueprintMarshaller {
    private static final MarshallingInfo<String> BLUEPRINTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blueprintId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> GROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("group").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ISACTIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isActive").isBinary(false).build();
    private static final MarshallingInfo<Integer> MINPOWER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minPower").isBinary(false).build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").isBinary(false).build();
    private static final MarshallingInfo<String> VERSIONCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("versionCode").isBinary(false).build();
    private static final MarshallingInfo<String> PRODUCTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("productUrl").isBinary(false).build();
    private static final MarshallingInfo<String> LICENSEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("licenseUrl").isBinary(false).build();
    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("platform").isBinary(false).build();
    private static final BlueprintMarshaller INSTANCE = new BlueprintMarshaller();

    private BlueprintMarshaller() {
    }

    public static BlueprintMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Blueprint blueprint, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)blueprint, (String)"blueprint");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)blueprint.blueprintId(), BLUEPRINTID_BINDING);
            protocolMarshaller.marshall((Object)blueprint.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)blueprint.group(), GROUP_BINDING);
            protocolMarshaller.marshall((Object)blueprint.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)blueprint.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)blueprint.isActive(), ISACTIVE_BINDING);
            protocolMarshaller.marshall((Object)blueprint.minPower(), MINPOWER_BINDING);
            protocolMarshaller.marshall((Object)blueprint.version(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)blueprint.versionCode(), VERSIONCODE_BINDING);
            protocolMarshaller.marshall((Object)blueprint.productUrl(), PRODUCTURL_BINDING);
            protocolMarshaller.marshall((Object)blueprint.licenseUrl(), LICENSEURL_BINDING);
            protocolMarshaller.marshall((Object)blueprint.platformAsString(), PLATFORM_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

