/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.Disk;
import software.amazon.awssdk.services.lightsail.model.DiskListCopier;
import software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.services.lightsail.transform.InstanceSnapshotMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceSnapshot
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceSnapshot> {
    private final String name;
    private final String arn;
    private final String supportCode;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final String resourceType;
    private final String state;
    private final String progress;
    private final List<Disk> fromAttachedDisks;
    private final String fromInstanceName;
    private final String fromInstanceArn;
    private final String fromBlueprintId;
    private final String fromBundleId;
    private final Integer sizeInGb;

    private InstanceSnapshot(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.state = builder.state;
        this.progress = builder.progress;
        this.fromAttachedDisks = builder.fromAttachedDisks;
        this.fromInstanceName = builder.fromInstanceName;
        this.fromInstanceArn = builder.fromInstanceArn;
        this.fromBlueprintId = builder.fromBlueprintId;
        this.fromBundleId = builder.fromBundleId;
        this.sizeInGb = builder.sizeInGb;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public String supportCode() {
        return this.supportCode;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public ResourceLocation location() {
        return this.location;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public InstanceSnapshotState state() {
        return InstanceSnapshotState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String progress() {
        return this.progress;
    }

    public List<Disk> fromAttachedDisks() {
        return this.fromAttachedDisks;
    }

    public String fromInstanceName() {
        return this.fromInstanceName;
    }

    public String fromInstanceArn() {
        return this.fromInstanceArn;
    }

    public String fromBlueprintId() {
        return this.fromBlueprintId;
    }

    public String fromBundleId() {
        return this.fromBundleId;
    }

    public Integer sizeInGb() {
        return this.sizeInGb;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromAttachedDisks());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromBlueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromBundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInGb());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSnapshot)) {
            return false;
        }
        InstanceSnapshot other = (InstanceSnapshot)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.supportCode(), other.supportCode()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.fromAttachedDisks(), other.fromAttachedDisks()) && Objects.equals(this.fromInstanceName(), other.fromInstanceName()) && Objects.equals(this.fromInstanceArn(), other.fromInstanceArn()) && Objects.equals(this.fromBlueprintId(), other.fromBlueprintId()) && Objects.equals(this.fromBundleId(), other.fromBundleId()) && Objects.equals(this.sizeInGb(), other.sizeInGb());
    }

    public String toString() {
        return ToString.builder((String)"InstanceSnapshot").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("SupportCode", (Object)this.supportCode()).add("CreatedAt", (Object)this.createdAt()).add("Location", (Object)this.location()).add("ResourceType", (Object)this.resourceTypeAsString()).add("State", (Object)this.stateAsString()).add("Progress", (Object)this.progress()).add("FromAttachedDisks", this.fromAttachedDisks()).add("FromInstanceName", (Object)this.fromInstanceName()).add("FromInstanceArn", (Object)this.fromInstanceArn()).add("FromBlueprintId", (Object)this.fromBlueprintId()).add("FromBundleId", (Object)this.fromBundleId()).add("SizeInGb", (Object)this.sizeInGb()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "supportCode": {
                return Optional.ofNullable(clazz.cast(this.supportCode()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "progress": {
                return Optional.ofNullable(clazz.cast(this.progress()));
            }
            case "fromAttachedDisks": {
                return Optional.ofNullable(clazz.cast(this.fromAttachedDisks()));
            }
            case "fromInstanceName": {
                return Optional.ofNullable(clazz.cast(this.fromInstanceName()));
            }
            case "fromInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.fromInstanceArn()));
            }
            case "fromBlueprintId": {
                return Optional.ofNullable(clazz.cast(this.fromBlueprintId()));
            }
            case "fromBundleId": {
                return Optional.ofNullable(clazz.cast(this.fromBundleId()));
            }
            case "sizeInGb": {
                return Optional.ofNullable(clazz.cast(this.sizeInGb()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceSnapshotMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String supportCode;
        private Instant createdAt;
        private ResourceLocation location;
        private String resourceType;
        private String state;
        private String progress;
        private List<Disk> fromAttachedDisks = DefaultSdkAutoConstructList.getInstance();
        private String fromInstanceName;
        private String fromInstanceArn;
        private String fromBlueprintId;
        private String fromBundleId;
        private Integer sizeInGb;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceSnapshot model) {
            this.name(model.name);
            this.arn(model.arn);
            this.supportCode(model.supportCode);
            this.createdAt(model.createdAt);
            this.location(model.location);
            this.resourceType(model.resourceType);
            this.state(model.state);
            this.progress(model.progress);
            this.fromAttachedDisks(model.fromAttachedDisks);
            this.fromInstanceName(model.fromInstanceName);
            this.fromInstanceArn(model.fromInstanceArn);
            this.fromBlueprintId(model.fromBlueprintId);
            this.fromBundleId(model.fromBundleId);
            this.sizeInGb(model.sizeInGb);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSupportCode() {
            return this.supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InstanceSnapshotState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getProgress() {
            return this.progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final Collection<Disk.Builder> getFromAttachedDisks() {
            return this.fromAttachedDisks != null ? (Collection)this.fromAttachedDisks.stream().map(Disk::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fromAttachedDisks(Collection<Disk> fromAttachedDisks) {
            this.fromAttachedDisks = DiskListCopier.copy(fromAttachedDisks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fromAttachedDisks(Disk ... fromAttachedDisks) {
            this.fromAttachedDisks(Arrays.asList(fromAttachedDisks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fromAttachedDisks(Consumer<Disk.Builder> ... fromAttachedDisks) {
            this.fromAttachedDisks(Stream.of(fromAttachedDisks).map(c -> (Disk)((Disk.Builder)Disk.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFromAttachedDisks(Collection<Disk.BuilderImpl> fromAttachedDisks) {
            this.fromAttachedDisks = DiskListCopier.copyFromBuilder(fromAttachedDisks);
        }

        public final String getFromInstanceName() {
            return this.fromInstanceName;
        }

        @Override
        public final Builder fromInstanceName(String fromInstanceName) {
            this.fromInstanceName = fromInstanceName;
            return this;
        }

        public final void setFromInstanceName(String fromInstanceName) {
            this.fromInstanceName = fromInstanceName;
        }

        public final String getFromInstanceArn() {
            return this.fromInstanceArn;
        }

        @Override
        public final Builder fromInstanceArn(String fromInstanceArn) {
            this.fromInstanceArn = fromInstanceArn;
            return this;
        }

        public final void setFromInstanceArn(String fromInstanceArn) {
            this.fromInstanceArn = fromInstanceArn;
        }

        public final String getFromBlueprintId() {
            return this.fromBlueprintId;
        }

        @Override
        public final Builder fromBlueprintId(String fromBlueprintId) {
            this.fromBlueprintId = fromBlueprintId;
            return this;
        }

        public final void setFromBlueprintId(String fromBlueprintId) {
            this.fromBlueprintId = fromBlueprintId;
        }

        public final String getFromBundleId() {
            return this.fromBundleId;
        }

        @Override
        public final Builder fromBundleId(String fromBundleId) {
            this.fromBundleId = fromBundleId;
            return this;
        }

        public final void setFromBundleId(String fromBundleId) {
            this.fromBundleId = fromBundleId;
        }

        public final Integer getSizeInGb() {
            return this.sizeInGb;
        }

        @Override
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        public InstanceSnapshot build() {
            return new InstanceSnapshot(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceSnapshot> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder supportCode(String var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        default public Builder location(Consumer<ResourceLocation.Builder> location) {
            return this.location((ResourceLocation)((ResourceLocation.Builder)ResourceLocation.builder().applyMutation(location)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder state(String var1);

        public Builder state(InstanceSnapshotState var1);

        public Builder progress(String var1);

        public Builder fromAttachedDisks(Collection<Disk> var1);

        public Builder fromAttachedDisks(Disk ... var1);

        public Builder fromAttachedDisks(Consumer<Disk.Builder> ... var1);

        public Builder fromInstanceName(String var1);

        public Builder fromInstanceArn(String var1);

        public Builder fromBlueprintId(String var1);

        public Builder fromBundleId(String var1);

        public Builder sizeInGb(Integer var1);
    }
}

