/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.AccessDirection;
import software.amazon.awssdk.services.lightsail.model.NetworkProtocol;
import software.amazon.awssdk.services.lightsail.model.PortAccessType;
import software.amazon.awssdk.services.lightsail.transform.InstancePortInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstancePortInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, InstancePortInfo> {
    private final Integer fromPort;
    private final Integer toPort;
    private final String protocol;
    private final String accessFrom;
    private final String accessType;
    private final String commonName;
    private final String accessDirection;

    private InstancePortInfo(BuilderImpl builder) {
        this.fromPort = builder.fromPort;
        this.toPort = builder.toPort;
        this.protocol = builder.protocol;
        this.accessFrom = builder.accessFrom;
        this.accessType = builder.accessType;
        this.commonName = builder.commonName;
        this.accessDirection = builder.accessDirection;
    }

    public Integer fromPort() {
        return this.fromPort;
    }

    public Integer toPort() {
        return this.toPort;
    }

    public NetworkProtocol protocol() {
        return NetworkProtocol.fromValue(this.protocol);
    }

    public String protocolAsString() {
        return this.protocol;
    }

    public String accessFrom() {
        return this.accessFrom;
    }

    public PortAccessType accessType() {
        return PortAccessType.fromValue(this.accessType);
    }

    public String accessTypeAsString() {
        return this.accessType;
    }

    public String commonName() {
        return this.commonName;
    }

    public AccessDirection accessDirection() {
        return AccessDirection.fromValue(this.accessDirection);
    }

    public String accessDirectionAsString() {
        return this.accessDirection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.toPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.commonName());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessDirectionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstancePortInfo)) {
            return false;
        }
        InstancePortInfo other = (InstancePortInfo)obj;
        return Objects.equals(this.fromPort(), other.fromPort()) && Objects.equals(this.toPort(), other.toPort()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.accessFrom(), other.accessFrom()) && Objects.equals(this.accessTypeAsString(), other.accessTypeAsString()) && Objects.equals(this.commonName(), other.commonName()) && Objects.equals(this.accessDirectionAsString(), other.accessDirectionAsString());
    }

    public String toString() {
        return ToString.builder((String)"InstancePortInfo").add("FromPort", (Object)this.fromPort()).add("ToPort", (Object)this.toPort()).add("Protocol", (Object)this.protocolAsString()).add("AccessFrom", (Object)this.accessFrom()).add("AccessType", (Object)this.accessTypeAsString()).add("CommonName", (Object)this.commonName()).add("AccessDirection", (Object)this.accessDirectionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fromPort": {
                return Optional.ofNullable(clazz.cast(this.fromPort()));
            }
            case "toPort": {
                return Optional.ofNullable(clazz.cast(this.toPort()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "accessFrom": {
                return Optional.ofNullable(clazz.cast(this.accessFrom()));
            }
            case "accessType": {
                return Optional.ofNullable(clazz.cast(this.accessTypeAsString()));
            }
            case "commonName": {
                return Optional.ofNullable(clazz.cast(this.commonName()));
            }
            case "accessDirection": {
                return Optional.ofNullable(clazz.cast(this.accessDirectionAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstancePortInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer fromPort;
        private Integer toPort;
        private String protocol;
        private String accessFrom;
        private String accessType;
        private String commonName;
        private String accessDirection;

        private BuilderImpl() {
        }

        private BuilderImpl(InstancePortInfo model) {
            this.fromPort(model.fromPort);
            this.toPort(model.toPort);
            this.protocol(model.protocol);
            this.accessFrom(model.accessFrom);
            this.accessType(model.accessType);
            this.commonName(model.commonName);
            this.accessDirection(model.accessDirection);
        }

        public final Integer getFromPort() {
            return this.fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final Integer getToPort() {
            return this.toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(NetworkProtocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getAccessFrom() {
            return this.accessFrom;
        }

        @Override
        public final Builder accessFrom(String accessFrom) {
            this.accessFrom = accessFrom;
            return this;
        }

        public final void setAccessFrom(String accessFrom) {
            this.accessFrom = accessFrom;
        }

        public final String getAccessType() {
            return this.accessType;
        }

        @Override
        public final Builder accessType(String accessType) {
            this.accessType = accessType;
            return this;
        }

        @Override
        public final Builder accessType(PortAccessType accessType) {
            this.accessType(accessType.toString());
            return this;
        }

        public final void setAccessType(String accessType) {
            this.accessType = accessType;
        }

        public final String getCommonName() {
            return this.commonName;
        }

        @Override
        public final Builder commonName(String commonName) {
            this.commonName = commonName;
            return this;
        }

        public final void setCommonName(String commonName) {
            this.commonName = commonName;
        }

        public final String getAccessDirection() {
            return this.accessDirection;
        }

        @Override
        public final Builder accessDirection(String accessDirection) {
            this.accessDirection = accessDirection;
            return this;
        }

        @Override
        public final Builder accessDirection(AccessDirection accessDirection) {
            this.accessDirection(accessDirection.toString());
            return this;
        }

        public final void setAccessDirection(String accessDirection) {
            this.accessDirection = accessDirection;
        }

        public InstancePortInfo build() {
            return new InstancePortInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstancePortInfo> {
        public Builder fromPort(Integer var1);

        public Builder toPort(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(NetworkProtocol var1);

        public Builder accessFrom(String var1);

        public Builder accessType(String var1);

        public Builder accessType(PortAccessType var1);

        public Builder commonName(String var1);

        public Builder accessDirection(String var1);

        public Builder accessDirection(AccessDirection var1);
    }
}

