/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.StaticIp;
import software.amazon.awssdk.services.lightsail.model.StaticIpListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetStaticIpsResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetStaticIpsResponse> {
    private final List<StaticIp> staticIps;
    private final String nextPageToken;

    private GetStaticIpsResponse(BuilderImpl builder) {
        super(builder);
        this.staticIps = builder.staticIps;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<StaticIp> staticIps() {
        return this.staticIps;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.staticIps());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStaticIpsResponse)) {
            return false;
        }
        GetStaticIpsResponse other = (GetStaticIpsResponse)((Object)obj);
        return Objects.equals(this.staticIps(), other.staticIps()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"GetStaticIpsResponse").add("StaticIps", this.staticIps()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "staticIps": {
                return Optional.ofNullable(clazz.cast(this.staticIps()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<StaticIp> staticIps = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStaticIpsResponse model) {
            super(model);
            this.staticIps(model.staticIps);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<StaticIp.Builder> getStaticIps() {
            return this.staticIps != null ? (Collection)this.staticIps.stream().map(StaticIp::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder staticIps(Collection<StaticIp> staticIps) {
            this.staticIps = StaticIpListCopier.copy(staticIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staticIps(StaticIp ... staticIps) {
            this.staticIps(Arrays.asList(staticIps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staticIps(Consumer<StaticIp.Builder> ... staticIps) {
            this.staticIps(Stream.of(staticIps).map(c -> (StaticIp)((StaticIp.Builder)StaticIp.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStaticIps(Collection<StaticIp.BuilderImpl> staticIps) {
            this.staticIps = StaticIpListCopier.copyFromBuilder(staticIps);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetStaticIpsResponse build() {
            return new GetStaticIpsResponse(this);
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    CopyableBuilder<Builder, GetStaticIpsResponse> {
        public Builder staticIps(Collection<StaticIp> var1);

        public Builder staticIps(StaticIp ... var1);

        public Builder staticIps(Consumer<StaticIp.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

