/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.InstancePortState;
import software.amazon.awssdk.services.lightsail.model.InstancePortStateListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInstancePortStatesResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetInstancePortStatesResponse> {
    private final List<InstancePortState> portStates;

    private GetInstancePortStatesResponse(BuilderImpl builder) {
        super(builder);
        this.portStates = builder.portStates;
    }

    public List<InstancePortState> portStates() {
        return this.portStates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.portStates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstancePortStatesResponse)) {
            return false;
        }
        GetInstancePortStatesResponse other = (GetInstancePortStatesResponse)((Object)obj);
        return Objects.equals(this.portStates(), other.portStates());
    }

    public String toString() {
        return ToString.builder((String)"GetInstancePortStatesResponse").add("PortStates", this.portStates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "portStates": {
                return Optional.ofNullable(clazz.cast(this.portStates()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<InstancePortState> portStates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstancePortStatesResponse model) {
            super(model);
            this.portStates(model.portStates);
        }

        public final Collection<InstancePortState.Builder> getPortStates() {
            return this.portStates != null ? (Collection)this.portStates.stream().map(InstancePortState::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder portStates(Collection<InstancePortState> portStates) {
            this.portStates = InstancePortStateListCopier.copy(portStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portStates(InstancePortState ... portStates) {
            this.portStates(Arrays.asList(portStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portStates(Consumer<InstancePortState.Builder> ... portStates) {
            this.portStates(Stream.of(portStates).map(c -> (InstancePortState)((InstancePortState.Builder)InstancePortState.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPortStates(Collection<InstancePortState.BuilderImpl> portStates) {
            this.portStates = InstancePortStateListCopier.copyFromBuilder(portStates);
        }

        @Override
        public GetInstancePortStatesResponse build() {
            return new GetInstancePortStatesResponse(this);
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    CopyableBuilder<Builder, GetInstancePortStatesResponse> {
        public Builder portStates(Collection<InstancePortState> var1);

        public Builder portStates(InstancePortState ... var1);

        public Builder portStates(Consumer<InstancePortState.Builder> ... var1);
    }
}

