/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.lightsail.model.DomainEntry;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDomainEntryRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, CreateDomainEntryRequest> {
    private final String domainName;
    private final DomainEntry domainEntry;

    private CreateDomainEntryRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.domainEntry = builder.domainEntry;
    }

    public String domainName() {
        return this.domainName;
    }

    public DomainEntry domainEntry() {
        return this.domainEntry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainEntry());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainEntryRequest)) {
            return false;
        }
        CreateDomainEntryRequest other = (CreateDomainEntryRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.domainEntry(), other.domainEntry());
    }

    public String toString() {
        return ToString.builder((String)"CreateDomainEntryRequest").add("DomainName", (Object)this.domainName()).add("DomainEntry", (Object)this.domainEntry()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "domainEntry": {
                return Optional.ofNullable(clazz.cast(this.domainEntry()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private DomainEntry domainEntry;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainEntryRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.domainEntry(model.domainEntry);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final DomainEntry.Builder getDomainEntry() {
            return this.domainEntry != null ? this.domainEntry.toBuilder() : null;
        }

        @Override
        public final Builder domainEntry(DomainEntry domainEntry) {
            this.domainEntry = domainEntry;
            return this;
        }

        public final void setDomainEntry(DomainEntry.BuilderImpl domainEntry) {
            this.domainEntry = domainEntry != null ? domainEntry.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDomainEntryRequest build() {
            return new CreateDomainEntryRequest(this);
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    CopyableBuilder<Builder, CreateDomainEntryRequest> {
        public Builder domainName(String var1);

        public Builder domainEntry(DomainEntry var1);

        default public Builder domainEntry(Consumer<DomainEntry.Builder> domainEntry) {
            return this.domainEntry((DomainEntry)((DomainEntry.Builder)DomainEntry.builder().applyMutation(domainEntry)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

