/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseManagerUserSubscriptionsResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ProductUserSummary;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ProductUserSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProductSubscriptionsResponse
extends LicenseManagerUserSubscriptionsResponse
implements ToCopyableBuilder<Builder, ListProductSubscriptionsResponse> {
    private static final SdkField<List<ProductUserSummary>> PRODUCT_USER_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductUserSummaries").getter(ListProductSubscriptionsResponse.getter(ListProductSubscriptionsResponse::productUserSummaries)).setter(ListProductSubscriptionsResponse.setter(Builder::productUserSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductUserSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductUserSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListProductSubscriptionsResponse.getter(ListProductSubscriptionsResponse::nextToken)).setter(ListProductSubscriptionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_USER_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListProductSubscriptionsResponse.memberNameToFieldInitializer();
    private final List<ProductUserSummary> productUserSummaries;
    private final String nextToken;

    private ListProductSubscriptionsResponse(BuilderImpl builder) {
        super(builder);
        this.productUserSummaries = builder.productUserSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasProductUserSummaries() {
        return this.productUserSummaries != null && !(this.productUserSummaries instanceof SdkAutoConstructList);
    }

    public final List<ProductUserSummary> productUserSummaries() {
        return this.productUserSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductUserSummaries() ? this.productUserSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProductSubscriptionsResponse)) {
            return false;
        }
        ListProductSubscriptionsResponse other = (ListProductSubscriptionsResponse)((Object)obj);
        return this.hasProductUserSummaries() == other.hasProductUserSummaries() && Objects.equals(this.productUserSummaries(), other.productUserSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListProductSubscriptionsResponse").add("ProductUserSummaries", this.hasProductUserSummaries() ? this.productUserSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductUserSummaries": {
                return Optional.ofNullable(clazz.cast(this.productUserSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProductUserSummaries", PRODUCT_USER_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProductSubscriptionsResponse, T> g) {
        return obj -> g.apply((ListProductSubscriptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerUserSubscriptionsResponse.BuilderImpl
    implements Builder {
        private List<ProductUserSummary> productUserSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProductSubscriptionsResponse model) {
            super(model);
            this.productUserSummaries(model.productUserSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ProductUserSummary.Builder> getProductUserSummaries() {
            List<ProductUserSummary.Builder> result = ProductUserSummaryListCopier.copyToBuilder(this.productUserSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductUserSummaries(Collection<ProductUserSummary.BuilderImpl> productUserSummaries) {
            this.productUserSummaries = ProductUserSummaryListCopier.copyFromBuilder(productUserSummaries);
        }

        @Override
        public final Builder productUserSummaries(Collection<ProductUserSummary> productUserSummaries) {
            this.productUserSummaries = ProductUserSummaryListCopier.copy(productUserSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productUserSummaries(ProductUserSummary ... productUserSummaries) {
            this.productUserSummaries(Arrays.asList(productUserSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productUserSummaries(Consumer<ProductUserSummary.Builder> ... productUserSummaries) {
            this.productUserSummaries(Stream.of(productUserSummaries).map(c -> (ProductUserSummary)((ProductUserSummary.Builder)ProductUserSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListProductSubscriptionsResponse build() {
            return new ListProductSubscriptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LicenseManagerUserSubscriptionsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProductSubscriptionsResponse> {
        public Builder productUserSummaries(Collection<ProductUserSummary> var1);

        public Builder productUserSummaries(ProductUserSummary ... var1);

        public Builder productUserSummaries(Consumer<ProductUserSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

