/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.InstanceSummary;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.InstanceSummaryListCopier;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseManagerUserSubscriptionsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInstancesResponse
extends LicenseManagerUserSubscriptionsResponse
implements ToCopyableBuilder<Builder, ListInstancesResponse> {
    private static final SdkField<List<InstanceSummary>> INSTANCE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceSummaries").getter(ListInstancesResponse.getter(ListInstancesResponse::instanceSummaries)).setter(ListInstancesResponse.setter(Builder::instanceSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInstancesResponse.getter(ListInstancesResponse::nextToken)).setter(ListInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListInstancesResponse.memberNameToFieldInitializer();
    private final List<InstanceSummary> instanceSummaries;
    private final String nextToken;

    private ListInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceSummaries = builder.instanceSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInstanceSummaries() {
        return this.instanceSummaries != null && !(this.instanceSummaries instanceof SdkAutoConstructList);
    }

    public final List<InstanceSummary> instanceSummaries() {
        return this.instanceSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceSummaries() ? this.instanceSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstancesResponse)) {
            return false;
        }
        ListInstancesResponse other = (ListInstancesResponse)((Object)obj);
        return this.hasInstanceSummaries() == other.hasInstanceSummaries() && Objects.equals(this.instanceSummaries(), other.instanceSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListInstancesResponse").add("InstanceSummaries", this.hasInstanceSummaries() ? this.instanceSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceSummaries": {
                return Optional.ofNullable(clazz.cast(this.instanceSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceSummaries", INSTANCE_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInstancesResponse, T> g) {
        return obj -> g.apply((ListInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerUserSubscriptionsResponse.BuilderImpl
    implements Builder {
        private List<InstanceSummary> instanceSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstancesResponse model) {
            super(model);
            this.instanceSummaries(model.instanceSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<InstanceSummary.Builder> getInstanceSummaries() {
            List<InstanceSummary.Builder> result = InstanceSummaryListCopier.copyToBuilder(this.instanceSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceSummaries(Collection<InstanceSummary.BuilderImpl> instanceSummaries) {
            this.instanceSummaries = InstanceSummaryListCopier.copyFromBuilder(instanceSummaries);
        }

        @Override
        public final Builder instanceSummaries(Collection<InstanceSummary> instanceSummaries) {
            this.instanceSummaries = InstanceSummaryListCopier.copy(instanceSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceSummaries(InstanceSummary ... instanceSummaries) {
            this.instanceSummaries(Arrays.asList(instanceSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceSummaries(Consumer<InstanceSummary.Builder> ... instanceSummaries) {
            this.instanceSummaries(Stream.of(instanceSummaries).map(c -> (InstanceSummary)((InstanceSummary.Builder)InstanceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInstancesResponse build() {
            return new ListInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LicenseManagerUserSubscriptionsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInstancesResponse> {
        public Builder instanceSummaries(Collection<InstanceSummary> var1);

        public Builder instanceSummaries(InstanceSummary ... var1);

        public Builder instanceSummaries(Consumer<InstanceSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

