/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.LicenseManagerUserSubscriptionsClient;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.internal.UserAgentUtils;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.InstanceSummary;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesResponse;

public class ListInstancesIterable
implements SdkIterable<ListInstancesResponse> {
    private final LicenseManagerUserSubscriptionsClient client;
    private final ListInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInstancesIterable(LicenseManagerUserSubscriptionsClient client, ListInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInstancesResponseFetcher();
    }

    public Iterator<ListInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstanceSummary> instanceSummaries() {
        Function<ListInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceSummaries() != null) {
                return response.instanceSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInstancesResponseFetcher
    implements SyncPageFetcher<ListInstancesResponse> {
        private ListInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInstancesResponse nextPage(ListInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListInstancesIterable.this.client.listInstances(ListInstancesIterable.this.firstRequest);
            }
            return ListInstancesIterable.this.client.listInstances((ListInstancesRequest)((Object)ListInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

