/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ActiveDirectorySettingsDomainIpv4ListListCopier;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.CredentialsProvider;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DomainNetworkSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActiveDirectorySettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActiveDirectorySettings> {
    private static final SdkField<CredentialsProvider> DOMAIN_CREDENTIALS_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DomainCredentialsProvider").getter(ActiveDirectorySettings.getter(ActiveDirectorySettings::domainCredentialsProvider)).setter(ActiveDirectorySettings.setter(Builder::domainCredentialsProvider)).constructor(CredentialsProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainCredentialsProvider").build()}).build();
    private static final SdkField<List<String>> DOMAIN_IPV4_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DomainIpv4List").getter(ActiveDirectorySettings.getter(ActiveDirectorySettings::domainIpv4List)).setter(ActiveDirectorySettings.setter(Builder::domainIpv4List)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIpv4List").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(ActiveDirectorySettings.getter(ActiveDirectorySettings::domainName)).setter(ActiveDirectorySettings.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<DomainNetworkSettings> DOMAIN_NETWORK_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DomainNetworkSettings").getter(ActiveDirectorySettings.getter(ActiveDirectorySettings::domainNetworkSettings)).setter(ActiveDirectorySettings.setter(Builder::domainNetworkSettings)).constructor(DomainNetworkSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainNetworkSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_CREDENTIALS_PROVIDER_FIELD, DOMAIN_IPV4_LIST_FIELD, DOMAIN_NAME_FIELD, DOMAIN_NETWORK_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ActiveDirectorySettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CredentialsProvider domainCredentialsProvider;
    private final List<String> domainIpv4List;
    private final String domainName;
    private final DomainNetworkSettings domainNetworkSettings;

    private ActiveDirectorySettings(BuilderImpl builder) {
        this.domainCredentialsProvider = builder.domainCredentialsProvider;
        this.domainIpv4List = builder.domainIpv4List;
        this.domainName = builder.domainName;
        this.domainNetworkSettings = builder.domainNetworkSettings;
    }

    public final CredentialsProvider domainCredentialsProvider() {
        return this.domainCredentialsProvider;
    }

    public final boolean hasDomainIpv4List() {
        return this.domainIpv4List != null && !(this.domainIpv4List instanceof SdkAutoConstructList);
    }

    public final List<String> domainIpv4List() {
        return this.domainIpv4List;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final DomainNetworkSettings domainNetworkSettings() {
        return this.domainNetworkSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainCredentialsProvider());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainIpv4List() ? this.domainIpv4List() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainNetworkSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveDirectorySettings)) {
            return false;
        }
        ActiveDirectorySettings other = (ActiveDirectorySettings)obj;
        return Objects.equals(this.domainCredentialsProvider(), other.domainCredentialsProvider()) && this.hasDomainIpv4List() == other.hasDomainIpv4List() && Objects.equals(this.domainIpv4List(), other.domainIpv4List()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.domainNetworkSettings(), other.domainNetworkSettings());
    }

    public final String toString() {
        return ToString.builder((String)"ActiveDirectorySettings").add("DomainCredentialsProvider", (Object)this.domainCredentialsProvider()).add("DomainIpv4List", this.hasDomainIpv4List() ? this.domainIpv4List() : null).add("DomainName", (Object)this.domainName()).add("DomainNetworkSettings", (Object)this.domainNetworkSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainCredentialsProvider": {
                return Optional.ofNullable(clazz.cast(this.domainCredentialsProvider()));
            }
            case "DomainIpv4List": {
                return Optional.ofNullable(clazz.cast(this.domainIpv4List()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "DomainNetworkSettings": {
                return Optional.ofNullable(clazz.cast(this.domainNetworkSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainCredentialsProvider", DOMAIN_CREDENTIALS_PROVIDER_FIELD);
        map.put("DomainIpv4List", DOMAIN_IPV4_LIST_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("DomainNetworkSettings", DOMAIN_NETWORK_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActiveDirectorySettings, T> g) {
        return obj -> g.apply((ActiveDirectorySettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CredentialsProvider domainCredentialsProvider;
        private List<String> domainIpv4List = DefaultSdkAutoConstructList.getInstance();
        private String domainName;
        private DomainNetworkSettings domainNetworkSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveDirectorySettings model) {
            this.domainCredentialsProvider(model.domainCredentialsProvider);
            this.domainIpv4List(model.domainIpv4List);
            this.domainName(model.domainName);
            this.domainNetworkSettings(model.domainNetworkSettings);
        }

        public final CredentialsProvider.Builder getDomainCredentialsProvider() {
            return this.domainCredentialsProvider != null ? this.domainCredentialsProvider.toBuilder() : null;
        }

        public final void setDomainCredentialsProvider(CredentialsProvider.BuilderImpl domainCredentialsProvider) {
            this.domainCredentialsProvider = domainCredentialsProvider != null ? domainCredentialsProvider.build() : null;
        }

        @Override
        public final Builder domainCredentialsProvider(CredentialsProvider domainCredentialsProvider) {
            this.domainCredentialsProvider = domainCredentialsProvider;
            return this;
        }

        public final Collection<String> getDomainIpv4List() {
            if (this.domainIpv4List instanceof SdkAutoConstructList) {
                return null;
            }
            return this.domainIpv4List;
        }

        public final void setDomainIpv4List(Collection<String> domainIpv4List) {
            this.domainIpv4List = ActiveDirectorySettingsDomainIpv4ListListCopier.copy(domainIpv4List);
        }

        @Override
        public final Builder domainIpv4List(Collection<String> domainIpv4List) {
            this.domainIpv4List = ActiveDirectorySettingsDomainIpv4ListListCopier.copy(domainIpv4List);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainIpv4List(String ... domainIpv4List) {
            this.domainIpv4List(Arrays.asList(domainIpv4List));
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final DomainNetworkSettings.Builder getDomainNetworkSettings() {
            return this.domainNetworkSettings != null ? this.domainNetworkSettings.toBuilder() : null;
        }

        public final void setDomainNetworkSettings(DomainNetworkSettings.BuilderImpl domainNetworkSettings) {
            this.domainNetworkSettings = domainNetworkSettings != null ? domainNetworkSettings.build() : null;
        }

        @Override
        public final Builder domainNetworkSettings(DomainNetworkSettings domainNetworkSettings) {
            this.domainNetworkSettings = domainNetworkSettings;
            return this;
        }

        public ActiveDirectorySettings build() {
            return new ActiveDirectorySettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActiveDirectorySettings> {
        public Builder domainCredentialsProvider(CredentialsProvider var1);

        default public Builder domainCredentialsProvider(Consumer<CredentialsProvider.Builder> domainCredentialsProvider) {
            return this.domainCredentialsProvider((CredentialsProvider)((CredentialsProvider.Builder)CredentialsProvider.builder().applyMutation(domainCredentialsProvider)).build());
        }

        public Builder domainIpv4List(Collection<String> var1);

        public Builder domainIpv4List(String ... var1);

        public Builder domainName(String var1);

        public Builder domainNetworkSettings(DomainNetworkSettings var1);

        default public Builder domainNetworkSettings(Consumer<DomainNetworkSettings.Builder> domainNetworkSettings) {
            return this.domainNetworkSettings((DomainNetworkSettings)((DomainNetworkSettings.Builder)DomainNetworkSettings.builder().applyMutation(domainNetworkSettings)).build());
        }
    }
}

