/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceSummary> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(InstanceSummary.getter(InstanceSummary::instanceId)).setter(InstanceSummary.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> LAST_STATUS_CHECK_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastStatusCheckDate").getter(InstanceSummary.getter(InstanceSummary::lastStatusCheckDate)).setter(InstanceSummary.setter(Builder::lastStatusCheckDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastStatusCheckDate").build()}).build();
    private static final SdkField<List<String>> PRODUCTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Products").getter(InstanceSummary.getter(InstanceSummary::products)).setter(InstanceSummary.setter(Builder::products)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Products").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(InstanceSummary.getter(InstanceSummary::status)).setter(InstanceSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(InstanceSummary.getter(InstanceSummary::statusMessage)).setter(InstanceSummary.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, LAST_STATUS_CHECK_DATE_FIELD, PRODUCTS_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InstanceId", INSTANCE_ID_FIELD);
            this.put("LastStatusCheckDate", LAST_STATUS_CHECK_DATE_FIELD);
            this.put("Products", PRODUCTS_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("StatusMessage", STATUS_MESSAGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final String lastStatusCheckDate;
    private final List<String> products;
    private final String status;
    private final String statusMessage;

    private InstanceSummary(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.lastStatusCheckDate = builder.lastStatusCheckDate;
        this.products = builder.products;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String lastStatusCheckDate() {
        return this.lastStatusCheckDate;
    }

    public final boolean hasProducts() {
        return this.products != null && !(this.products instanceof SdkAutoConstructList);
    }

    public final List<String> products() {
        return this.products;
    }

    public final String status() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusCheckDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProducts() ? this.products() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSummary)) {
            return false;
        }
        InstanceSummary other = (InstanceSummary)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.lastStatusCheckDate(), other.lastStatusCheckDate()) && this.hasProducts() == other.hasProducts() && Objects.equals(this.products(), other.products()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceSummary").add("InstanceId", (Object)this.instanceId()).add("LastStatusCheckDate", (Object)this.lastStatusCheckDate()).add("Products", this.hasProducts() ? this.products() : null).add("Status", (Object)this.status()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "LastStatusCheckDate": {
                return Optional.ofNullable(clazz.cast(this.lastStatusCheckDate()));
            }
            case "Products": {
                return Optional.ofNullable(clazz.cast(this.products()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InstanceSummary, T> g) {
        return obj -> g.apply((InstanceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String lastStatusCheckDate;
        private List<String> products = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceSummary model) {
            this.instanceId(model.instanceId);
            this.lastStatusCheckDate(model.lastStatusCheckDate);
            this.products(model.products);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getLastStatusCheckDate() {
            return this.lastStatusCheckDate;
        }

        public final void setLastStatusCheckDate(String lastStatusCheckDate) {
            this.lastStatusCheckDate = lastStatusCheckDate;
        }

        @Override
        public final Builder lastStatusCheckDate(String lastStatusCheckDate) {
            this.lastStatusCheckDate = lastStatusCheckDate;
            return this;
        }

        public final Collection<String> getProducts() {
            if (this.products instanceof SdkAutoConstructList) {
                return null;
            }
            return this.products;
        }

        public final void setProducts(Collection<String> products) {
            this.products = StringListCopier.copy(products);
        }

        @Override
        public final Builder products(Collection<String> products) {
            this.products = StringListCopier.copy(products);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder products(String ... products) {
            this.products(Arrays.asList(products));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public InstanceSummary build() {
            return new InstanceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceSummary> {
        public Builder instanceId(String var1);

        public Builder lastStatusCheckDate(String var1);

        public Builder products(Collection<String> var1);

        public Builder products(String ... var1);

        public Builder status(String var1);

        public Builder statusMessage(String var1);
    }
}

