/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseManagerUserSubscriptionsResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseServerEndpoint;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseServerEndpointListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLicenseServerEndpointsResponse
extends LicenseManagerUserSubscriptionsResponse
implements ToCopyableBuilder<Builder, ListLicenseServerEndpointsResponse> {
    private static final SdkField<List<LicenseServerEndpoint>> LICENSE_SERVER_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LicenseServerEndpoints").getter(ListLicenseServerEndpointsResponse.getter(ListLicenseServerEndpointsResponse::licenseServerEndpoints)).setter(ListLicenseServerEndpointsResponse.setter(Builder::licenseServerEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseServerEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseServerEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLicenseServerEndpointsResponse.getter(ListLicenseServerEndpointsResponse::nextToken)).setter(ListLicenseServerEndpointsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_SERVER_ENDPOINTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LicenseServerEndpoints", LICENSE_SERVER_ENDPOINTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<LicenseServerEndpoint> licenseServerEndpoints;
    private final String nextToken;

    private ListLicenseServerEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.licenseServerEndpoints = builder.licenseServerEndpoints;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLicenseServerEndpoints() {
        return this.licenseServerEndpoints != null && !(this.licenseServerEndpoints instanceof SdkAutoConstructList);
    }

    public final List<LicenseServerEndpoint> licenseServerEndpoints() {
        return this.licenseServerEndpoints;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseServerEndpoints() ? this.licenseServerEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLicenseServerEndpointsResponse)) {
            return false;
        }
        ListLicenseServerEndpointsResponse other = (ListLicenseServerEndpointsResponse)((Object)obj);
        return this.hasLicenseServerEndpoints() == other.hasLicenseServerEndpoints() && Objects.equals(this.licenseServerEndpoints(), other.licenseServerEndpoints()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLicenseServerEndpointsResponse").add("LicenseServerEndpoints", this.hasLicenseServerEndpoints() ? this.licenseServerEndpoints() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseServerEndpoints": {
                return Optional.ofNullable(clazz.cast(this.licenseServerEndpoints()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListLicenseServerEndpointsResponse, T> g) {
        return obj -> g.apply((ListLicenseServerEndpointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerUserSubscriptionsResponse.BuilderImpl
    implements Builder {
        private List<LicenseServerEndpoint> licenseServerEndpoints = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLicenseServerEndpointsResponse model) {
            super(model);
            this.licenseServerEndpoints(model.licenseServerEndpoints);
            this.nextToken(model.nextToken);
        }

        public final List<LicenseServerEndpoint.Builder> getLicenseServerEndpoints() {
            List<LicenseServerEndpoint.Builder> result = LicenseServerEndpointListCopier.copyToBuilder(this.licenseServerEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseServerEndpoints(Collection<LicenseServerEndpoint.BuilderImpl> licenseServerEndpoints) {
            this.licenseServerEndpoints = LicenseServerEndpointListCopier.copyFromBuilder(licenseServerEndpoints);
        }

        @Override
        public final Builder licenseServerEndpoints(Collection<LicenseServerEndpoint> licenseServerEndpoints) {
            this.licenseServerEndpoints = LicenseServerEndpointListCopier.copy(licenseServerEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseServerEndpoints(LicenseServerEndpoint ... licenseServerEndpoints) {
            this.licenseServerEndpoints(Arrays.asList(licenseServerEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseServerEndpoints(Consumer<LicenseServerEndpoint.Builder> ... licenseServerEndpoints) {
            this.licenseServerEndpoints(Stream.of(licenseServerEndpoints).map(c -> (LicenseServerEndpoint)((LicenseServerEndpoint.Builder)LicenseServerEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLicenseServerEndpointsResponse build() {
            return new ListLicenseServerEndpointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LicenseManagerUserSubscriptionsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLicenseServerEndpointsResponse> {
        public Builder licenseServerEndpoints(Collection<LicenseServerEndpoint> var1);

        public Builder licenseServerEndpoints(LicenseServerEndpoint ... var1);

        public Builder licenseServerEndpoints(Consumer<LicenseServerEndpoint.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

