/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseServer;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseServerEndpointProvisioningStatus;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseServerListCopier;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ServerEndpoint;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ServerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LicenseServerEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LicenseServerEndpoint> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(LicenseServerEndpoint.getter(LicenseServerEndpoint::creationTime)).setter(LicenseServerEndpoint.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> IDENTITY_PROVIDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityProviderArn").getter(LicenseServerEndpoint.getter(LicenseServerEndpoint::identityProviderArn)).setter(LicenseServerEndpoint.setter(Builder::identityProviderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderArn").build()}).build();
    private static final SdkField<String> LICENSE_SERVER_ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseServerEndpointArn").getter(LicenseServerEndpoint.getter(LicenseServerEndpoint::licenseServerEndpointArn)).setter(LicenseServerEndpoint.setter(Builder::licenseServerEndpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseServerEndpointArn").build()}).build();
    private static final SdkField<String> LICENSE_SERVER_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseServerEndpointId").getter(LicenseServerEndpoint.getter(LicenseServerEndpoint::licenseServerEndpointId)).setter(LicenseServerEndpoint.setter(Builder::licenseServerEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseServerEndpointId").build()}).build();
    private static final SdkField<String> LICENSE_SERVER_ENDPOINT_PROVISIONING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseServerEndpointProvisioningStatus").getter(LicenseServerEndpoint.getter(LicenseServerEndpoint::licenseServerEndpointProvisioningStatusAsString)).setter(LicenseServerEndpoint.setter(Builder::licenseServerEndpointProvisioningStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseServerEndpointProvisioningStatus").build()}).build();
    private static final SdkField<List<LicenseServer>> LICENSE_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LicenseServers").getter(LicenseServerEndpoint.getter(LicenseServerEndpoint::licenseServers)).setter(LicenseServerEndpoint.setter(Builder::licenseServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseServers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseServer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ServerEndpoint> SERVER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServerEndpoint").getter(LicenseServerEndpoint.getter(LicenseServerEndpoint::serverEndpoint)).setter(LicenseServerEndpoint.setter(Builder::serverEndpoint)).constructor(ServerEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerEndpoint").build()}).build();
    private static final SdkField<String> SERVER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerType").getter(LicenseServerEndpoint.getter(LicenseServerEndpoint::serverTypeAsString)).setter(LicenseServerEndpoint.setter(Builder::serverType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerType").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(LicenseServerEndpoint.getter(LicenseServerEndpoint::statusMessage)).setter(LicenseServerEndpoint.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, IDENTITY_PROVIDER_ARN_FIELD, LICENSE_SERVER_ENDPOINT_ARN_FIELD, LICENSE_SERVER_ENDPOINT_ID_FIELD, LICENSE_SERVER_ENDPOINT_PROVISIONING_STATUS_FIELD, LICENSE_SERVERS_FIELD, SERVER_ENDPOINT_FIELD, SERVER_TYPE_FIELD, STATUS_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("IdentityProviderArn", IDENTITY_PROVIDER_ARN_FIELD);
            this.put("LicenseServerEndpointArn", LICENSE_SERVER_ENDPOINT_ARN_FIELD);
            this.put("LicenseServerEndpointId", LICENSE_SERVER_ENDPOINT_ID_FIELD);
            this.put("LicenseServerEndpointProvisioningStatus", LICENSE_SERVER_ENDPOINT_PROVISIONING_STATUS_FIELD);
            this.put("LicenseServers", LICENSE_SERVERS_FIELD);
            this.put("ServerEndpoint", SERVER_ENDPOINT_FIELD);
            this.put("ServerType", SERVER_TYPE_FIELD);
            this.put("StatusMessage", STATUS_MESSAGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant creationTime;
    private final String identityProviderArn;
    private final String licenseServerEndpointArn;
    private final String licenseServerEndpointId;
    private final String licenseServerEndpointProvisioningStatus;
    private final List<LicenseServer> licenseServers;
    private final ServerEndpoint serverEndpoint;
    private final String serverType;
    private final String statusMessage;

    private LicenseServerEndpoint(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.identityProviderArn = builder.identityProviderArn;
        this.licenseServerEndpointArn = builder.licenseServerEndpointArn;
        this.licenseServerEndpointId = builder.licenseServerEndpointId;
        this.licenseServerEndpointProvisioningStatus = builder.licenseServerEndpointProvisioningStatus;
        this.licenseServers = builder.licenseServers;
        this.serverEndpoint = builder.serverEndpoint;
        this.serverType = builder.serverType;
        this.statusMessage = builder.statusMessage;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String identityProviderArn() {
        return this.identityProviderArn;
    }

    public final String licenseServerEndpointArn() {
        return this.licenseServerEndpointArn;
    }

    public final String licenseServerEndpointId() {
        return this.licenseServerEndpointId;
    }

    public final LicenseServerEndpointProvisioningStatus licenseServerEndpointProvisioningStatus() {
        return LicenseServerEndpointProvisioningStatus.fromValue(this.licenseServerEndpointProvisioningStatus);
    }

    public final String licenseServerEndpointProvisioningStatusAsString() {
        return this.licenseServerEndpointProvisioningStatus;
    }

    public final boolean hasLicenseServers() {
        return this.licenseServers != null && !(this.licenseServers instanceof SdkAutoConstructList);
    }

    public final List<LicenseServer> licenseServers() {
        return this.licenseServers;
    }

    public final ServerEndpoint serverEndpoint() {
        return this.serverEndpoint;
    }

    public final ServerType serverType() {
        return ServerType.fromValue(this.serverType);
    }

    public final String serverTypeAsString() {
        return this.serverType;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseServerEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseServerEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseServerEndpointProvisioningStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseServers() ? this.licenseServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serverEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseServerEndpoint)) {
            return false;
        }
        LicenseServerEndpoint other = (LicenseServerEndpoint)obj;
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.identityProviderArn(), other.identityProviderArn()) && Objects.equals(this.licenseServerEndpointArn(), other.licenseServerEndpointArn()) && Objects.equals(this.licenseServerEndpointId(), other.licenseServerEndpointId()) && Objects.equals(this.licenseServerEndpointProvisioningStatusAsString(), other.licenseServerEndpointProvisioningStatusAsString()) && this.hasLicenseServers() == other.hasLicenseServers() && Objects.equals(this.licenseServers(), other.licenseServers()) && Objects.equals(this.serverEndpoint(), other.serverEndpoint()) && Objects.equals(this.serverTypeAsString(), other.serverTypeAsString()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"LicenseServerEndpoint").add("CreationTime", (Object)this.creationTime()).add("IdentityProviderArn", (Object)this.identityProviderArn()).add("LicenseServerEndpointArn", (Object)this.licenseServerEndpointArn()).add("LicenseServerEndpointId", (Object)this.licenseServerEndpointId()).add("LicenseServerEndpointProvisioningStatus", (Object)this.licenseServerEndpointProvisioningStatusAsString()).add("LicenseServers", this.hasLicenseServers() ? this.licenseServers() : null).add("ServerEndpoint", (Object)this.serverEndpoint()).add("ServerType", (Object)this.serverTypeAsString()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "IdentityProviderArn": {
                return Optional.ofNullable(clazz.cast(this.identityProviderArn()));
            }
            case "LicenseServerEndpointArn": {
                return Optional.ofNullable(clazz.cast(this.licenseServerEndpointArn()));
            }
            case "LicenseServerEndpointId": {
                return Optional.ofNullable(clazz.cast(this.licenseServerEndpointId()));
            }
            case "LicenseServerEndpointProvisioningStatus": {
                return Optional.ofNullable(clazz.cast(this.licenseServerEndpointProvisioningStatusAsString()));
            }
            case "LicenseServers": {
                return Optional.ofNullable(clazz.cast(this.licenseServers()));
            }
            case "ServerEndpoint": {
                return Optional.ofNullable(clazz.cast(this.serverEndpoint()));
            }
            case "ServerType": {
                return Optional.ofNullable(clazz.cast(this.serverTypeAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LicenseServerEndpoint, T> g) {
        return obj -> g.apply((LicenseServerEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationTime;
        private String identityProviderArn;
        private String licenseServerEndpointArn;
        private String licenseServerEndpointId;
        private String licenseServerEndpointProvisioningStatus;
        private List<LicenseServer> licenseServers = DefaultSdkAutoConstructList.getInstance();
        private ServerEndpoint serverEndpoint;
        private String serverType;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseServerEndpoint model) {
            this.creationTime(model.creationTime);
            this.identityProviderArn(model.identityProviderArn);
            this.licenseServerEndpointArn(model.licenseServerEndpointArn);
            this.licenseServerEndpointId(model.licenseServerEndpointId);
            this.licenseServerEndpointProvisioningStatus(model.licenseServerEndpointProvisioningStatus);
            this.licenseServers(model.licenseServers);
            this.serverEndpoint(model.serverEndpoint);
            this.serverType(model.serverType);
            this.statusMessage(model.statusMessage);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getIdentityProviderArn() {
            return this.identityProviderArn;
        }

        public final void setIdentityProviderArn(String identityProviderArn) {
            this.identityProviderArn = identityProviderArn;
        }

        @Override
        public final Builder identityProviderArn(String identityProviderArn) {
            this.identityProviderArn = identityProviderArn;
            return this;
        }

        public final String getLicenseServerEndpointArn() {
            return this.licenseServerEndpointArn;
        }

        public final void setLicenseServerEndpointArn(String licenseServerEndpointArn) {
            this.licenseServerEndpointArn = licenseServerEndpointArn;
        }

        @Override
        public final Builder licenseServerEndpointArn(String licenseServerEndpointArn) {
            this.licenseServerEndpointArn = licenseServerEndpointArn;
            return this;
        }

        public final String getLicenseServerEndpointId() {
            return this.licenseServerEndpointId;
        }

        public final void setLicenseServerEndpointId(String licenseServerEndpointId) {
            this.licenseServerEndpointId = licenseServerEndpointId;
        }

        @Override
        public final Builder licenseServerEndpointId(String licenseServerEndpointId) {
            this.licenseServerEndpointId = licenseServerEndpointId;
            return this;
        }

        public final String getLicenseServerEndpointProvisioningStatus() {
            return this.licenseServerEndpointProvisioningStatus;
        }

        public final void setLicenseServerEndpointProvisioningStatus(String licenseServerEndpointProvisioningStatus) {
            this.licenseServerEndpointProvisioningStatus = licenseServerEndpointProvisioningStatus;
        }

        @Override
        public final Builder licenseServerEndpointProvisioningStatus(String licenseServerEndpointProvisioningStatus) {
            this.licenseServerEndpointProvisioningStatus = licenseServerEndpointProvisioningStatus;
            return this;
        }

        @Override
        public final Builder licenseServerEndpointProvisioningStatus(LicenseServerEndpointProvisioningStatus licenseServerEndpointProvisioningStatus) {
            this.licenseServerEndpointProvisioningStatus(licenseServerEndpointProvisioningStatus == null ? null : licenseServerEndpointProvisioningStatus.toString());
            return this;
        }

        public final List<LicenseServer.Builder> getLicenseServers() {
            List<LicenseServer.Builder> result = LicenseServerListCopier.copyToBuilder(this.licenseServers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseServers(Collection<LicenseServer.BuilderImpl> licenseServers) {
            this.licenseServers = LicenseServerListCopier.copyFromBuilder(licenseServers);
        }

        @Override
        public final Builder licenseServers(Collection<LicenseServer> licenseServers) {
            this.licenseServers = LicenseServerListCopier.copy(licenseServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseServers(LicenseServer ... licenseServers) {
            this.licenseServers(Arrays.asList(licenseServers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseServers(Consumer<LicenseServer.Builder> ... licenseServers) {
            this.licenseServers(Stream.of(licenseServers).map(c -> (LicenseServer)((LicenseServer.Builder)LicenseServer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ServerEndpoint.Builder getServerEndpoint() {
            return this.serverEndpoint != null ? this.serverEndpoint.toBuilder() : null;
        }

        public final void setServerEndpoint(ServerEndpoint.BuilderImpl serverEndpoint) {
            this.serverEndpoint = serverEndpoint != null ? serverEndpoint.build() : null;
        }

        @Override
        public final Builder serverEndpoint(ServerEndpoint serverEndpoint) {
            this.serverEndpoint = serverEndpoint;
            return this;
        }

        public final String getServerType() {
            return this.serverType;
        }

        public final void setServerType(String serverType) {
            this.serverType = serverType;
        }

        @Override
        public final Builder serverType(String serverType) {
            this.serverType = serverType;
            return this;
        }

        @Override
        public final Builder serverType(ServerType serverType) {
            this.serverType(serverType == null ? null : serverType.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public LicenseServerEndpoint build() {
            return new LicenseServerEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LicenseServerEndpoint> {
        public Builder creationTime(Instant var1);

        public Builder identityProviderArn(String var1);

        public Builder licenseServerEndpointArn(String var1);

        public Builder licenseServerEndpointId(String var1);

        public Builder licenseServerEndpointProvisioningStatus(String var1);

        public Builder licenseServerEndpointProvisioningStatus(LicenseServerEndpointProvisioningStatus var1);

        public Builder licenseServers(Collection<LicenseServer> var1);

        public Builder licenseServers(LicenseServer ... var1);

        public Builder licenseServers(Consumer<LicenseServer.Builder> ... var1);

        public Builder serverEndpoint(ServerEndpoint var1);

        default public Builder serverEndpoint(Consumer<ServerEndpoint.Builder> serverEndpoint) {
            return this.serverEndpoint((ServerEndpoint)((ServerEndpoint.Builder)ServerEndpoint.builder().applyMutation(serverEndpoint)).build());
        }

        public Builder serverType(String var1);

        public Builder serverType(ServerType var1);

        public Builder statusMessage(String var1);
    }
}

