/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.LicenseManagerUserSubscriptionsClient;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ProductUserSummary;

public class ListProductSubscriptionsIterable
implements SdkIterable<ListProductSubscriptionsResponse> {
    private final LicenseManagerUserSubscriptionsClient client;
    private final ListProductSubscriptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProductSubscriptionsIterable(LicenseManagerUserSubscriptionsClient client, ListProductSubscriptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListProductSubscriptionsResponseFetcher();
    }

    public Iterator<ListProductSubscriptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProductUserSummary> productUserSummaries() {
        Function<ListProductSubscriptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.productUserSummaries() != null) {
                return response.productUserSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProductSubscriptionsResponseFetcher
    implements SyncPageFetcher<ListProductSubscriptionsResponse> {
        private ListProductSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListProductSubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProductSubscriptionsResponse nextPage(ListProductSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return ListProductSubscriptionsIterable.this.client.listProductSubscriptions(ListProductSubscriptionsIterable.this.firstRequest);
            }
            return ListProductSubscriptionsIterable.this.client.listProductSubscriptions((ListProductSubscriptionsRequest)((Object)ListProductSubscriptionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

