/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details discovered information about a running instance using Linux subscriptions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Instance implements SdkPojo, Serializable, ToCopyableBuilder<Instance.Builder, Instance> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountID").getter(getter(Instance::accountID)).setter(setter(Builder::accountID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountID").build()).build();

    private static final SdkField<String> AMI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("AmiId")
            .getter(getter(Instance::amiId)).setter(setter(Builder::amiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiId").build()).build();

    private static final SdkField<String> DUAL_SUBSCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DualSubscription").getter(getter(Instance::dualSubscription)).setter(setter(Builder::dualSubscription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DualSubscription").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceID").getter(getter(Instance::instanceID)).setter(setter(Builder::instanceID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceID").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(Instance::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUpdatedTime").getter(getter(Instance::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> OS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OsVersion").getter(getter(Instance::osVersion)).setter(setter(Builder::osVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OsVersion").build()).build();

    private static final SdkField<List<String>> PRODUCT_CODE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ProductCode")
            .getter(getter(Instance::productCode))
            .setter(setter(Builder::productCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(Instance::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> REGISTERED_WITH_SUBSCRIPTION_PROVIDER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RegisteredWithSubscriptionProvider")
            .getter(getter(Instance::registeredWithSubscriptionProvider))
            .setter(setter(Builder::registeredWithSubscriptionProvider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredWithSubscriptionProvider")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Instance::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SUBSCRIPTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionName").getter(getter(Instance::subscriptionName)).setter(setter(Builder::subscriptionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionName").build()).build();

    private static final SdkField<String> SUBSCRIPTION_PROVIDER_CREATE_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionProviderCreateTime")
            .getter(getter(Instance::subscriptionProviderCreateTime))
            .setter(setter(Builder::subscriptionProviderCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionProviderCreateTime")
                    .build()).build();

    private static final SdkField<String> SUBSCRIPTION_PROVIDER_UPDATE_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionProviderUpdateTime")
            .getter(getter(Instance::subscriptionProviderUpdateTime))
            .setter(setter(Builder::subscriptionProviderUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionProviderUpdateTime")
                    .build()).build();

    private static final SdkField<String> USAGE_OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UsageOperation").getter(getter(Instance::usageOperation)).setter(setter(Builder::usageOperation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageOperation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            AMI_ID_FIELD, DUAL_SUBSCRIPTION_FIELD, INSTANCE_ID_FIELD, INSTANCE_TYPE_FIELD, LAST_UPDATED_TIME_FIELD,
            OS_VERSION_FIELD, PRODUCT_CODE_FIELD, REGION_FIELD, REGISTERED_WITH_SUBSCRIPTION_PROVIDER_FIELD, STATUS_FIELD,
            SUBSCRIPTION_NAME_FIELD, SUBSCRIPTION_PROVIDER_CREATE_TIME_FIELD, SUBSCRIPTION_PROVIDER_UPDATE_TIME_FIELD,
            USAGE_OPERATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountID;

    private final String amiId;

    private final String dualSubscription;

    private final String instanceID;

    private final String instanceType;

    private final String lastUpdatedTime;

    private final String osVersion;

    private final List<String> productCode;

    private final String region;

    private final String registeredWithSubscriptionProvider;

    private final String status;

    private final String subscriptionName;

    private final String subscriptionProviderCreateTime;

    private final String subscriptionProviderUpdateTime;

    private final String usageOperation;

    private Instance(BuilderImpl builder) {
        this.accountID = builder.accountID;
        this.amiId = builder.amiId;
        this.dualSubscription = builder.dualSubscription;
        this.instanceID = builder.instanceID;
        this.instanceType = builder.instanceType;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.osVersion = builder.osVersion;
        this.productCode = builder.productCode;
        this.region = builder.region;
        this.registeredWithSubscriptionProvider = builder.registeredWithSubscriptionProvider;
        this.status = builder.status;
        this.subscriptionName = builder.subscriptionName;
        this.subscriptionProviderCreateTime = builder.subscriptionProviderCreateTime;
        this.subscriptionProviderUpdateTime = builder.subscriptionProviderUpdateTime;
        this.usageOperation = builder.usageOperation;
    }

    /**
     * <p>
     * The account ID which owns the instance.
     * </p>
     * 
     * @return The account ID which owns the instance.
     */
    public final String accountID() {
        return accountID;
    }

    /**
     * <p>
     * The AMI ID used to launch the instance.
     * </p>
     * 
     * @return The AMI ID used to launch the instance.
     */
    public final String amiId() {
        return amiId;
    }

    /**
     * <p>
     * Indicates that you have two different license subscriptions for the same software on your instance.
     * </p>
     * 
     * @return Indicates that you have two different license subscriptions for the same software on your instance.
     */
    public final String dualSubscription() {
        return dualSubscription;
    }

    /**
     * <p>
     * The instance ID of the resource.
     * </p>
     * 
     * @return The instance ID of the resource.
     */
    public final String instanceID() {
        return instanceID;
    }

    /**
     * <p>
     * The instance type of the resource.
     * </p>
     * 
     * @return The instance type of the resource.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The time in which the last discovery updated the instance details.
     * </p>
     * 
     * @return The time in which the last discovery updated the instance details.
     */
    public final String lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The operating system software version that runs on your instance.
     * </p>
     * 
     * @return The operating system software version that runs on your instance.
     */
    public final String osVersion() {
        return osVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProductCode property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProductCode() {
        return productCode != null && !(productCode instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The product code for the instance. For more information, see <a
     * href="https://docs.aws.amazon.com/license-manager/latest/userguide/linux-subscriptions-usage-operation.html"
     * >Usage operation values</a> in the <i>License Manager User Guide</i> .
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProductCode} method.
     * </p>
     * 
     * @return The product code for the instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/license-manager/latest/userguide/linux-subscriptions-usage-operation.html"
     *         >Usage operation values</a> in the <i>License Manager User Guide</i> .
     */
    public final List<String> productCode() {
        return productCode;
    }

    /**
     * <p>
     * The Region the instance is running in.
     * </p>
     * 
     * @return The Region the instance is running in.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * Indicates that your instance uses a BYOL license subscription from a third-party Linux subscription provider that
     * you've registered with License Manager.
     * </p>
     * 
     * @return Indicates that your instance uses a BYOL license subscription from a third-party Linux subscription
     *         provider that you've registered with License Manager.
     */
    public final String registeredWithSubscriptionProvider() {
        return registeredWithSubscriptionProvider;
    }

    /**
     * <p>
     * The status of the instance.
     * </p>
     * 
     * @return The status of the instance.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The name of the license subscription that the instance uses.
     * </p>
     * 
     * @return The name of the license subscription that the instance uses.
     */
    public final String subscriptionName() {
        return subscriptionName;
    }

    /**
     * <p>
     * The timestamp when you registered the third-party Linux subscription provider for the subscription that the
     * instance uses.
     * </p>
     * 
     * @return The timestamp when you registered the third-party Linux subscription provider for the subscription that
     *         the instance uses.
     */
    public final String subscriptionProviderCreateTime() {
        return subscriptionProviderCreateTime;
    }

    /**
     * <p>
     * The timestamp from the last time that the instance synced with the registered third-party Linux subscription
     * provider.
     * </p>
     * 
     * @return The timestamp from the last time that the instance synced with the registered third-party Linux
     *         subscription provider.
     */
    public final String subscriptionProviderUpdateTime() {
        return subscriptionProviderUpdateTime;
    }

    /**
     * <p>
     * The usage operation of the instance. For more information, see For more information, see <a
     * href="https://docs.aws.amazon.com/license-manager/latest/userguide/linux-subscriptions-usage-operation.html"
     * >Usage operation values</a> in the <i>License Manager User Guide</i>.
     * </p>
     * 
     * @return The usage operation of the instance. For more information, see For more information, see <a
     *         href="https://docs.aws.amazon.com/license-manager/latest/userguide/linux-subscriptions-usage-operation.html"
     *         >Usage operation values</a> in the <i>License Manager User Guide</i>.
     */
    public final String usageOperation() {
        return usageOperation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountID());
        hashCode = 31 * hashCode + Objects.hashCode(amiId());
        hashCode = 31 * hashCode + Objects.hashCode(dualSubscription());
        hashCode = 31 * hashCode + Objects.hashCode(instanceID());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(osVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasProductCode() ? productCode() : null);
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(registeredWithSubscriptionProvider());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionName());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionProviderCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionProviderUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(usageOperation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance) obj;
        return Objects.equals(accountID(), other.accountID()) && Objects.equals(amiId(), other.amiId())
                && Objects.equals(dualSubscription(), other.dualSubscription())
                && Objects.equals(instanceID(), other.instanceID()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(osVersion(), other.osVersion())
                && hasProductCode() == other.hasProductCode() && Objects.equals(productCode(), other.productCode())
                && Objects.equals(region(), other.region())
                && Objects.equals(registeredWithSubscriptionProvider(), other.registeredWithSubscriptionProvider())
                && Objects.equals(status(), other.status()) && Objects.equals(subscriptionName(), other.subscriptionName())
                && Objects.equals(subscriptionProviderCreateTime(), other.subscriptionProviderCreateTime())
                && Objects.equals(subscriptionProviderUpdateTime(), other.subscriptionProviderUpdateTime())
                && Objects.equals(usageOperation(), other.usageOperation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Instance").add("AccountID", accountID()).add("AmiId", amiId())
                .add("DualSubscription", dualSubscription()).add("InstanceID", instanceID()).add("InstanceType", instanceType())
                .add("LastUpdatedTime", lastUpdatedTime()).add("OsVersion", osVersion())
                .add("ProductCode", hasProductCode() ? productCode() : null).add("Region", region())
                .add("RegisteredWithSubscriptionProvider", registeredWithSubscriptionProvider()).add("Status", status())
                .add("SubscriptionName", subscriptionName())
                .add("SubscriptionProviderCreateTime", subscriptionProviderCreateTime())
                .add("SubscriptionProviderUpdateTime", subscriptionProviderUpdateTime()).add("UsageOperation", usageOperation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountID":
            return Optional.ofNullable(clazz.cast(accountID()));
        case "AmiId":
            return Optional.ofNullable(clazz.cast(amiId()));
        case "DualSubscription":
            return Optional.ofNullable(clazz.cast(dualSubscription()));
        case "InstanceID":
            return Optional.ofNullable(clazz.cast(instanceID()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "OsVersion":
            return Optional.ofNullable(clazz.cast(osVersion()));
        case "ProductCode":
            return Optional.ofNullable(clazz.cast(productCode()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "RegisteredWithSubscriptionProvider":
            return Optional.ofNullable(clazz.cast(registeredWithSubscriptionProvider()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "SubscriptionName":
            return Optional.ofNullable(clazz.cast(subscriptionName()));
        case "SubscriptionProviderCreateTime":
            return Optional.ofNullable(clazz.cast(subscriptionProviderCreateTime()));
        case "SubscriptionProviderUpdateTime":
            return Optional.ofNullable(clazz.cast(subscriptionProviderUpdateTime()));
        case "UsageOperation":
            return Optional.ofNullable(clazz.cast(usageOperation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountID", ACCOUNT_ID_FIELD);
        map.put("AmiId", AMI_ID_FIELD);
        map.put("DualSubscription", DUAL_SUBSCRIPTION_FIELD);
        map.put("InstanceID", INSTANCE_ID_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("OsVersion", OS_VERSION_FIELD);
        map.put("ProductCode", PRODUCT_CODE_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("RegisteredWithSubscriptionProvider", REGISTERED_WITH_SUBSCRIPTION_PROVIDER_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("SubscriptionName", SUBSCRIPTION_NAME_FIELD);
        map.put("SubscriptionProviderCreateTime", SUBSCRIPTION_PROVIDER_CREATE_TIME_FIELD);
        map.put("SubscriptionProviderUpdateTime", SUBSCRIPTION_PROVIDER_UPDATE_TIME_FIELD);
        map.put("UsageOperation", USAGE_OPERATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Instance, T> g) {
        return obj -> g.apply((Instance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Instance> {
        /**
         * <p>
         * The account ID which owns the instance.
         * </p>
         * 
         * @param accountID
         *        The account ID which owns the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountID(String accountID);

        /**
         * <p>
         * The AMI ID used to launch the instance.
         * </p>
         * 
         * @param amiId
         *        The AMI ID used to launch the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiId(String amiId);

        /**
         * <p>
         * Indicates that you have two different license subscriptions for the same software on your instance.
         * </p>
         * 
         * @param dualSubscription
         *        Indicates that you have two different license subscriptions for the same software on your instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dualSubscription(String dualSubscription);

        /**
         * <p>
         * The instance ID of the resource.
         * </p>
         * 
         * @param instanceID
         *        The instance ID of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceID(String instanceID);

        /**
         * <p>
         * The instance type of the resource.
         * </p>
         * 
         * @param instanceType
         *        The instance type of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The time in which the last discovery updated the instance details.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time in which the last discovery updated the instance details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(String lastUpdatedTime);

        /**
         * <p>
         * The operating system software version that runs on your instance.
         * </p>
         * 
         * @param osVersion
         *        The operating system software version that runs on your instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder osVersion(String osVersion);

        /**
         * <p>
         * The product code for the instance. For more information, see <a href=
         * "https://docs.aws.amazon.com/license-manager/latest/userguide/linux-subscriptions-usage-operation.html">Usage
         * operation values</a> in the <i>License Manager User Guide</i> .
         * </p>
         * 
         * @param productCode
         *        The product code for the instance. For more information, see <a href=
         *        "https://docs.aws.amazon.com/license-manager/latest/userguide/linux-subscriptions-usage-operation.html"
         *        >Usage operation values</a> in the <i>License Manager User Guide</i> .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCode(Collection<String> productCode);

        /**
         * <p>
         * The product code for the instance. For more information, see <a href=
         * "https://docs.aws.amazon.com/license-manager/latest/userguide/linux-subscriptions-usage-operation.html">Usage
         * operation values</a> in the <i>License Manager User Guide</i> .
         * </p>
         * 
         * @param productCode
         *        The product code for the instance. For more information, see <a href=
         *        "https://docs.aws.amazon.com/license-manager/latest/userguide/linux-subscriptions-usage-operation.html"
         *        >Usage operation values</a> in the <i>License Manager User Guide</i> .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCode(String... productCode);

        /**
         * <p>
         * The Region the instance is running in.
         * </p>
         * 
         * @param region
         *        The Region the instance is running in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * Indicates that your instance uses a BYOL license subscription from a third-party Linux subscription provider
         * that you've registered with License Manager.
         * </p>
         * 
         * @param registeredWithSubscriptionProvider
         *        Indicates that your instance uses a BYOL license subscription from a third-party Linux subscription
         *        provider that you've registered with License Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredWithSubscriptionProvider(String registeredWithSubscriptionProvider);

        /**
         * <p>
         * The status of the instance.
         * </p>
         * 
         * @param status
         *        The status of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The name of the license subscription that the instance uses.
         * </p>
         * 
         * @param subscriptionName
         *        The name of the license subscription that the instance uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionName(String subscriptionName);

        /**
         * <p>
         * The timestamp when you registered the third-party Linux subscription provider for the subscription that the
         * instance uses.
         * </p>
         * 
         * @param subscriptionProviderCreateTime
         *        The timestamp when you registered the third-party Linux subscription provider for the subscription
         *        that the instance uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionProviderCreateTime(String subscriptionProviderCreateTime);

        /**
         * <p>
         * The timestamp from the last time that the instance synced with the registered third-party Linux subscription
         * provider.
         * </p>
         * 
         * @param subscriptionProviderUpdateTime
         *        The timestamp from the last time that the instance synced with the registered third-party Linux
         *        subscription provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionProviderUpdateTime(String subscriptionProviderUpdateTime);

        /**
         * <p>
         * The usage operation of the instance. For more information, see For more information, see <a href=
         * "https://docs.aws.amazon.com/license-manager/latest/userguide/linux-subscriptions-usage-operation.html">Usage
         * operation values</a> in the <i>License Manager User Guide</i>.
         * </p>
         * 
         * @param usageOperation
         *        The usage operation of the instance. For more information, see For more information, see <a href=
         *        "https://docs.aws.amazon.com/license-manager/latest/userguide/linux-subscriptions-usage-operation.html"
         *        >Usage operation values</a> in the <i>License Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageOperation(String usageOperation);
    }

    static final class BuilderImpl implements Builder {
        private String accountID;

        private String amiId;

        private String dualSubscription;

        private String instanceID;

        private String instanceType;

        private String lastUpdatedTime;

        private String osVersion;

        private List<String> productCode = DefaultSdkAutoConstructList.getInstance();

        private String region;

        private String registeredWithSubscriptionProvider;

        private String status;

        private String subscriptionName;

        private String subscriptionProviderCreateTime;

        private String subscriptionProviderUpdateTime;

        private String usageOperation;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            accountID(model.accountID);
            amiId(model.amiId);
            dualSubscription(model.dualSubscription);
            instanceID(model.instanceID);
            instanceType(model.instanceType);
            lastUpdatedTime(model.lastUpdatedTime);
            osVersion(model.osVersion);
            productCode(model.productCode);
            region(model.region);
            registeredWithSubscriptionProvider(model.registeredWithSubscriptionProvider);
            status(model.status);
            subscriptionName(model.subscriptionName);
            subscriptionProviderCreateTime(model.subscriptionProviderCreateTime);
            subscriptionProviderUpdateTime(model.subscriptionProviderUpdateTime);
            usageOperation(model.usageOperation);
        }

        public final String getAccountID() {
            return accountID;
        }

        public final void setAccountID(String accountID) {
            this.accountID = accountID;
        }

        @Override
        public final Builder accountID(String accountID) {
            this.accountID = accountID;
            return this;
        }

        public final String getAmiId() {
            return amiId;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final String getDualSubscription() {
            return dualSubscription;
        }

        public final void setDualSubscription(String dualSubscription) {
            this.dualSubscription = dualSubscription;
        }

        @Override
        public final Builder dualSubscription(String dualSubscription) {
            this.dualSubscription = dualSubscription;
            return this;
        }

        public final String getInstanceID() {
            return instanceID;
        }

        public final void setInstanceID(String instanceID) {
            this.instanceID = instanceID;
        }

        @Override
        public final Builder instanceID(String instanceID) {
            this.instanceID = instanceID;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getOsVersion() {
            return osVersion;
        }

        public final void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        @Override
        public final Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public final Collection<String> getProductCode() {
            if (productCode instanceof SdkAutoConstructList) {
                return null;
            }
            return productCode;
        }

        public final void setProductCode(Collection<String> productCode) {
            this.productCode = ProductCodeListCopier.copy(productCode);
        }

        @Override
        public final Builder productCode(Collection<String> productCode) {
            this.productCode = ProductCodeListCopier.copy(productCode);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCode(String... productCode) {
            productCode(Arrays.asList(productCode));
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getRegisteredWithSubscriptionProvider() {
            return registeredWithSubscriptionProvider;
        }

        public final void setRegisteredWithSubscriptionProvider(String registeredWithSubscriptionProvider) {
            this.registeredWithSubscriptionProvider = registeredWithSubscriptionProvider;
        }

        @Override
        public final Builder registeredWithSubscriptionProvider(String registeredWithSubscriptionProvider) {
            this.registeredWithSubscriptionProvider = registeredWithSubscriptionProvider;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getSubscriptionName() {
            return subscriptionName;
        }

        public final void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        @Override
        public final Builder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public final String getSubscriptionProviderCreateTime() {
            return subscriptionProviderCreateTime;
        }

        public final void setSubscriptionProviderCreateTime(String subscriptionProviderCreateTime) {
            this.subscriptionProviderCreateTime = subscriptionProviderCreateTime;
        }

        @Override
        public final Builder subscriptionProviderCreateTime(String subscriptionProviderCreateTime) {
            this.subscriptionProviderCreateTime = subscriptionProviderCreateTime;
            return this;
        }

        public final String getSubscriptionProviderUpdateTime() {
            return subscriptionProviderUpdateTime;
        }

        public final void setSubscriptionProviderUpdateTime(String subscriptionProviderUpdateTime) {
            this.subscriptionProviderUpdateTime = subscriptionProviderUpdateTime;
        }

        @Override
        public final Builder subscriptionProviderUpdateTime(String subscriptionProviderUpdateTime) {
            this.subscriptionProviderUpdateTime = subscriptionProviderUpdateTime;
            return this;
        }

        public final String getUsageOperation() {
            return usageOperation;
        }

        public final void setUsageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
        }

        @Override
        public final Builder usageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
            return this;
        }

        @Override
        public Instance build() {
            return new Instance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
