/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LicenseManagerLinuxSubscriptionsRequest;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.SubscriptionProviderSource;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.SubscriptionProviderSourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRegisteredSubscriptionProvidersRequest
extends LicenseManagerLinuxSubscriptionsRequest
implements ToCopyableBuilder<Builder, ListRegisteredSubscriptionProvidersRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListRegisteredSubscriptionProvidersRequest.getter(ListRegisteredSubscriptionProvidersRequest::maxResults)).setter(ListRegisteredSubscriptionProvidersRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRegisteredSubscriptionProvidersRequest.getter(ListRegisteredSubscriptionProvidersRequest::nextToken)).setter(ListRegisteredSubscriptionProvidersRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<String>> SUBSCRIPTION_PROVIDER_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubscriptionProviderSources").getter(ListRegisteredSubscriptionProvidersRequest.getter(ListRegisteredSubscriptionProvidersRequest::subscriptionProviderSourcesAsStrings)).setter(ListRegisteredSubscriptionProvidersRequest.setter(Builder::subscriptionProviderSourcesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionProviderSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SUBSCRIPTION_PROVIDER_SOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRegisteredSubscriptionProvidersRequest.memberNameToFieldInitializer();
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> subscriptionProviderSources;

    private ListRegisteredSubscriptionProvidersRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.subscriptionProviderSources = builder.subscriptionProviderSources;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final List<SubscriptionProviderSource> subscriptionProviderSources() {
        return SubscriptionProviderSourceListCopier.copyStringToEnum(this.subscriptionProviderSources);
    }

    public final boolean hasSubscriptionProviderSources() {
        return this.subscriptionProviderSources != null && !(this.subscriptionProviderSources instanceof SdkAutoConstructList);
    }

    public final List<String> subscriptionProviderSourcesAsStrings() {
        return this.subscriptionProviderSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscriptionProviderSources() ? this.subscriptionProviderSourcesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRegisteredSubscriptionProvidersRequest)) {
            return false;
        }
        ListRegisteredSubscriptionProvidersRequest other = (ListRegisteredSubscriptionProvidersRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasSubscriptionProviderSources() == other.hasSubscriptionProviderSources() && Objects.equals(this.subscriptionProviderSourcesAsStrings(), other.subscriptionProviderSourcesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ListRegisteredSubscriptionProvidersRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("SubscriptionProviderSources", this.hasSubscriptionProviderSources() ? this.subscriptionProviderSourcesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "SubscriptionProviderSources": {
                return Optional.ofNullable(clazz.cast(this.subscriptionProviderSourcesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("SubscriptionProviderSources", SUBSCRIPTION_PROVIDER_SOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRegisteredSubscriptionProvidersRequest, T> g) {
        return obj -> g.apply((ListRegisteredSubscriptionProvidersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerLinuxSubscriptionsRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private List<String> subscriptionProviderSources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRegisteredSubscriptionProvidersRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.subscriptionProviderSourcesWithStrings(model.subscriptionProviderSources);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getSubscriptionProviderSources() {
            if (this.subscriptionProviderSources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subscriptionProviderSources;
        }

        public final void setSubscriptionProviderSources(Collection<String> subscriptionProviderSources) {
            this.subscriptionProviderSources = SubscriptionProviderSourceListCopier.copy(subscriptionProviderSources);
        }

        @Override
        public final Builder subscriptionProviderSourcesWithStrings(Collection<String> subscriptionProviderSources) {
            this.subscriptionProviderSources = SubscriptionProviderSourceListCopier.copy(subscriptionProviderSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionProviderSourcesWithStrings(String ... subscriptionProviderSources) {
            this.subscriptionProviderSourcesWithStrings(Arrays.asList(subscriptionProviderSources));
            return this;
        }

        @Override
        public final Builder subscriptionProviderSources(Collection<SubscriptionProviderSource> subscriptionProviderSources) {
            this.subscriptionProviderSources = SubscriptionProviderSourceListCopier.copyEnumToString(subscriptionProviderSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionProviderSources(SubscriptionProviderSource ... subscriptionProviderSources) {
            this.subscriptionProviderSources(Arrays.asList(subscriptionProviderSources));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRegisteredSubscriptionProvidersRequest build() {
            return new ListRegisteredSubscriptionProvidersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LicenseManagerLinuxSubscriptionsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRegisteredSubscriptionProvidersRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder subscriptionProviderSourcesWithStrings(Collection<String> var1);

        public Builder subscriptionProviderSourcesWithStrings(String ... var1);

        public Builder subscriptionProviderSources(Collection<SubscriptionProviderSource> var1);

        public Builder subscriptionProviderSources(SubscriptionProviderSource ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

