/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.LicenseManagerLinuxSubscriptionsAsyncClient;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.internal.UserAgentUtils;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.Subscription;

public class ListLinuxSubscriptionsPublisher
implements SdkPublisher<ListLinuxSubscriptionsResponse> {
    private final LicenseManagerLinuxSubscriptionsAsyncClient client;
    private final ListLinuxSubscriptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLinuxSubscriptionsPublisher(LicenseManagerLinuxSubscriptionsAsyncClient client, ListLinuxSubscriptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLinuxSubscriptionsPublisher(LicenseManagerLinuxSubscriptionsAsyncClient client, ListLinuxSubscriptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLinuxSubscriptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLinuxSubscriptionsResponse> subscriber) {
        subscriber.onSubscribe((org.reactivestreams.Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Subscription> subscriptions() {
        Function<ListLinuxSubscriptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.subscriptions() != null) {
                return response.subscriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLinuxSubscriptionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLinuxSubscriptionsResponseFetcher
    implements AsyncPageFetcher<ListLinuxSubscriptionsResponse> {
        private ListLinuxSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListLinuxSubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLinuxSubscriptionsResponse> nextPage(ListLinuxSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return ListLinuxSubscriptionsPublisher.this.client.listLinuxSubscriptions(ListLinuxSubscriptionsPublisher.this.firstRequest);
            }
            return ListLinuxSubscriptionsPublisher.this.client.listLinuxSubscriptions((ListLinuxSubscriptionsRequest)((Object)ListLinuxSubscriptionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

