/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.LicenseManagerLinuxSubscriptionsClient;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.Subscription;

public class ListLinuxSubscriptionsIterable
implements SdkIterable<ListLinuxSubscriptionsResponse> {
    private final LicenseManagerLinuxSubscriptionsClient client;
    private final ListLinuxSubscriptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLinuxSubscriptionsIterable(LicenseManagerLinuxSubscriptionsClient client, ListLinuxSubscriptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLinuxSubscriptionsResponseFetcher();
    }

    public Iterator<ListLinuxSubscriptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Subscription> subscriptions() {
        Function<ListLinuxSubscriptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.subscriptions() != null) {
                return response.subscriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLinuxSubscriptionsResponseFetcher
    implements SyncPageFetcher<ListLinuxSubscriptionsResponse> {
        private ListLinuxSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListLinuxSubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLinuxSubscriptionsResponse nextPage(ListLinuxSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return ListLinuxSubscriptionsIterable.this.client.listLinuxSubscriptions(ListLinuxSubscriptionsIterable.this.firstRequest);
            }
            return ListLinuxSubscriptionsIterable.this.client.listLinuxSubscriptions((ListLinuxSubscriptionsRequest)((Object)ListLinuxSubscriptionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

