/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerResponse;
import software.amazon.awssdk.services.licensemanager.model.ResourceInventory;
import software.amazon.awssdk.services.licensemanager.model.ResourceInventoryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceInventoryResponse
extends LicenseManagerResponse
implements ToCopyableBuilder<Builder, ListResourceInventoryResponse> {
    private static final SdkField<List<ResourceInventory>> RESOURCE_INVENTORY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceInventoryList").getter(ListResourceInventoryResponse.getter(ListResourceInventoryResponse::resourceInventoryList)).setter(ListResourceInventoryResponse.setter(Builder::resourceInventoryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceInventoryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceInventory::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResourceInventoryResponse.getter(ListResourceInventoryResponse::nextToken)).setter(ListResourceInventoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_INVENTORY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListResourceInventoryResponse.memberNameToFieldInitializer();
    private final List<ResourceInventory> resourceInventoryList;
    private final String nextToken;

    private ListResourceInventoryResponse(BuilderImpl builder) {
        super(builder);
        this.resourceInventoryList = builder.resourceInventoryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasResourceInventoryList() {
        return this.resourceInventoryList != null && !(this.resourceInventoryList instanceof SdkAutoConstructList);
    }

    public final List<ResourceInventory> resourceInventoryList() {
        return this.resourceInventoryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceInventoryList() ? this.resourceInventoryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceInventoryResponse)) {
            return false;
        }
        ListResourceInventoryResponse other = (ListResourceInventoryResponse)((Object)obj);
        return this.hasResourceInventoryList() == other.hasResourceInventoryList() && Objects.equals(this.resourceInventoryList(), other.resourceInventoryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourceInventoryResponse").add("ResourceInventoryList", this.hasResourceInventoryList() ? this.resourceInventoryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceInventoryList": {
                return Optional.ofNullable(clazz.cast(this.resourceInventoryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceInventoryList", RESOURCE_INVENTORY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceInventoryResponse, T> g) {
        return obj -> g.apply((ListResourceInventoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerResponse.BuilderImpl
    implements Builder {
        private List<ResourceInventory> resourceInventoryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceInventoryResponse model) {
            super(model);
            this.resourceInventoryList(model.resourceInventoryList);
            this.nextToken(model.nextToken);
        }

        public final List<ResourceInventory.Builder> getResourceInventoryList() {
            List<ResourceInventory.Builder> result = ResourceInventoryListCopier.copyToBuilder(this.resourceInventoryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceInventoryList(Collection<ResourceInventory.BuilderImpl> resourceInventoryList) {
            this.resourceInventoryList = ResourceInventoryListCopier.copyFromBuilder(resourceInventoryList);
        }

        @Override
        public final Builder resourceInventoryList(Collection<ResourceInventory> resourceInventoryList) {
            this.resourceInventoryList = ResourceInventoryListCopier.copy(resourceInventoryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceInventoryList(ResourceInventory ... resourceInventoryList) {
            this.resourceInventoryList(Arrays.asList(resourceInventoryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceInventoryList(Consumer<ResourceInventory.Builder> ... resourceInventoryList) {
            this.resourceInventoryList(Stream.of(resourceInventoryList).map(c -> (ResourceInventory)((ResourceInventory.Builder)ResourceInventory.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourceInventoryResponse build() {
            return new ListResourceInventoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LicenseManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceInventoryResponse> {
        public Builder resourceInventoryList(Collection<ResourceInventory> var1);

        public Builder resourceInventoryList(ResourceInventory ... var1);

        public Builder resourceInventoryList(Consumer<ResourceInventory.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

