/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.licensemanager.model.LicenseConversionContext;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLicenseConversionTaskForResourceRequest
extends LicenseManagerRequest
implements ToCopyableBuilder<Builder, CreateLicenseConversionTaskForResourceRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(CreateLicenseConversionTaskForResourceRequest.getter(CreateLicenseConversionTaskForResourceRequest::resourceArn)).setter(CreateLicenseConversionTaskForResourceRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<LicenseConversionContext> SOURCE_LICENSE_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceLicenseContext").getter(CreateLicenseConversionTaskForResourceRequest.getter(CreateLicenseConversionTaskForResourceRequest::sourceLicenseContext)).setter(CreateLicenseConversionTaskForResourceRequest.setter(Builder::sourceLicenseContext)).constructor(LicenseConversionContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLicenseContext").build()}).build();
    private static final SdkField<LicenseConversionContext> DESTINATION_LICENSE_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationLicenseContext").getter(CreateLicenseConversionTaskForResourceRequest.getter(CreateLicenseConversionTaskForResourceRequest::destinationLicenseContext)).setter(CreateLicenseConversionTaskForResourceRequest.setter(Builder::destinationLicenseContext)).constructor(LicenseConversionContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationLicenseContext").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, SOURCE_LICENSE_CONTEXT_FIELD, DESTINATION_LICENSE_CONTEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLicenseConversionTaskForResourceRequest.memberNameToFieldInitializer();
    private final String resourceArn;
    private final LicenseConversionContext sourceLicenseContext;
    private final LicenseConversionContext destinationLicenseContext;

    private CreateLicenseConversionTaskForResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.sourceLicenseContext = builder.sourceLicenseContext;
        this.destinationLicenseContext = builder.destinationLicenseContext;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final LicenseConversionContext sourceLicenseContext() {
        return this.sourceLicenseContext;
    }

    public final LicenseConversionContext destinationLicenseContext() {
        return this.destinationLicenseContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLicenseContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationLicenseContext());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLicenseConversionTaskForResourceRequest)) {
            return false;
        }
        CreateLicenseConversionTaskForResourceRequest other = (CreateLicenseConversionTaskForResourceRequest)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.sourceLicenseContext(), other.sourceLicenseContext()) && Objects.equals(this.destinationLicenseContext(), other.destinationLicenseContext());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLicenseConversionTaskForResourceRequest").add("ResourceArn", (Object)this.resourceArn()).add("SourceLicenseContext", (Object)this.sourceLicenseContext()).add("DestinationLicenseContext", (Object)this.destinationLicenseContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "SourceLicenseContext": {
                return Optional.ofNullable(clazz.cast(this.sourceLicenseContext()));
            }
            case "DestinationLicenseContext": {
                return Optional.ofNullable(clazz.cast(this.destinationLicenseContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("SourceLicenseContext", SOURCE_LICENSE_CONTEXT_FIELD);
        map.put("DestinationLicenseContext", DESTINATION_LICENSE_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLicenseConversionTaskForResourceRequest, T> g) {
        return obj -> g.apply((CreateLicenseConversionTaskForResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerRequest.BuilderImpl
    implements Builder {
        private String resourceArn;
        private LicenseConversionContext sourceLicenseContext;
        private LicenseConversionContext destinationLicenseContext;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLicenseConversionTaskForResourceRequest model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.sourceLicenseContext(model.sourceLicenseContext);
            this.destinationLicenseContext(model.destinationLicenseContext);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final LicenseConversionContext.Builder getSourceLicenseContext() {
            return this.sourceLicenseContext != null ? this.sourceLicenseContext.toBuilder() : null;
        }

        public final void setSourceLicenseContext(LicenseConversionContext.BuilderImpl sourceLicenseContext) {
            this.sourceLicenseContext = sourceLicenseContext != null ? sourceLicenseContext.build() : null;
        }

        @Override
        public final Builder sourceLicenseContext(LicenseConversionContext sourceLicenseContext) {
            this.sourceLicenseContext = sourceLicenseContext;
            return this;
        }

        public final LicenseConversionContext.Builder getDestinationLicenseContext() {
            return this.destinationLicenseContext != null ? this.destinationLicenseContext.toBuilder() : null;
        }

        public final void setDestinationLicenseContext(LicenseConversionContext.BuilderImpl destinationLicenseContext) {
            this.destinationLicenseContext = destinationLicenseContext != null ? destinationLicenseContext.build() : null;
        }

        @Override
        public final Builder destinationLicenseContext(LicenseConversionContext destinationLicenseContext) {
            this.destinationLicenseContext = destinationLicenseContext;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLicenseConversionTaskForResourceRequest build() {
            return new CreateLicenseConversionTaskForResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LicenseManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLicenseConversionTaskForResourceRequest> {
        public Builder resourceArn(String var1);

        public Builder sourceLicenseContext(LicenseConversionContext var1);

        default public Builder sourceLicenseContext(Consumer<LicenseConversionContext.Builder> sourceLicenseContext) {
            return this.sourceLicenseContext((LicenseConversionContext)((LicenseConversionContext.Builder)LicenseConversionContext.builder().applyMutation(sourceLicenseContext)).build());
        }

        public Builder destinationLicenseContext(LicenseConversionContext var1);

        default public Builder destinationLicenseContext(Consumer<LicenseConversionContext.Builder> destinationLicenseContext) {
            return this.destinationLicenseContext((LicenseConversionContext)((LicenseConversionContext.Builder)LicenseConversionContext.builder().applyMutation(destinationLicenseContext)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

