/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.AutomatedDiscoveryInformation;
import software.amazon.awssdk.services.licensemanager.model.ConsumedLicenseSummary;
import software.amazon.awssdk.services.licensemanager.model.ConsumedLicenseSummaryListCopier;
import software.amazon.awssdk.services.licensemanager.model.LicenseCountingType;
import software.amazon.awssdk.services.licensemanager.model.ManagedResourceSummary;
import software.amazon.awssdk.services.licensemanager.model.ManagedResourceSummaryListCopier;
import software.amazon.awssdk.services.licensemanager.model.ProductInformation;
import software.amazon.awssdk.services.licensemanager.model.ProductInformationListCopier;
import software.amazon.awssdk.services.licensemanager.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LicenseConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LicenseConfiguration> {
    private static final SdkField<String> LICENSE_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseConfigurationId").getter(LicenseConfiguration.getter(LicenseConfiguration::licenseConfigurationId)).setter(LicenseConfiguration.setter(Builder::licenseConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConfigurationId").build()}).build();
    private static final SdkField<String> LICENSE_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseConfigurationArn").getter(LicenseConfiguration.getter(LicenseConfiguration::licenseConfigurationArn)).setter(LicenseConfiguration.setter(Builder::licenseConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConfigurationArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(LicenseConfiguration.getter(LicenseConfiguration::name)).setter(LicenseConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(LicenseConfiguration.getter(LicenseConfiguration::description)).setter(LicenseConfiguration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> LICENSE_COUNTING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseCountingType").getter(LicenseConfiguration.getter(LicenseConfiguration::licenseCountingTypeAsString)).setter(LicenseConfiguration.setter(Builder::licenseCountingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseCountingType").build()}).build();
    private static final SdkField<List<String>> LICENSE_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LicenseRules").getter(LicenseConfiguration.getter(LicenseConfiguration::licenseRules)).setter(LicenseConfiguration.setter(Builder::licenseRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> LICENSE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LicenseCount").getter(LicenseConfiguration.getter(LicenseConfiguration::licenseCount)).setter(LicenseConfiguration.setter(Builder::licenseCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseCount").build()}).build();
    private static final SdkField<Boolean> LICENSE_COUNT_HARD_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("LicenseCountHardLimit").getter(LicenseConfiguration.getter(LicenseConfiguration::licenseCountHardLimit)).setter(LicenseConfiguration.setter(Builder::licenseCountHardLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseCountHardLimit").build()}).build();
    private static final SdkField<Boolean> DISASSOCIATE_WHEN_NOT_FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisassociateWhenNotFound").getter(LicenseConfiguration.getter(LicenseConfiguration::disassociateWhenNotFound)).setter(LicenseConfiguration.setter(Builder::disassociateWhenNotFound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisassociateWhenNotFound").build()}).build();
    private static final SdkField<Long> CONSUMED_LICENSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ConsumedLicenses").getter(LicenseConfiguration.getter(LicenseConfiguration::consumedLicenses)).setter(LicenseConfiguration.setter(Builder::consumedLicenses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedLicenses").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(LicenseConfiguration.getter(LicenseConfiguration::status)).setter(LicenseConfiguration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccountId").getter(LicenseConfiguration.getter(LicenseConfiguration::ownerAccountId)).setter(LicenseConfiguration.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()}).build();
    private static final SdkField<List<ConsumedLicenseSummary>> CONSUMED_LICENSE_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConsumedLicenseSummaryList").getter(LicenseConfiguration.getter(LicenseConfiguration::consumedLicenseSummaryList)).setter(LicenseConfiguration.setter(Builder::consumedLicenseSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedLicenseSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConsumedLicenseSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ManagedResourceSummary>> MANAGED_RESOURCE_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ManagedResourceSummaryList").getter(LicenseConfiguration.getter(LicenseConfiguration::managedResourceSummaryList)).setter(LicenseConfiguration.setter(Builder::managedResourceSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedResourceSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedResourceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ProductInformation>> PRODUCT_INFORMATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductInformationList").getter(LicenseConfiguration.getter(LicenseConfiguration::productInformationList)).setter(LicenseConfiguration.setter(Builder::productInformationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductInformationList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AutomatedDiscoveryInformation> AUTOMATED_DISCOVERY_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutomatedDiscoveryInformation").getter(LicenseConfiguration.getter(LicenseConfiguration::automatedDiscoveryInformation)).setter(LicenseConfiguration.setter(Builder::automatedDiscoveryInformation)).constructor(AutomatedDiscoveryInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomatedDiscoveryInformation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_CONFIGURATION_ID_FIELD, LICENSE_CONFIGURATION_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, LICENSE_COUNTING_TYPE_FIELD, LICENSE_RULES_FIELD, LICENSE_COUNT_FIELD, LICENSE_COUNT_HARD_LIMIT_FIELD, DISASSOCIATE_WHEN_NOT_FOUND_FIELD, CONSUMED_LICENSES_FIELD, STATUS_FIELD, OWNER_ACCOUNT_ID_FIELD, CONSUMED_LICENSE_SUMMARY_LIST_FIELD, MANAGED_RESOURCE_SUMMARY_LIST_FIELD, PRODUCT_INFORMATION_LIST_FIELD, AUTOMATED_DISCOVERY_INFORMATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LicenseConfigurationId", LICENSE_CONFIGURATION_ID_FIELD);
            this.put("LicenseConfigurationArn", LICENSE_CONFIGURATION_ARN_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("LicenseCountingType", LICENSE_COUNTING_TYPE_FIELD);
            this.put("LicenseRules", LICENSE_RULES_FIELD);
            this.put("LicenseCount", LICENSE_COUNT_FIELD);
            this.put("LicenseCountHardLimit", LICENSE_COUNT_HARD_LIMIT_FIELD);
            this.put("DisassociateWhenNotFound", DISASSOCIATE_WHEN_NOT_FOUND_FIELD);
            this.put("ConsumedLicenses", CONSUMED_LICENSES_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("OwnerAccountId", OWNER_ACCOUNT_ID_FIELD);
            this.put("ConsumedLicenseSummaryList", CONSUMED_LICENSE_SUMMARY_LIST_FIELD);
            this.put("ManagedResourceSummaryList", MANAGED_RESOURCE_SUMMARY_LIST_FIELD);
            this.put("ProductInformationList", PRODUCT_INFORMATION_LIST_FIELD);
            this.put("AutomatedDiscoveryInformation", AUTOMATED_DISCOVERY_INFORMATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String licenseConfigurationId;
    private final String licenseConfigurationArn;
    private final String name;
    private final String description;
    private final String licenseCountingType;
    private final List<String> licenseRules;
    private final Long licenseCount;
    private final Boolean licenseCountHardLimit;
    private final Boolean disassociateWhenNotFound;
    private final Long consumedLicenses;
    private final String status;
    private final String ownerAccountId;
    private final List<ConsumedLicenseSummary> consumedLicenseSummaryList;
    private final List<ManagedResourceSummary> managedResourceSummaryList;
    private final List<ProductInformation> productInformationList;
    private final AutomatedDiscoveryInformation automatedDiscoveryInformation;

    private LicenseConfiguration(BuilderImpl builder) {
        this.licenseConfigurationId = builder.licenseConfigurationId;
        this.licenseConfigurationArn = builder.licenseConfigurationArn;
        this.name = builder.name;
        this.description = builder.description;
        this.licenseCountingType = builder.licenseCountingType;
        this.licenseRules = builder.licenseRules;
        this.licenseCount = builder.licenseCount;
        this.licenseCountHardLimit = builder.licenseCountHardLimit;
        this.disassociateWhenNotFound = builder.disassociateWhenNotFound;
        this.consumedLicenses = builder.consumedLicenses;
        this.status = builder.status;
        this.ownerAccountId = builder.ownerAccountId;
        this.consumedLicenseSummaryList = builder.consumedLicenseSummaryList;
        this.managedResourceSummaryList = builder.managedResourceSummaryList;
        this.productInformationList = builder.productInformationList;
        this.automatedDiscoveryInformation = builder.automatedDiscoveryInformation;
    }

    public final String licenseConfigurationId() {
        return this.licenseConfigurationId;
    }

    public final String licenseConfigurationArn() {
        return this.licenseConfigurationArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final LicenseCountingType licenseCountingType() {
        return LicenseCountingType.fromValue(this.licenseCountingType);
    }

    public final String licenseCountingTypeAsString() {
        return this.licenseCountingType;
    }

    public final boolean hasLicenseRules() {
        return this.licenseRules != null && !(this.licenseRules instanceof SdkAutoConstructList);
    }

    public final List<String> licenseRules() {
        return this.licenseRules;
    }

    public final Long licenseCount() {
        return this.licenseCount;
    }

    public final Boolean licenseCountHardLimit() {
        return this.licenseCountHardLimit;
    }

    public final Boolean disassociateWhenNotFound() {
        return this.disassociateWhenNotFound;
    }

    public final Long consumedLicenses() {
        return this.consumedLicenses;
    }

    public final String status() {
        return this.status;
    }

    public final String ownerAccountId() {
        return this.ownerAccountId;
    }

    public final boolean hasConsumedLicenseSummaryList() {
        return this.consumedLicenseSummaryList != null && !(this.consumedLicenseSummaryList instanceof SdkAutoConstructList);
    }

    public final List<ConsumedLicenseSummary> consumedLicenseSummaryList() {
        return this.consumedLicenseSummaryList;
    }

    public final boolean hasManagedResourceSummaryList() {
        return this.managedResourceSummaryList != null && !(this.managedResourceSummaryList instanceof SdkAutoConstructList);
    }

    public final List<ManagedResourceSummary> managedResourceSummaryList() {
        return this.managedResourceSummaryList;
    }

    public final boolean hasProductInformationList() {
        return this.productInformationList != null && !(this.productInformationList instanceof SdkAutoConstructList);
    }

    public final List<ProductInformation> productInformationList() {
        return this.productInformationList;
    }

    public final AutomatedDiscoveryInformation automatedDiscoveryInformation() {
        return this.automatedDiscoveryInformation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseCountingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseRules() ? this.licenseRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseCountHardLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.disassociateWhenNotFound());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumedLicenses());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConsumedLicenseSummaryList() ? this.consumedLicenseSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManagedResourceSummaryList() ? this.managedResourceSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductInformationList() ? this.productInformationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.automatedDiscoveryInformation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseConfiguration)) {
            return false;
        }
        LicenseConfiguration other = (LicenseConfiguration)obj;
        return Objects.equals(this.licenseConfigurationId(), other.licenseConfigurationId()) && Objects.equals(this.licenseConfigurationArn(), other.licenseConfigurationArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.licenseCountingTypeAsString(), other.licenseCountingTypeAsString()) && this.hasLicenseRules() == other.hasLicenseRules() && Objects.equals(this.licenseRules(), other.licenseRules()) && Objects.equals(this.licenseCount(), other.licenseCount()) && Objects.equals(this.licenseCountHardLimit(), other.licenseCountHardLimit()) && Objects.equals(this.disassociateWhenNotFound(), other.disassociateWhenNotFound()) && Objects.equals(this.consumedLicenses(), other.consumedLicenses()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.ownerAccountId(), other.ownerAccountId()) && this.hasConsumedLicenseSummaryList() == other.hasConsumedLicenseSummaryList() && Objects.equals(this.consumedLicenseSummaryList(), other.consumedLicenseSummaryList()) && this.hasManagedResourceSummaryList() == other.hasManagedResourceSummaryList() && Objects.equals(this.managedResourceSummaryList(), other.managedResourceSummaryList()) && this.hasProductInformationList() == other.hasProductInformationList() && Objects.equals(this.productInformationList(), other.productInformationList()) && Objects.equals(this.automatedDiscoveryInformation(), other.automatedDiscoveryInformation());
    }

    public final String toString() {
        return ToString.builder((String)"LicenseConfiguration").add("LicenseConfigurationId", (Object)this.licenseConfigurationId()).add("LicenseConfigurationArn", (Object)this.licenseConfigurationArn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("LicenseCountingType", (Object)this.licenseCountingTypeAsString()).add("LicenseRules", this.hasLicenseRules() ? this.licenseRules() : null).add("LicenseCount", (Object)this.licenseCount()).add("LicenseCountHardLimit", (Object)this.licenseCountHardLimit()).add("DisassociateWhenNotFound", (Object)this.disassociateWhenNotFound()).add("ConsumedLicenses", (Object)this.consumedLicenses()).add("Status", (Object)this.status()).add("OwnerAccountId", (Object)this.ownerAccountId()).add("ConsumedLicenseSummaryList", this.hasConsumedLicenseSummaryList() ? this.consumedLicenseSummaryList() : null).add("ManagedResourceSummaryList", this.hasManagedResourceSummaryList() ? this.managedResourceSummaryList() : null).add("ProductInformationList", this.hasProductInformationList() ? this.productInformationList() : null).add("AutomatedDiscoveryInformation", (Object)this.automatedDiscoveryInformation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.licenseConfigurationId()));
            }
            case "LicenseConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.licenseConfigurationArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LicenseCountingType": {
                return Optional.ofNullable(clazz.cast(this.licenseCountingTypeAsString()));
            }
            case "LicenseRules": {
                return Optional.ofNullable(clazz.cast(this.licenseRules()));
            }
            case "LicenseCount": {
                return Optional.ofNullable(clazz.cast(this.licenseCount()));
            }
            case "LicenseCountHardLimit": {
                return Optional.ofNullable(clazz.cast(this.licenseCountHardLimit()));
            }
            case "DisassociateWhenNotFound": {
                return Optional.ofNullable(clazz.cast(this.disassociateWhenNotFound()));
            }
            case "ConsumedLicenses": {
                return Optional.ofNullable(clazz.cast(this.consumedLicenses()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "OwnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
            case "ConsumedLicenseSummaryList": {
                return Optional.ofNullable(clazz.cast(this.consumedLicenseSummaryList()));
            }
            case "ManagedResourceSummaryList": {
                return Optional.ofNullable(clazz.cast(this.managedResourceSummaryList()));
            }
            case "ProductInformationList": {
                return Optional.ofNullable(clazz.cast(this.productInformationList()));
            }
            case "AutomatedDiscoveryInformation": {
                return Optional.ofNullable(clazz.cast(this.automatedDiscoveryInformation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LicenseConfiguration, T> g) {
        return obj -> g.apply((LicenseConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String licenseConfigurationId;
        private String licenseConfigurationArn;
        private String name;
        private String description;
        private String licenseCountingType;
        private List<String> licenseRules = DefaultSdkAutoConstructList.getInstance();
        private Long licenseCount;
        private Boolean licenseCountHardLimit;
        private Boolean disassociateWhenNotFound;
        private Long consumedLicenses;
        private String status;
        private String ownerAccountId;
        private List<ConsumedLicenseSummary> consumedLicenseSummaryList = DefaultSdkAutoConstructList.getInstance();
        private List<ManagedResourceSummary> managedResourceSummaryList = DefaultSdkAutoConstructList.getInstance();
        private List<ProductInformation> productInformationList = DefaultSdkAutoConstructList.getInstance();
        private AutomatedDiscoveryInformation automatedDiscoveryInformation;

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseConfiguration model) {
            this.licenseConfigurationId(model.licenseConfigurationId);
            this.licenseConfigurationArn(model.licenseConfigurationArn);
            this.name(model.name);
            this.description(model.description);
            this.licenseCountingType(model.licenseCountingType);
            this.licenseRules(model.licenseRules);
            this.licenseCount(model.licenseCount);
            this.licenseCountHardLimit(model.licenseCountHardLimit);
            this.disassociateWhenNotFound(model.disassociateWhenNotFound);
            this.consumedLicenses(model.consumedLicenses);
            this.status(model.status);
            this.ownerAccountId(model.ownerAccountId);
            this.consumedLicenseSummaryList(model.consumedLicenseSummaryList);
            this.managedResourceSummaryList(model.managedResourceSummaryList);
            this.productInformationList(model.productInformationList);
            this.automatedDiscoveryInformation(model.automatedDiscoveryInformation);
        }

        public final String getLicenseConfigurationId() {
            return this.licenseConfigurationId;
        }

        public final void setLicenseConfigurationId(String licenseConfigurationId) {
            this.licenseConfigurationId = licenseConfigurationId;
        }

        @Override
        public final Builder licenseConfigurationId(String licenseConfigurationId) {
            this.licenseConfigurationId = licenseConfigurationId;
            return this;
        }

        public final String getLicenseConfigurationArn() {
            return this.licenseConfigurationArn;
        }

        public final void setLicenseConfigurationArn(String licenseConfigurationArn) {
            this.licenseConfigurationArn = licenseConfigurationArn;
        }

        @Override
        public final Builder licenseConfigurationArn(String licenseConfigurationArn) {
            this.licenseConfigurationArn = licenseConfigurationArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLicenseCountingType() {
            return this.licenseCountingType;
        }

        public final void setLicenseCountingType(String licenseCountingType) {
            this.licenseCountingType = licenseCountingType;
        }

        @Override
        public final Builder licenseCountingType(String licenseCountingType) {
            this.licenseCountingType = licenseCountingType;
            return this;
        }

        @Override
        public final Builder licenseCountingType(LicenseCountingType licenseCountingType) {
            this.licenseCountingType(licenseCountingType == null ? null : licenseCountingType.toString());
            return this;
        }

        public final Collection<String> getLicenseRules() {
            if (this.licenseRules instanceof SdkAutoConstructList) {
                return null;
            }
            return this.licenseRules;
        }

        public final void setLicenseRules(Collection<String> licenseRules) {
            this.licenseRules = StringListCopier.copy(licenseRules);
        }

        @Override
        public final Builder licenseRules(Collection<String> licenseRules) {
            this.licenseRules = StringListCopier.copy(licenseRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseRules(String ... licenseRules) {
            this.licenseRules(Arrays.asList(licenseRules));
            return this;
        }

        public final Long getLicenseCount() {
            return this.licenseCount;
        }

        public final void setLicenseCount(Long licenseCount) {
            this.licenseCount = licenseCount;
        }

        @Override
        public final Builder licenseCount(Long licenseCount) {
            this.licenseCount = licenseCount;
            return this;
        }

        public final Boolean getLicenseCountHardLimit() {
            return this.licenseCountHardLimit;
        }

        public final void setLicenseCountHardLimit(Boolean licenseCountHardLimit) {
            this.licenseCountHardLimit = licenseCountHardLimit;
        }

        @Override
        public final Builder licenseCountHardLimit(Boolean licenseCountHardLimit) {
            this.licenseCountHardLimit = licenseCountHardLimit;
            return this;
        }

        public final Boolean getDisassociateWhenNotFound() {
            return this.disassociateWhenNotFound;
        }

        public final void setDisassociateWhenNotFound(Boolean disassociateWhenNotFound) {
            this.disassociateWhenNotFound = disassociateWhenNotFound;
        }

        @Override
        public final Builder disassociateWhenNotFound(Boolean disassociateWhenNotFound) {
            this.disassociateWhenNotFound = disassociateWhenNotFound;
            return this;
        }

        public final Long getConsumedLicenses() {
            return this.consumedLicenses;
        }

        public final void setConsumedLicenses(Long consumedLicenses) {
            this.consumedLicenses = consumedLicenses;
        }

        @Override
        public final Builder consumedLicenses(Long consumedLicenses) {
            this.consumedLicenses = consumedLicenses;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final List<ConsumedLicenseSummary.Builder> getConsumedLicenseSummaryList() {
            List<ConsumedLicenseSummary.Builder> result = ConsumedLicenseSummaryListCopier.copyToBuilder(this.consumedLicenseSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConsumedLicenseSummaryList(Collection<ConsumedLicenseSummary.BuilderImpl> consumedLicenseSummaryList) {
            this.consumedLicenseSummaryList = ConsumedLicenseSummaryListCopier.copyFromBuilder(consumedLicenseSummaryList);
        }

        @Override
        public final Builder consumedLicenseSummaryList(Collection<ConsumedLicenseSummary> consumedLicenseSummaryList) {
            this.consumedLicenseSummaryList = ConsumedLicenseSummaryListCopier.copy(consumedLicenseSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedLicenseSummaryList(ConsumedLicenseSummary ... consumedLicenseSummaryList) {
            this.consumedLicenseSummaryList(Arrays.asList(consumedLicenseSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedLicenseSummaryList(Consumer<ConsumedLicenseSummary.Builder> ... consumedLicenseSummaryList) {
            this.consumedLicenseSummaryList(Stream.of(consumedLicenseSummaryList).map(c -> (ConsumedLicenseSummary)((ConsumedLicenseSummary.Builder)ConsumedLicenseSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ManagedResourceSummary.Builder> getManagedResourceSummaryList() {
            List<ManagedResourceSummary.Builder> result = ManagedResourceSummaryListCopier.copyToBuilder(this.managedResourceSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedResourceSummaryList(Collection<ManagedResourceSummary.BuilderImpl> managedResourceSummaryList) {
            this.managedResourceSummaryList = ManagedResourceSummaryListCopier.copyFromBuilder(managedResourceSummaryList);
        }

        @Override
        public final Builder managedResourceSummaryList(Collection<ManagedResourceSummary> managedResourceSummaryList) {
            this.managedResourceSummaryList = ManagedResourceSummaryListCopier.copy(managedResourceSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedResourceSummaryList(ManagedResourceSummary ... managedResourceSummaryList) {
            this.managedResourceSummaryList(Arrays.asList(managedResourceSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedResourceSummaryList(Consumer<ManagedResourceSummary.Builder> ... managedResourceSummaryList) {
            this.managedResourceSummaryList(Stream.of(managedResourceSummaryList).map(c -> (ManagedResourceSummary)((ManagedResourceSummary.Builder)ManagedResourceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ProductInformation.Builder> getProductInformationList() {
            List<ProductInformation.Builder> result = ProductInformationListCopier.copyToBuilder(this.productInformationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductInformationList(Collection<ProductInformation.BuilderImpl> productInformationList) {
            this.productInformationList = ProductInformationListCopier.copyFromBuilder(productInformationList);
        }

        @Override
        public final Builder productInformationList(Collection<ProductInformation> productInformationList) {
            this.productInformationList = ProductInformationListCopier.copy(productInformationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productInformationList(ProductInformation ... productInformationList) {
            this.productInformationList(Arrays.asList(productInformationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productInformationList(Consumer<ProductInformation.Builder> ... productInformationList) {
            this.productInformationList(Stream.of(productInformationList).map(c -> (ProductInformation)((ProductInformation.Builder)ProductInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AutomatedDiscoveryInformation.Builder getAutomatedDiscoveryInformation() {
            return this.automatedDiscoveryInformation != null ? this.automatedDiscoveryInformation.toBuilder() : null;
        }

        public final void setAutomatedDiscoveryInformation(AutomatedDiscoveryInformation.BuilderImpl automatedDiscoveryInformation) {
            this.automatedDiscoveryInformation = automatedDiscoveryInformation != null ? automatedDiscoveryInformation.build() : null;
        }

        @Override
        public final Builder automatedDiscoveryInformation(AutomatedDiscoveryInformation automatedDiscoveryInformation) {
            this.automatedDiscoveryInformation = automatedDiscoveryInformation;
            return this;
        }

        public LicenseConfiguration build() {
            return new LicenseConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LicenseConfiguration> {
        public Builder licenseConfigurationId(String var1);

        public Builder licenseConfigurationArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder licenseCountingType(String var1);

        public Builder licenseCountingType(LicenseCountingType var1);

        public Builder licenseRules(Collection<String> var1);

        public Builder licenseRules(String ... var1);

        public Builder licenseCount(Long var1);

        public Builder licenseCountHardLimit(Boolean var1);

        public Builder disassociateWhenNotFound(Boolean var1);

        public Builder consumedLicenses(Long var1);

        public Builder status(String var1);

        public Builder ownerAccountId(String var1);

        public Builder consumedLicenseSummaryList(Collection<ConsumedLicenseSummary> var1);

        public Builder consumedLicenseSummaryList(ConsumedLicenseSummary ... var1);

        public Builder consumedLicenseSummaryList(Consumer<ConsumedLicenseSummary.Builder> ... var1);

        public Builder managedResourceSummaryList(Collection<ManagedResourceSummary> var1);

        public Builder managedResourceSummaryList(ManagedResourceSummary ... var1);

        public Builder managedResourceSummaryList(Consumer<ManagedResourceSummary.Builder> ... var1);

        public Builder productInformationList(Collection<ProductInformation> var1);

        public Builder productInformationList(ProductInformation ... var1);

        public Builder productInformationList(Consumer<ProductInformation.Builder> ... var1);

        public Builder automatedDiscoveryInformation(AutomatedDiscoveryInformation var1);

        default public Builder automatedDiscoveryInformation(Consumer<AutomatedDiscoveryInformation.Builder> automatedDiscoveryInformation) {
            return this.automatedDiscoveryInformation((AutomatedDiscoveryInformation)((AutomatedDiscoveryInformation.Builder)AutomatedDiscoveryInformation.builder().applyMutation(automatedDiscoveryInformation)).build());
        }
    }
}

