/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LicenseStatus {
    AVAILABLE("AVAILABLE"),
    PENDING_AVAILABLE("PENDING_AVAILABLE"),
    DEACTIVATED("DEACTIVATED"),
    SUSPENDED("SUSPENDED"),
    EXPIRED("EXPIRED"),
    PENDING_DELETE("PENDING_DELETE"),
    DELETED("DELETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LicenseStatus> VALUE_MAP;
    private final String value;

    private LicenseStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LicenseStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LicenseStatus> knownValues() {
        EnumSet<LicenseStatus> knownValues = EnumSet.allOf(LicenseStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LicenseStatus.class, LicenseStatus::toString);
    }
}

