/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a resource entitled for use with a license.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Entitlement implements SdkPojo, Serializable, ToCopyableBuilder<Entitlement.Builder, Entitlement> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Entitlement::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(Entitlement::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<Long> MAX_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("MaxCount")
            .getter(getter(Entitlement::maxCount)).setter(setter(Builder::maxCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCount").build()).build();

    private static final SdkField<Boolean> OVERAGE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Overage").getter(getter(Entitlement::overage)).setter(setter(Builder::overage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overage").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(Entitlement::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final SdkField<Boolean> ALLOW_CHECK_IN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowCheckIn").getter(getter(Entitlement::allowCheckIn)).setter(setter(Builder::allowCheckIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowCheckIn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD,
            MAX_COUNT_FIELD, OVERAGE_FIELD, UNIT_FIELD, ALLOW_CHECK_IN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String value;

    private final Long maxCount;

    private final Boolean overage;

    private final String unit;

    private final Boolean allowCheckIn;

    private Entitlement(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.maxCount = builder.maxCount;
        this.overage = builder.overage;
        this.unit = builder.unit;
        this.allowCheckIn = builder.allowCheckIn;
    }

    /**
     * <p>
     * Entitlement name.
     * </p>
     * 
     * @return Entitlement name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Entitlement resource. Use only if the unit is None.
     * </p>
     * 
     * @return Entitlement resource. Use only if the unit is None.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * Maximum entitlement count. Use if the unit is not None.
     * </p>
     * 
     * @return Maximum entitlement count. Use if the unit is not None.
     */
    public final Long maxCount() {
        return maxCount;
    }

    /**
     * <p>
     * Indicates whether overages are allowed.
     * </p>
     * 
     * @return Indicates whether overages are allowed.
     */
    public final Boolean overage() {
        return overage;
    }

    /**
     * <p>
     * Entitlement unit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link EntitlementUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return Entitlement unit.
     * @see EntitlementUnit
     */
    public final EntitlementUnit unit() {
        return EntitlementUnit.fromValue(unit);
    }

    /**
     * <p>
     * Entitlement unit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link EntitlementUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return Entitlement unit.
     * @see EntitlementUnit
     */
    public final String unitAsString() {
        return unit;
    }

    /**
     * <p>
     * Indicates whether check-ins are allowed.
     * </p>
     * 
     * @return Indicates whether check-ins are allowed.
     */
    public final Boolean allowCheckIn() {
        return allowCheckIn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(maxCount());
        hashCode = 31 * hashCode + Objects.hashCode(overage());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(allowCheckIn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entitlement)) {
            return false;
        }
        Entitlement other = (Entitlement) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(value(), other.value())
                && Objects.equals(maxCount(), other.maxCount()) && Objects.equals(overage(), other.overage())
                && Objects.equals(unitAsString(), other.unitAsString()) && Objects.equals(allowCheckIn(), other.allowCheckIn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Entitlement").add("Name", name()).add("Value", value()).add("MaxCount", maxCount())
                .add("Overage", overage()).add("Unit", unitAsString()).add("AllowCheckIn", allowCheckIn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "MaxCount":
            return Optional.ofNullable(clazz.cast(maxCount()));
        case "Overage":
            return Optional.ofNullable(clazz.cast(overage()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        case "AllowCheckIn":
            return Optional.ofNullable(clazz.cast(allowCheckIn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Entitlement, T> g) {
        return obj -> g.apply((Entitlement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Entitlement> {
        /**
         * <p>
         * Entitlement name.
         * </p>
         * 
         * @param name
         *        Entitlement name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Entitlement resource. Use only if the unit is None.
         * </p>
         * 
         * @param value
         *        Entitlement resource. Use only if the unit is None.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * Maximum entitlement count. Use if the unit is not None.
         * </p>
         * 
         * @param maxCount
         *        Maximum entitlement count. Use if the unit is not None.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCount(Long maxCount);

        /**
         * <p>
         * Indicates whether overages are allowed.
         * </p>
         * 
         * @param overage
         *        Indicates whether overages are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overage(Boolean overage);

        /**
         * <p>
         * Entitlement unit.
         * </p>
         * 
         * @param unit
         *        Entitlement unit.
         * @see EntitlementUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntitlementUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * Entitlement unit.
         * </p>
         * 
         * @param unit
         *        Entitlement unit.
         * @see EntitlementUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntitlementUnit
         */
        Builder unit(EntitlementUnit unit);

        /**
         * <p>
         * Indicates whether check-ins are allowed.
         * </p>
         * 
         * @param allowCheckIn
         *        Indicates whether check-ins are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowCheckIn(Boolean allowCheckIn);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String value;

        private Long maxCount;

        private Boolean overage;

        private String unit;

        private Boolean allowCheckIn;

        private BuilderImpl() {
        }

        private BuilderImpl(Entitlement model) {
            name(model.name);
            value(model.value);
            maxCount(model.maxCount);
            overage(model.overage);
            unit(model.unit);
            allowCheckIn(model.allowCheckIn);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Long getMaxCount() {
            return maxCount;
        }

        public final void setMaxCount(Long maxCount) {
            this.maxCount = maxCount;
        }

        @Override
        public final Builder maxCount(Long maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        public final Boolean getOverage() {
            return overage;
        }

        public final void setOverage(Boolean overage) {
            this.overage = overage;
        }

        @Override
        public final Builder overage(Boolean overage) {
            this.overage = overage;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(EntitlementUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final Boolean getAllowCheckIn() {
            return allowCheckIn;
        }

        public final void setAllowCheckIn(Boolean allowCheckIn) {
            this.allowCheckIn = allowCheckIn;
        }

        @Override
        public final Builder allowCheckIn(Boolean allowCheckIn) {
            this.allowCheckIn = allowCheckIn;
            return this;
        }

        @Override
        public Entitlement build() {
            return new Entitlement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
