/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.licensemanager.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConsumedLicenseSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConsumedLicenseSummary> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ConsumedLicenseSummary.getter(ConsumedLicenseSummary::resourceTypeAsString)).setter(ConsumedLicenseSummary.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<Long> CONSUMED_LICENSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ConsumedLicenses").getter(ConsumedLicenseSummary.getter(ConsumedLicenseSummary::consumedLicenses)).setter(ConsumedLicenseSummary.setter(Builder::consumedLicenses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedLicenses").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, CONSUMED_LICENSES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final Long consumedLicenses;

    private ConsumedLicenseSummary(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.consumedLicenses = builder.consumedLicenses;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final Long consumedLicenses() {
        return this.consumedLicenses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumedLicenses());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsumedLicenseSummary)) {
            return false;
        }
        ConsumedLicenseSummary other = (ConsumedLicenseSummary)obj;
        return Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.consumedLicenses(), other.consumedLicenses());
    }

    public final String toString() {
        return ToString.builder((String)"ConsumedLicenseSummary").add("ResourceType", (Object)this.resourceTypeAsString()).add("ConsumedLicenses", (Object)this.consumedLicenses()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ConsumedLicenses": {
                return Optional.ofNullable(clazz.cast(this.consumedLicenses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConsumedLicenseSummary, T> g) {
        return obj -> g.apply((ConsumedLicenseSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private Long consumedLicenses;

        private BuilderImpl() {
        }

        private BuilderImpl(ConsumedLicenseSummary model) {
            this.resourceType(model.resourceType);
            this.consumedLicenses(model.consumedLicenses);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final Long getConsumedLicenses() {
            return this.consumedLicenses;
        }

        public final void setConsumedLicenses(Long consumedLicenses) {
            this.consumedLicenses = consumedLicenses;
        }

        @Override
        public final Builder consumedLicenses(Long consumedLicenses) {
            this.consumedLicenses = consumedLicenses;
            return this;
        }

        public ConsumedLicenseSummary build() {
            return new ConsumedLicenseSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConsumedLicenseSummary> {
        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder consumedLicenses(Long var1);
    }
}

