/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerRequest;
import software.amazon.awssdk.services.licensemanager.model.LicenseSpecification;
import software.amazon.awssdk.services.licensemanager.model.LicenseSpecificationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLicenseSpecificationsForResourceRequest
extends LicenseManagerRequest
implements ToCopyableBuilder<Builder, UpdateLicenseSpecificationsForResourceRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateLicenseSpecificationsForResourceRequest.getter(UpdateLicenseSpecificationsForResourceRequest::resourceArn)).setter(UpdateLicenseSpecificationsForResourceRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<List<LicenseSpecification>> ADD_LICENSE_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateLicenseSpecificationsForResourceRequest.getter(UpdateLicenseSpecificationsForResourceRequest::addLicenseSpecifications)).setter(UpdateLicenseSpecificationsForResourceRequest.setter(Builder::addLicenseSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddLicenseSpecifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LicenseSpecification>> REMOVE_LICENSE_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateLicenseSpecificationsForResourceRequest.getter(UpdateLicenseSpecificationsForResourceRequest::removeLicenseSpecifications)).setter(UpdateLicenseSpecificationsForResourceRequest.setter(Builder::removeLicenseSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveLicenseSpecifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, ADD_LICENSE_SPECIFICATIONS_FIELD, REMOVE_LICENSE_SPECIFICATIONS_FIELD));
    private final String resourceArn;
    private final List<LicenseSpecification> addLicenseSpecifications;
    private final List<LicenseSpecification> removeLicenseSpecifications;

    private UpdateLicenseSpecificationsForResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.addLicenseSpecifications = builder.addLicenseSpecifications;
        this.removeLicenseSpecifications = builder.removeLicenseSpecifications;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    public List<LicenseSpecification> addLicenseSpecifications() {
        return this.addLicenseSpecifications;
    }

    public List<LicenseSpecification> removeLicenseSpecifications() {
        return this.removeLicenseSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.addLicenseSpecifications());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeLicenseSpecifications());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLicenseSpecificationsForResourceRequest)) {
            return false;
        }
        UpdateLicenseSpecificationsForResourceRequest other = (UpdateLicenseSpecificationsForResourceRequest)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.addLicenseSpecifications(), other.addLicenseSpecifications()) && Objects.equals(this.removeLicenseSpecifications(), other.removeLicenseSpecifications());
    }

    public String toString() {
        return ToString.builder((String)"UpdateLicenseSpecificationsForResourceRequest").add("ResourceArn", (Object)this.resourceArn()).add("AddLicenseSpecifications", this.addLicenseSpecifications()).add("RemoveLicenseSpecifications", this.removeLicenseSpecifications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "AddLicenseSpecifications": {
                return Optional.ofNullable(clazz.cast(this.addLicenseSpecifications()));
            }
            case "RemoveLicenseSpecifications": {
                return Optional.ofNullable(clazz.cast(this.removeLicenseSpecifications()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLicenseSpecificationsForResourceRequest, T> g) {
        return obj -> g.apply((UpdateLicenseSpecificationsForResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerRequest.BuilderImpl
    implements Builder {
        private String resourceArn;
        private List<LicenseSpecification> addLicenseSpecifications = DefaultSdkAutoConstructList.getInstance();
        private List<LicenseSpecification> removeLicenseSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLicenseSpecificationsForResourceRequest model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.addLicenseSpecifications(model.addLicenseSpecifications);
            this.removeLicenseSpecifications(model.removeLicenseSpecifications);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Collection<LicenseSpecification.Builder> getAddLicenseSpecifications() {
            return this.addLicenseSpecifications != null ? (Collection)this.addLicenseSpecifications.stream().map(LicenseSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder addLicenseSpecifications(Collection<LicenseSpecification> addLicenseSpecifications) {
            this.addLicenseSpecifications = LicenseSpecificationsCopier.copy(addLicenseSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addLicenseSpecifications(LicenseSpecification ... addLicenseSpecifications) {
            this.addLicenseSpecifications(Arrays.asList(addLicenseSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addLicenseSpecifications(Consumer<LicenseSpecification.Builder> ... addLicenseSpecifications) {
            this.addLicenseSpecifications(Stream.of(addLicenseSpecifications).map(c -> (LicenseSpecification)((LicenseSpecification.Builder)LicenseSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAddLicenseSpecifications(Collection<LicenseSpecification.BuilderImpl> addLicenseSpecifications) {
            this.addLicenseSpecifications = LicenseSpecificationsCopier.copyFromBuilder(addLicenseSpecifications);
        }

        public final Collection<LicenseSpecification.Builder> getRemoveLicenseSpecifications() {
            return this.removeLicenseSpecifications != null ? (Collection)this.removeLicenseSpecifications.stream().map(LicenseSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder removeLicenseSpecifications(Collection<LicenseSpecification> removeLicenseSpecifications) {
            this.removeLicenseSpecifications = LicenseSpecificationsCopier.copy(removeLicenseSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeLicenseSpecifications(LicenseSpecification ... removeLicenseSpecifications) {
            this.removeLicenseSpecifications(Arrays.asList(removeLicenseSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeLicenseSpecifications(Consumer<LicenseSpecification.Builder> ... removeLicenseSpecifications) {
            this.removeLicenseSpecifications(Stream.of(removeLicenseSpecifications).map(c -> (LicenseSpecification)((LicenseSpecification.Builder)LicenseSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRemoveLicenseSpecifications(Collection<LicenseSpecification.BuilderImpl> removeLicenseSpecifications) {
            this.removeLicenseSpecifications = LicenseSpecificationsCopier.copyFromBuilder(removeLicenseSpecifications);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLicenseSpecificationsForResourceRequest build() {
            return new UpdateLicenseSpecificationsForResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LicenseManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLicenseSpecificationsForResourceRequest> {
        public Builder resourceArn(String var1);

        public Builder addLicenseSpecifications(Collection<LicenseSpecification> var1);

        public Builder addLicenseSpecifications(LicenseSpecification ... var1);

        public Builder addLicenseSpecifications(Consumer<LicenseSpecification.Builder> ... var1);

        public Builder removeLicenseSpecifications(Collection<LicenseSpecification> var1);

        public Builder removeLicenseSpecifications(LicenseSpecification ... var1);

        public Builder removeLicenseSpecifications(Consumer<LicenseSpecification.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

