/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.AllowedOperation;
import software.amazon.awssdk.services.licensemanager.model.AllowedOperationListCopier;
import software.amazon.awssdk.services.licensemanager.model.GrantStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Grant
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Grant> {
    private static final SdkField<String> GRANT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrantArn").getter(Grant.getter(Grant::grantArn)).setter(Grant.setter(Builder::grantArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantArn").build()}).build();
    private static final SdkField<String> GRANT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrantName").getter(Grant.getter(Grant::grantName)).setter(Grant.setter(Builder::grantName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantName").build()}).build();
    private static final SdkField<String> PARENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentArn").getter(Grant.getter(Grant::parentArn)).setter(Grant.setter(Builder::parentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentArn").build()}).build();
    private static final SdkField<String> LICENSE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseArn").getter(Grant.getter(Grant::licenseArn)).setter(Grant.setter(Builder::licenseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseArn").build()}).build();
    private static final SdkField<String> GRANTEE_PRINCIPAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GranteePrincipalArn").getter(Grant.getter(Grant::granteePrincipalArn)).setter(Grant.setter(Builder::granteePrincipalArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GranteePrincipalArn").build()}).build();
    private static final SdkField<String> HOME_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HomeRegion").getter(Grant.getter(Grant::homeRegion)).setter(Grant.setter(Builder::homeRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegion").build()}).build();
    private static final SdkField<String> GRANT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrantStatus").getter(Grant.getter(Grant::grantStatusAsString)).setter(Grant.setter(Builder::grantStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantStatus").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(Grant.getter(Grant::statusReason)).setter(Grant.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(Grant.getter(Grant::version)).setter(Grant.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<List<String>> GRANTED_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GrantedOperations").getter(Grant.getter(Grant::grantedOperationsAsStrings)).setter(Grant.setter(Builder::grantedOperationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantedOperations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANT_ARN_FIELD, GRANT_NAME_FIELD, PARENT_ARN_FIELD, LICENSE_ARN_FIELD, GRANTEE_PRINCIPAL_ARN_FIELD, HOME_REGION_FIELD, GRANT_STATUS_FIELD, STATUS_REASON_FIELD, VERSION_FIELD, GRANTED_OPERATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String grantArn;
    private final String grantName;
    private final String parentArn;
    private final String licenseArn;
    private final String granteePrincipalArn;
    private final String homeRegion;
    private final String grantStatus;
    private final String statusReason;
    private final String version;
    private final List<String> grantedOperations;

    private Grant(BuilderImpl builder) {
        this.grantArn = builder.grantArn;
        this.grantName = builder.grantName;
        this.parentArn = builder.parentArn;
        this.licenseArn = builder.licenseArn;
        this.granteePrincipalArn = builder.granteePrincipalArn;
        this.homeRegion = builder.homeRegion;
        this.grantStatus = builder.grantStatus;
        this.statusReason = builder.statusReason;
        this.version = builder.version;
        this.grantedOperations = builder.grantedOperations;
    }

    public final String grantArn() {
        return this.grantArn;
    }

    public final String grantName() {
        return this.grantName;
    }

    public final String parentArn() {
        return this.parentArn;
    }

    public final String licenseArn() {
        return this.licenseArn;
    }

    public final String granteePrincipalArn() {
        return this.granteePrincipalArn;
    }

    public final String homeRegion() {
        return this.homeRegion;
    }

    public final GrantStatus grantStatus() {
        return GrantStatus.fromValue(this.grantStatus);
    }

    public final String grantStatusAsString() {
        return this.grantStatus;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String version() {
        return this.version;
    }

    public final List<AllowedOperation> grantedOperations() {
        return AllowedOperationListCopier.copyStringToEnum(this.grantedOperations);
    }

    public final boolean hasGrantedOperations() {
        return this.grantedOperations != null && !(this.grantedOperations instanceof SdkAutoConstructList);
    }

    public final List<String> grantedOperationsAsStrings() {
        return this.grantedOperations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.grantArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.granteePrincipalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.homeRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGrantedOperations() ? this.grantedOperationsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Grant)) {
            return false;
        }
        Grant other = (Grant)obj;
        return Objects.equals(this.grantArn(), other.grantArn()) && Objects.equals(this.grantName(), other.grantName()) && Objects.equals(this.parentArn(), other.parentArn()) && Objects.equals(this.licenseArn(), other.licenseArn()) && Objects.equals(this.granteePrincipalArn(), other.granteePrincipalArn()) && Objects.equals(this.homeRegion(), other.homeRegion()) && Objects.equals(this.grantStatusAsString(), other.grantStatusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.version(), other.version()) && this.hasGrantedOperations() == other.hasGrantedOperations() && Objects.equals(this.grantedOperationsAsStrings(), other.grantedOperationsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"Grant").add("GrantArn", (Object)this.grantArn()).add("GrantName", (Object)this.grantName()).add("ParentArn", (Object)this.parentArn()).add("LicenseArn", (Object)this.licenseArn()).add("GranteePrincipalArn", (Object)this.granteePrincipalArn()).add("HomeRegion", (Object)this.homeRegion()).add("GrantStatus", (Object)this.grantStatusAsString()).add("StatusReason", (Object)this.statusReason()).add("Version", (Object)this.version()).add("GrantedOperations", this.hasGrantedOperations() ? this.grantedOperationsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GrantArn": {
                return Optional.ofNullable(clazz.cast(this.grantArn()));
            }
            case "GrantName": {
                return Optional.ofNullable(clazz.cast(this.grantName()));
            }
            case "ParentArn": {
                return Optional.ofNullable(clazz.cast(this.parentArn()));
            }
            case "LicenseArn": {
                return Optional.ofNullable(clazz.cast(this.licenseArn()));
            }
            case "GranteePrincipalArn": {
                return Optional.ofNullable(clazz.cast(this.granteePrincipalArn()));
            }
            case "HomeRegion": {
                return Optional.ofNullable(clazz.cast(this.homeRegion()));
            }
            case "GrantStatus": {
                return Optional.ofNullable(clazz.cast(this.grantStatusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "GrantedOperations": {
                return Optional.ofNullable(clazz.cast(this.grantedOperationsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Grant, T> g) {
        return obj -> g.apply((Grant)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String grantArn;
        private String grantName;
        private String parentArn;
        private String licenseArn;
        private String granteePrincipalArn;
        private String homeRegion;
        private String grantStatus;
        private String statusReason;
        private String version;
        private List<String> grantedOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Grant model) {
            this.grantArn(model.grantArn);
            this.grantName(model.grantName);
            this.parentArn(model.parentArn);
            this.licenseArn(model.licenseArn);
            this.granteePrincipalArn(model.granteePrincipalArn);
            this.homeRegion(model.homeRegion);
            this.grantStatus(model.grantStatus);
            this.statusReason(model.statusReason);
            this.version(model.version);
            this.grantedOperationsWithStrings(model.grantedOperations);
        }

        public final String getGrantArn() {
            return this.grantArn;
        }

        public final void setGrantArn(String grantArn) {
            this.grantArn = grantArn;
        }

        @Override
        public final Builder grantArn(String grantArn) {
            this.grantArn = grantArn;
            return this;
        }

        public final String getGrantName() {
            return this.grantName;
        }

        public final void setGrantName(String grantName) {
            this.grantName = grantName;
        }

        @Override
        public final Builder grantName(String grantName) {
            this.grantName = grantName;
            return this;
        }

        public final String getParentArn() {
            return this.parentArn;
        }

        public final void setParentArn(String parentArn) {
            this.parentArn = parentArn;
        }

        @Override
        public final Builder parentArn(String parentArn) {
            this.parentArn = parentArn;
            return this;
        }

        public final String getLicenseArn() {
            return this.licenseArn;
        }

        public final void setLicenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
        }

        @Override
        public final Builder licenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
            return this;
        }

        public final String getGranteePrincipalArn() {
            return this.granteePrincipalArn;
        }

        public final void setGranteePrincipalArn(String granteePrincipalArn) {
            this.granteePrincipalArn = granteePrincipalArn;
        }

        @Override
        public final Builder granteePrincipalArn(String granteePrincipalArn) {
            this.granteePrincipalArn = granteePrincipalArn;
            return this;
        }

        public final String getHomeRegion() {
            return this.homeRegion;
        }

        public final void setHomeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
        }

        @Override
        public final Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        public final String getGrantStatus() {
            return this.grantStatus;
        }

        public final void setGrantStatus(String grantStatus) {
            this.grantStatus = grantStatus;
        }

        @Override
        public final Builder grantStatus(String grantStatus) {
            this.grantStatus = grantStatus;
            return this;
        }

        @Override
        public final Builder grantStatus(GrantStatus grantStatus) {
            this.grantStatus(grantStatus == null ? null : grantStatus.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Collection<String> getGrantedOperations() {
            if (this.grantedOperations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.grantedOperations;
        }

        public final void setGrantedOperations(Collection<String> grantedOperations) {
            this.grantedOperations = AllowedOperationListCopier.copy(grantedOperations);
        }

        @Override
        public final Builder grantedOperationsWithStrings(Collection<String> grantedOperations) {
            this.grantedOperations = AllowedOperationListCopier.copy(grantedOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantedOperationsWithStrings(String ... grantedOperations) {
            this.grantedOperationsWithStrings(Arrays.asList(grantedOperations));
            return this;
        }

        @Override
        public final Builder grantedOperations(Collection<AllowedOperation> grantedOperations) {
            this.grantedOperations = AllowedOperationListCopier.copyEnumToString(grantedOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantedOperations(AllowedOperation ... grantedOperations) {
            this.grantedOperations(Arrays.asList(grantedOperations));
            return this;
        }

        public Grant build() {
            return new Grant(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Grant> {
        public Builder grantArn(String var1);

        public Builder grantName(String var1);

        public Builder parentArn(String var1);

        public Builder licenseArn(String var1);

        public Builder granteePrincipalArn(String var1);

        public Builder homeRegion(String var1);

        public Builder grantStatus(String var1);

        public Builder grantStatus(GrantStatus var1);

        public Builder statusReason(String var1);

        public Builder version(String var1);

        public Builder grantedOperationsWithStrings(Collection<String> var1);

        public Builder grantedOperationsWithStrings(String ... var1);

        public Builder grantedOperations(Collection<AllowedOperation> var1);

        public Builder grantedOperations(AllowedOperation ... var1);
    }
}

