/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerRequest;
import software.amazon.awssdk.services.licensemanager.model.MaxSize3StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccessTokenRequest
extends LicenseManagerRequest
implements ToCopyableBuilder<Builder, GetAccessTokenRequest> {
    private static final SdkField<String> TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Token").getter(GetAccessTokenRequest.getter(GetAccessTokenRequest::token)).setter(GetAccessTokenRequest.setter(Builder::token)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Token").build()}).build();
    private static final SdkField<List<String>> TOKEN_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TokenProperties").getter(GetAccessTokenRequest.getter(GetAccessTokenRequest::tokenProperties)).setter(GetAccessTokenRequest.setter(Builder::tokenProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_FIELD, TOKEN_PROPERTIES_FIELD));
    private final String token;
    private final List<String> tokenProperties;

    private GetAccessTokenRequest(BuilderImpl builder) {
        super(builder);
        this.token = builder.token;
        this.tokenProperties = builder.tokenProperties;
    }

    public final String token() {
        return this.token;
    }

    public final boolean hasTokenProperties() {
        return this.tokenProperties != null && !(this.tokenProperties instanceof SdkAutoConstructList);
    }

    public final List<String> tokenProperties() {
        return this.tokenProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.token());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTokenProperties() ? this.tokenProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccessTokenRequest)) {
            return false;
        }
        GetAccessTokenRequest other = (GetAccessTokenRequest)((Object)obj);
        return Objects.equals(this.token(), other.token()) && this.hasTokenProperties() == other.hasTokenProperties() && Objects.equals(this.tokenProperties(), other.tokenProperties());
    }

    public final String toString() {
        return ToString.builder((String)"GetAccessTokenRequest").add("Token", (Object)this.token()).add("TokenProperties", this.hasTokenProperties() ? this.tokenProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Token": {
                return Optional.ofNullable(clazz.cast(this.token()));
            }
            case "TokenProperties": {
                return Optional.ofNullable(clazz.cast(this.tokenProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccessTokenRequest, T> g) {
        return obj -> g.apply((GetAccessTokenRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerRequest.BuilderImpl
    implements Builder {
        private String token;
        private List<String> tokenProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccessTokenRequest model) {
            super(model);
            this.token(model.token);
            this.tokenProperties(model.tokenProperties);
        }

        public final String getToken() {
            return this.token;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        @Transient
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final Collection<String> getTokenProperties() {
            if (this.tokenProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tokenProperties;
        }

        public final void setTokenProperties(Collection<String> tokenProperties) {
            this.tokenProperties = MaxSize3StringListCopier.copy(tokenProperties);
        }

        @Override
        @Transient
        public final Builder tokenProperties(Collection<String> tokenProperties) {
            this.tokenProperties = MaxSize3StringListCopier.copy(tokenProperties);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tokenProperties(String ... tokenProperties) {
            this.tokenProperties(Arrays.asList(tokenProperties));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAccessTokenRequest build() {
            return new GetAccessTokenRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LicenseManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccessTokenRequest> {
        public Builder token(String var1);

        public Builder tokenProperties(Collection<String> var1);

        public Builder tokenProperties(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

