/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.AllowedOperation;
import software.amazon.awssdk.services.licensemanager.model.AllowedOperationListCopier;
import software.amazon.awssdk.services.licensemanager.model.ReceivedStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReceivedMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReceivedMetadata> {
    private static final SdkField<String> RECEIVED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReceivedStatus").getter(ReceivedMetadata.getter(ReceivedMetadata::receivedStatusAsString)).setter(ReceivedMetadata.setter(Builder::receivedStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceivedStatus").build()}).build();
    private static final SdkField<String> RECEIVED_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReceivedStatusReason").getter(ReceivedMetadata.getter(ReceivedMetadata::receivedStatusReason)).setter(ReceivedMetadata.setter(Builder::receivedStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceivedStatusReason").build()}).build();
    private static final SdkField<List<String>> ALLOWED_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedOperations").getter(ReceivedMetadata.getter(ReceivedMetadata::allowedOperationsAsStrings)).setter(ReceivedMetadata.setter(Builder::allowedOperationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedOperations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECEIVED_STATUS_FIELD, RECEIVED_STATUS_REASON_FIELD, ALLOWED_OPERATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String receivedStatus;
    private final String receivedStatusReason;
    private final List<String> allowedOperations;

    private ReceivedMetadata(BuilderImpl builder) {
        this.receivedStatus = builder.receivedStatus;
        this.receivedStatusReason = builder.receivedStatusReason;
        this.allowedOperations = builder.allowedOperations;
    }

    public final ReceivedStatus receivedStatus() {
        return ReceivedStatus.fromValue(this.receivedStatus);
    }

    public final String receivedStatusAsString() {
        return this.receivedStatus;
    }

    public final String receivedStatusReason() {
        return this.receivedStatusReason;
    }

    public final List<AllowedOperation> allowedOperations() {
        return AllowedOperationListCopier.copyStringToEnum(this.allowedOperations);
    }

    public final boolean hasAllowedOperations() {
        return this.allowedOperations != null && !(this.allowedOperations instanceof SdkAutoConstructList);
    }

    public final List<String> allowedOperationsAsStrings() {
        return this.allowedOperations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.receivedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.receivedStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedOperations() ? this.allowedOperationsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceivedMetadata)) {
            return false;
        }
        ReceivedMetadata other = (ReceivedMetadata)obj;
        return Objects.equals(this.receivedStatusAsString(), other.receivedStatusAsString()) && Objects.equals(this.receivedStatusReason(), other.receivedStatusReason()) && this.hasAllowedOperations() == other.hasAllowedOperations() && Objects.equals(this.allowedOperationsAsStrings(), other.allowedOperationsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ReceivedMetadata").add("ReceivedStatus", (Object)this.receivedStatusAsString()).add("ReceivedStatusReason", (Object)this.receivedStatusReason()).add("AllowedOperations", this.hasAllowedOperations() ? this.allowedOperationsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReceivedStatus": {
                return Optional.ofNullable(clazz.cast(this.receivedStatusAsString()));
            }
            case "ReceivedStatusReason": {
                return Optional.ofNullable(clazz.cast(this.receivedStatusReason()));
            }
            case "AllowedOperations": {
                return Optional.ofNullable(clazz.cast(this.allowedOperationsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReceivedMetadata, T> g) {
        return obj -> g.apply((ReceivedMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String receivedStatus;
        private String receivedStatusReason;
        private List<String> allowedOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReceivedMetadata model) {
            this.receivedStatus(model.receivedStatus);
            this.receivedStatusReason(model.receivedStatusReason);
            this.allowedOperationsWithStrings(model.allowedOperations);
        }

        public final String getReceivedStatus() {
            return this.receivedStatus;
        }

        @Override
        public final Builder receivedStatus(String receivedStatus) {
            this.receivedStatus = receivedStatus;
            return this;
        }

        @Override
        public final Builder receivedStatus(ReceivedStatus receivedStatus) {
            this.receivedStatus(receivedStatus == null ? null : receivedStatus.toString());
            return this;
        }

        public final void setReceivedStatus(String receivedStatus) {
            this.receivedStatus = receivedStatus;
        }

        public final String getReceivedStatusReason() {
            return this.receivedStatusReason;
        }

        @Override
        public final Builder receivedStatusReason(String receivedStatusReason) {
            this.receivedStatusReason = receivedStatusReason;
            return this;
        }

        public final void setReceivedStatusReason(String receivedStatusReason) {
            this.receivedStatusReason = receivedStatusReason;
        }

        public final Collection<String> getAllowedOperations() {
            if (this.allowedOperations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedOperations;
        }

        @Override
        public final Builder allowedOperationsWithStrings(Collection<String> allowedOperations) {
            this.allowedOperations = AllowedOperationListCopier.copy(allowedOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOperationsWithStrings(String ... allowedOperations) {
            this.allowedOperationsWithStrings(Arrays.asList(allowedOperations));
            return this;
        }

        @Override
        public final Builder allowedOperations(Collection<AllowedOperation> allowedOperations) {
            this.allowedOperations = AllowedOperationListCopier.copyEnumToString(allowedOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOperations(AllowedOperation ... allowedOperations) {
            this.allowedOperations(Arrays.asList(allowedOperations));
            return this;
        }

        public final void setAllowedOperations(Collection<String> allowedOperations) {
            this.allowedOperations = AllowedOperationListCopier.copy(allowedOperations);
        }

        public ReceivedMetadata build() {
            return new ReceivedMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReceivedMetadata> {
        public Builder receivedStatus(String var1);

        public Builder receivedStatus(ReceivedStatus var1);

        public Builder receivedStatusReason(String var1);

        public Builder allowedOperationsWithStrings(Collection<String> var1);

        public Builder allowedOperationsWithStrings(String ... var1);

        public Builder allowedOperations(Collection<AllowedOperation> var1);

        public Builder allowedOperations(AllowedOperation ... var1);
    }
}

