/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LicenseSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LicenseSpecification> {
    private static final SdkField<String> LICENSE_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseConfigurationArn").getter(LicenseSpecification.getter(LicenseSpecification::licenseConfigurationArn)).setter(LicenseSpecification.setter(Builder::licenseConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConfigurationArn").build()}).build();
    private static final SdkField<String> AMI_ASSOCIATION_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmiAssociationScope").getter(LicenseSpecification.getter(LicenseSpecification::amiAssociationScope)).setter(LicenseSpecification.setter(Builder::amiAssociationScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiAssociationScope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_CONFIGURATION_ARN_FIELD, AMI_ASSOCIATION_SCOPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String licenseConfigurationArn;
    private final String amiAssociationScope;

    private LicenseSpecification(BuilderImpl builder) {
        this.licenseConfigurationArn = builder.licenseConfigurationArn;
        this.amiAssociationScope = builder.amiAssociationScope;
    }

    public String licenseConfigurationArn() {
        return this.licenseConfigurationArn;
    }

    public String amiAssociationScope() {
        return this.amiAssociationScope;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiAssociationScope());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseSpecification)) {
            return false;
        }
        LicenseSpecification other = (LicenseSpecification)obj;
        return Objects.equals(this.licenseConfigurationArn(), other.licenseConfigurationArn()) && Objects.equals(this.amiAssociationScope(), other.amiAssociationScope());
    }

    public String toString() {
        return ToString.builder((String)"LicenseSpecification").add("LicenseConfigurationArn", (Object)this.licenseConfigurationArn()).add("AmiAssociationScope", (Object)this.amiAssociationScope()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.licenseConfigurationArn()));
            }
            case "AmiAssociationScope": {
                return Optional.ofNullable(clazz.cast(this.amiAssociationScope()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LicenseSpecification, T> g) {
        return obj -> g.apply((LicenseSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String licenseConfigurationArn;
        private String amiAssociationScope;

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseSpecification model) {
            this.licenseConfigurationArn(model.licenseConfigurationArn);
            this.amiAssociationScope(model.amiAssociationScope);
        }

        public final String getLicenseConfigurationArn() {
            return this.licenseConfigurationArn;
        }

        @Override
        public final Builder licenseConfigurationArn(String licenseConfigurationArn) {
            this.licenseConfigurationArn = licenseConfigurationArn;
            return this;
        }

        public final void setLicenseConfigurationArn(String licenseConfigurationArn) {
            this.licenseConfigurationArn = licenseConfigurationArn;
        }

        public final String getAmiAssociationScope() {
            return this.amiAssociationScope;
        }

        @Override
        public final Builder amiAssociationScope(String amiAssociationScope) {
            this.amiAssociationScope = amiAssociationScope;
            return this;
        }

        public final void setAmiAssociationScope(String amiAssociationScope) {
            this.amiAssociationScope = amiAssociationScope;
        }

        public LicenseSpecification build() {
            return new LicenseSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LicenseSpecification> {
        public Builder licenseConfigurationArn(String var1);

        public Builder amiAssociationScope(String var1);
    }
}

