/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AllowedOperation {
    CREATE_GRANT("CreateGrant"),
    CHECKOUT_LICENSE("CheckoutLicense"),
    CHECKOUT_BORROW_LICENSE("CheckoutBorrowLicense"),
    CHECK_IN_LICENSE("CheckInLicense"),
    EXTEND_CONSUMPTION_LICENSE("ExtendConsumptionLicense"),
    LIST_PURCHASED_LICENSES("ListPurchasedLicenses"),
    CREATE_TOKEN("CreateToken"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AllowedOperation(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AllowedOperation fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AllowedOperation.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AllowedOperation> knownValues() {
        return Stream.of(AllowedOperation.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

