/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexruntimev2.model.LexRuntimeV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecognizeUtteranceRequest
extends LexRuntimeV2Request
implements ToCopyableBuilder<Builder, RecognizeUtteranceRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(RecognizeUtteranceRequest.getter(RecognizeUtteranceRequest::botId)).setter(RecognizeUtteranceRequest.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botAliasId").getter(RecognizeUtteranceRequest.getter(RecognizeUtteranceRequest::botAliasId)).setter(RecognizeUtteranceRequest.setter(Builder::botAliasId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botAliasId").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(RecognizeUtteranceRequest.getter(RecognizeUtteranceRequest::localeId)).setter(RecognizeUtteranceRequest.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(RecognizeUtteranceRequest.getter(RecognizeUtteranceRequest::sessionId)).setter(RecognizeUtteranceRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()}).build();
    private static final SdkField<String> SESSION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionState").getter(RecognizeUtteranceRequest.getter(RecognizeUtteranceRequest::sessionState)).setter(RecognizeUtteranceRequest.setter(Builder::sessionState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-session-state").build()}).build();
    private static final SdkField<String> REQUEST_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestAttributes").getter(RecognizeUtteranceRequest.getter(RecognizeUtteranceRequest::requestAttributes)).setter(RecognizeUtteranceRequest.setter(Builder::requestAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-request-attributes").build()}).build();
    private static final SdkField<String> REQUEST_CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestContentType").getter(RecognizeUtteranceRequest.getter(RecognizeUtteranceRequest::requestContentType)).setter(RecognizeUtteranceRequest.setter(Builder::requestContentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<String> RESPONSE_CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("responseContentType").getter(RecognizeUtteranceRequest.getter(RecognizeUtteranceRequest::responseContentType)).setter(RecognizeUtteranceRequest.setter(Builder::responseContentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Response-Content-Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_ALIAS_ID_FIELD, LOCALE_ID_FIELD, SESSION_ID_FIELD, SESSION_STATE_FIELD, REQUEST_ATTRIBUTES_FIELD, REQUEST_CONTENT_TYPE_FIELD, RESPONSE_CONTENT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("botId", BOT_ID_FIELD);
            this.put("botAliasId", BOT_ALIAS_ID_FIELD);
            this.put("localeId", LOCALE_ID_FIELD);
            this.put("sessionId", SESSION_ID_FIELD);
            this.put("x-amz-lex-session-state", SESSION_STATE_FIELD);
            this.put("x-amz-lex-request-attributes", REQUEST_ATTRIBUTES_FIELD);
            this.put("Content-Type", REQUEST_CONTENT_TYPE_FIELD);
            this.put("Response-Content-Type", RESPONSE_CONTENT_TYPE_FIELD);
        }
    });
    private final String botId;
    private final String botAliasId;
    private final String localeId;
    private final String sessionId;
    private final String sessionState;
    private final String requestAttributes;
    private final String requestContentType;
    private final String responseContentType;

    private RecognizeUtteranceRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botAliasId = builder.botAliasId;
        this.localeId = builder.localeId;
        this.sessionId = builder.sessionId;
        this.sessionState = builder.sessionState;
        this.requestAttributes = builder.requestAttributes;
        this.requestContentType = builder.requestContentType;
        this.responseContentType = builder.responseContentType;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botAliasId() {
        return this.botAliasId;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String sessionState() {
        return this.sessionState;
    }

    public final String requestAttributes() {
        return this.requestAttributes;
    }

    public final String requestContentType() {
        return this.requestContentType;
    }

    public final String responseContentType() {
        return this.responseContentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionState());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestContentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseContentType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecognizeUtteranceRequest)) {
            return false;
        }
        RecognizeUtteranceRequest other = (RecognizeUtteranceRequest)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botAliasId(), other.botAliasId()) && Objects.equals(this.localeId(), other.localeId()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.sessionState(), other.sessionState()) && Objects.equals(this.requestAttributes(), other.requestAttributes()) && Objects.equals(this.requestContentType(), other.requestContentType()) && Objects.equals(this.responseContentType(), other.responseContentType());
    }

    public final String toString() {
        return ToString.builder((String)"RecognizeUtteranceRequest").add("BotId", (Object)this.botId()).add("BotAliasId", (Object)this.botAliasId()).add("LocaleId", (Object)this.localeId()).add("SessionId", (Object)this.sessionId()).add("SessionState", (Object)(this.sessionState() == null ? null : "*** Sensitive Data Redacted ***")).add("RequestAttributes", (Object)(this.requestAttributes() == null ? null : "*** Sensitive Data Redacted ***")).add("RequestContentType", (Object)this.requestContentType()).add("ResponseContentType", (Object)this.responseContentType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botAliasId": {
                return Optional.ofNullable(clazz.cast(this.botAliasId()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "sessionState": {
                return Optional.ofNullable(clazz.cast(this.sessionState()));
            }
            case "requestAttributes": {
                return Optional.ofNullable(clazz.cast(this.requestAttributes()));
            }
            case "requestContentType": {
                return Optional.ofNullable(clazz.cast(this.requestContentType()));
            }
            case "responseContentType": {
                return Optional.ofNullable(clazz.cast(this.responseContentType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RecognizeUtteranceRequest, T> g) {
        return obj -> g.apply((RecognizeUtteranceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexRuntimeV2Request.BuilderImpl
    implements Builder {
        private String botId;
        private String botAliasId;
        private String localeId;
        private String sessionId;
        private String sessionState;
        private String requestAttributes;
        private String requestContentType;
        private String responseContentType;

        private BuilderImpl() {
        }

        private BuilderImpl(RecognizeUtteranceRequest model) {
            super(model);
            this.botId(model.botId);
            this.botAliasId(model.botAliasId);
            this.localeId(model.localeId);
            this.sessionId(model.sessionId);
            this.sessionState(model.sessionState);
            this.requestAttributes(model.requestAttributes);
            this.requestContentType(model.requestContentType);
            this.responseContentType(model.responseContentType);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotAliasId() {
            return this.botAliasId;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        @Override
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getSessionState() {
            return this.sessionState;
        }

        public final void setSessionState(String sessionState) {
            this.sessionState = sessionState;
        }

        @Override
        public final Builder sessionState(String sessionState) {
            this.sessionState = sessionState;
            return this;
        }

        public final String getRequestAttributes() {
            return this.requestAttributes;
        }

        public final void setRequestAttributes(String requestAttributes) {
            this.requestAttributes = requestAttributes;
        }

        @Override
        public final Builder requestAttributes(String requestAttributes) {
            this.requestAttributes = requestAttributes;
            return this;
        }

        public final String getRequestContentType() {
            return this.requestContentType;
        }

        public final void setRequestContentType(String requestContentType) {
            this.requestContentType = requestContentType;
        }

        @Override
        public final Builder requestContentType(String requestContentType) {
            this.requestContentType = requestContentType;
            return this;
        }

        public final String getResponseContentType() {
            return this.responseContentType;
        }

        public final void setResponseContentType(String responseContentType) {
            this.responseContentType = responseContentType;
        }

        @Override
        public final Builder responseContentType(String responseContentType) {
            this.responseContentType = responseContentType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RecognizeUtteranceRequest build() {
            return new RecognizeUtteranceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexRuntimeV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RecognizeUtteranceRequest> {
        public Builder botId(String var1);

        public Builder botAliasId(String var1);

        public Builder localeId(String var1);

        public Builder sessionId(String var1);

        public Builder sessionState(String var1);

        public Builder requestAttributes(String var1);

        public Builder requestContentType(String var1);

        public Builder responseContentType(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

