/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The event sent from your client application to Amazon Lex V2 with text input from the user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TextInputEvent implements SdkPojo, Serializable, ToCopyableBuilder<TextInputEvent.Builder, TextInputEvent>,
        StartConversationRequestEventStream {
    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(TextInputEvent::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(TextInputEvent::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final SdkField<Long> CLIENT_TIMESTAMP_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("clientTimestampMillis").getter(getter(TextInputEvent::clientTimestampMillis))
            .setter(setter(Builder::clientTimestampMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientTimestampMillis").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, EVENT_ID_FIELD,
            CLIENT_TIMESTAMP_MILLIS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String text;

    private final String eventId;

    private final Long clientTimestampMillis;

    protected TextInputEvent(BuilderImpl builder) {
        this.text = builder.text;
        this.eventId = builder.eventId;
        this.clientTimestampMillis = builder.clientTimestampMillis;
    }

    /**
     * <p>
     * The text from the user. Amazon Lex V2 processes this as a complete statement.
     * </p>
     * 
     * @return The text from the user. Amazon Lex V2 processes this as a complete statement.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * A unique identifier that your application assigns to the event. You can use this to identify events in logs.
     * </p>
     * 
     * @return A unique identifier that your application assigns to the event. You can use this to identify events in
     *         logs.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * A timestamp set by the client of the date and time that the event was sent to Amazon Lex V2.
     * </p>
     * 
     * @return A timestamp set by the client of the date and time that the event was sent to Amazon Lex V2.
     */
    public final Long clientTimestampMillis() {
        return clientTimestampMillis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(clientTimestampMillis());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextInputEvent)) {
            return false;
        }
        TextInputEvent other = (TextInputEvent) obj;
        return Objects.equals(text(), other.text()) && Objects.equals(eventId(), other.eventId())
                && Objects.equals(clientTimestampMillis(), other.clientTimestampMillis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextInputEvent").add("Text", text() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EventId", eventId()).add("ClientTimestampMillis", clientTimestampMillis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "clientTimestampMillis":
            return Optional.ofNullable(clazz.cast(clientTimestampMillis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final TextInputEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TextInputEvent, T> g) {
        return obj -> g.apply((TextInputEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextInputEvent> {
        /**
         * <p>
         * The text from the user. Amazon Lex V2 processes this as a complete statement.
         * </p>
         * 
         * @param text
         *        The text from the user. Amazon Lex V2 processes this as a complete statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * A unique identifier that your application assigns to the event. You can use this to identify events in logs.
         * </p>
         * 
         * @param eventId
         *        A unique identifier that your application assigns to the event. You can use this to identify events in
         *        logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * A timestamp set by the client of the date and time that the event was sent to Amazon Lex V2.
         * </p>
         * 
         * @param clientTimestampMillis
         *        A timestamp set by the client of the date and time that the event was sent to Amazon Lex V2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientTimestampMillis(Long clientTimestampMillis);
    }

    protected static class BuilderImpl implements Builder {
        private String text;

        private String eventId;

        private Long clientTimestampMillis;

        protected BuilderImpl() {
        }

        protected BuilderImpl(TextInputEvent model) {
            text(model.text);
            eventId(model.eventId);
            clientTimestampMillis(model.clientTimestampMillis);
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final Long getClientTimestampMillis() {
            return clientTimestampMillis;
        }

        public final void setClientTimestampMillis(Long clientTimestampMillis) {
            this.clientTimestampMillis = clientTimestampMillis;
        }

        @Override
        public final Builder clientTimestampMillis(Long clientTimestampMillis) {
            this.clientTimestampMillis = clientTimestampMillis;
            return this;
        }

        @Override
        public TextInputEvent build() {
            return new TextInputEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
