/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The initial event sent from the application to Amazon Lex V2 to configure the conversation, including session and
 * request attributes and the response content type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ConfigurationEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationEvent.Builder, ConfigurationEvent>, StartConversationRequestEventStream {
    private static final SdkField<Map<String, String>> REQUEST_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("requestAttributes")
            .getter(getter(ConfigurationEvent::requestAttributes))
            .setter(setter(Builder::requestAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RESPONSE_CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("responseContentType").getter(getter(ConfigurationEvent::responseContentType))
            .setter(setter(Builder::responseContentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseContentType").build())
            .build();

    private static final SdkField<SessionState> SESSION_STATE_FIELD = SdkField.<SessionState> builder(MarshallingType.SDK_POJO)
            .memberName("sessionState").getter(getter(ConfigurationEvent::sessionState)).setter(setter(Builder::sessionState))
            .constructor(SessionState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionState").build()).build();

    private static final SdkField<List<Message>> WELCOME_MESSAGES_FIELD = SdkField
            .<List<Message>> builder(MarshallingType.LIST)
            .memberName("welcomeMessages")
            .getter(getter(ConfigurationEvent::welcomeMessages))
            .setter(setter(Builder::welcomeMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("welcomeMessages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Message> builder(MarshallingType.SDK_POJO)
                                            .constructor(Message::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DISABLE_PLAYBACK_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("disablePlayback").getter(getter(ConfigurationEvent::disablePlayback))
            .setter(setter(Builder::disablePlayback))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disablePlayback").build()).build();

    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(ConfigurationEvent::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final SdkField<Long> CLIENT_TIMESTAMP_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("clientTimestampMillis").getter(getter(ConfigurationEvent::clientTimestampMillis))
            .setter(setter(Builder::clientTimestampMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientTimestampMillis").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ATTRIBUTES_FIELD,
            RESPONSE_CONTENT_TYPE_FIELD, SESSION_STATE_FIELD, WELCOME_MESSAGES_FIELD, DISABLE_PLAYBACK_FIELD, EVENT_ID_FIELD,
            CLIENT_TIMESTAMP_MILLIS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> requestAttributes;

    private final String responseContentType;

    private final SessionState sessionState;

    private final List<Message> welcomeMessages;

    private final Boolean disablePlayback;

    private final String eventId;

    private final Long clientTimestampMillis;

    protected ConfigurationEvent(BuilderImpl builder) {
        this.requestAttributes = builder.requestAttributes;
        this.responseContentType = builder.responseContentType;
        this.sessionState = builder.sessionState;
        this.welcomeMessages = builder.welcomeMessages;
        this.disablePlayback = builder.disablePlayback;
        this.eventId = builder.eventId;
        this.clientTimestampMillis = builder.clientTimestampMillis;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequestAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRequestAttributes() {
        return requestAttributes != null && !(requestAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Request-specific information passed between the client application and Amazon Lex V2.
     * </p>
     * <p>
     * The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request attributes for
     * prefix <code>x-amz-lex:</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequestAttributes} method.
     * </p>
     * 
     * @return Request-specific information passed between the client application and Amazon Lex V2.</p>
     *         <p>
     *         The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request
     *         attributes for prefix <code>x-amz-lex:</code>.
     */
    public final Map<String, String> requestAttributes() {
        return requestAttributes;
    }

    /**
     * <p>
     * The message that Amazon Lex V2 returns in the response can be either text or speech based on the
     * <code>responseContentType</code> value.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the value is <code>text/plain;charset=utf-8</code>, Amazon Lex V2 returns text in the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the value begins with <code>audio/</code>, Amazon Lex V2 returns speech in the response. Amazon Lex V2 uses
     * Amazon Polly to generate the speech using the configuration that you specified in the
     * <code>requestContentType</code> parameter. For example, if you specify <code>audio/mpeg</code> as the value,
     * Amazon Lex V2 returns speech in the MPEG format.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the value is <code>audio/pcm</code>, the speech returned is audio/pcm in 16-bit, little-endian format.
     * </p>
     * </li>
     * <li>
     * <p>
     * The following are the accepted values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * audio/mpeg
     * </p>
     * </li>
     * <li>
     * <p>
     * audio/ogg
     * </p>
     * </li>
     * <li>
     * <p>
     * audio/pcm
     * </p>
     * </li>
     * <li>
     * <p>
     * audio/* (defaults to mpeg)
     * </p>
     * </li>
     * <li>
     * <p>
     * text/plain; charset=utf-8
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return The message that Amazon Lex V2 returns in the response can be either text or speech based on the
     *         <code>responseContentType</code> value.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the value is <code>text/plain;charset=utf-8</code>, Amazon Lex V2 returns text in the response.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the value begins with <code>audio/</code>, Amazon Lex V2 returns speech in the response. Amazon Lex V2
     *         uses Amazon Polly to generate the speech using the configuration that you specified in the
     *         <code>requestContentType</code> parameter. For example, if you specify <code>audio/mpeg</code> as the
     *         value, Amazon Lex V2 returns speech in the MPEG format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the value is <code>audio/pcm</code>, the speech returned is audio/pcm in 16-bit, little-endian format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The following are the accepted values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         audio/mpeg
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         audio/ogg
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         audio/pcm
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         audio/* (defaults to mpeg)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         text/plain; charset=utf-8
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final String responseContentType() {
        return responseContentType;
    }

    /**
     * Returns the value of the SessionState property for this object.
     * 
     * @return The value of the SessionState property for this object.
     */
    public final SessionState sessionState() {
        return sessionState;
    }

    /**
     * For responses, this returns true if the service returned a value for the WelcomeMessages property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWelcomeMessages() {
        return welcomeMessages != null && !(welcomeMessages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of messages to send to the user.
     * </p>
     * <p>
     * If you set the <code>welcomeMessage</code> field, you must also set the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_DialogAction.html"> <code>DialogAction</code> </a>
     * structure's <a href=
     * "https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_DialogAction.html#lexv2-Type-runtime_DialogAction-type">
     * <code>type</code> </a> field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWelcomeMessages} method.
     * </p>
     * 
     * @return A list of messages to send to the user.</p>
     *         <p>
     *         If you set the <code>welcomeMessage</code> field, you must also set the <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_DialogAction.html">
     *         <code>DialogAction</code> </a> structure's <a href=
     *         "https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_DialogAction.html#lexv2-Type-runtime_DialogAction-type"
     *         > <code>type</code> </a> field.
     */
    public final List<Message> welcomeMessages() {
        return welcomeMessages;
    }

    /**
     * <p>
     * Determines whether Amazon Lex V2 should send audio responses to the client application.
     * </p>
     * <p>
     * Set this field to false when the client is operating in a playback mode where audio responses are played to the
     * user. If the client isn't operating in playback mode, such as a text chat application, set this to true so that
     * Amazon Lex V2 doesn't wait for the prompt to finish playing on the client.
     * </p>
     * 
     * @return Determines whether Amazon Lex V2 should send audio responses to the client application. </p>
     *         <p>
     *         Set this field to false when the client is operating in a playback mode where audio responses are played
     *         to the user. If the client isn't operating in playback mode, such as a text chat application, set this to
     *         true so that Amazon Lex V2 doesn't wait for the prompt to finish playing on the client.
     */
    public final Boolean disablePlayback() {
        return disablePlayback;
    }

    /**
     * <p>
     * A unique identifier that your application assigns to the event. You can use this to identify events in logs.
     * </p>
     * 
     * @return A unique identifier that your application assigns to the event. You can use this to identify events in
     *         logs.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * A timestamp set by the client of the date and time that the event was sent to Amazon Lex V2.
     * </p>
     * 
     * @return A timestamp set by the client of the date and time that the event was sent to Amazon Lex V2.
     */
    public final Long clientTimestampMillis() {
        return clientTimestampMillis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRequestAttributes() ? requestAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(responseContentType());
        hashCode = 31 * hashCode + Objects.hashCode(sessionState());
        hashCode = 31 * hashCode + Objects.hashCode(hasWelcomeMessages() ? welcomeMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(disablePlayback());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(clientTimestampMillis());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationEvent)) {
            return false;
        }
        ConfigurationEvent other = (ConfigurationEvent) obj;
        return hasRequestAttributes() == other.hasRequestAttributes()
                && Objects.equals(requestAttributes(), other.requestAttributes())
                && Objects.equals(responseContentType(), other.responseContentType())
                && Objects.equals(sessionState(), other.sessionState()) && hasWelcomeMessages() == other.hasWelcomeMessages()
                && Objects.equals(welcomeMessages(), other.welcomeMessages())
                && Objects.equals(disablePlayback(), other.disablePlayback()) && Objects.equals(eventId(), other.eventId())
                && Objects.equals(clientTimestampMillis(), other.clientTimestampMillis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationEvent")
                .add("RequestAttributes", hasRequestAttributes() ? requestAttributes() : null)
                .add("ResponseContentType", responseContentType()).add("SessionState", sessionState())
                .add("WelcomeMessages", hasWelcomeMessages() ? welcomeMessages() : null)
                .add("DisablePlayback", disablePlayback()).add("EventId", eventId())
                .add("ClientTimestampMillis", clientTimestampMillis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "requestAttributes":
            return Optional.ofNullable(clazz.cast(requestAttributes()));
        case "responseContentType":
            return Optional.ofNullable(clazz.cast(responseContentType()));
        case "sessionState":
            return Optional.ofNullable(clazz.cast(sessionState()));
        case "welcomeMessages":
            return Optional.ofNullable(clazz.cast(welcomeMessages()));
        case "disablePlayback":
            return Optional.ofNullable(clazz.cast(disablePlayback()));
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "clientTimestampMillis":
            return Optional.ofNullable(clazz.cast(clientTimestampMillis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final ConfigurationEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationEvent, T> g) {
        return obj -> g.apply((ConfigurationEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationEvent> {
        /**
         * <p>
         * Request-specific information passed between the client application and Amazon Lex V2.
         * </p>
         * <p>
         * The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request attributes
         * for prefix <code>x-amz-lex:</code>.
         * </p>
         * 
         * @param requestAttributes
         *        Request-specific information passed between the client application and Amazon Lex V2.</p>
         *        <p>
         *        The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request
         *        attributes for prefix <code>x-amz-lex:</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestAttributes(Map<String, String> requestAttributes);

        /**
         * <p>
         * The message that Amazon Lex V2 returns in the response can be either text or speech based on the
         * <code>responseContentType</code> value.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the value is <code>text/plain;charset=utf-8</code>, Amazon Lex V2 returns text in the response.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the value begins with <code>audio/</code>, Amazon Lex V2 returns speech in the response. Amazon Lex V2
         * uses Amazon Polly to generate the speech using the configuration that you specified in the
         * <code>requestContentType</code> parameter. For example, if you specify <code>audio/mpeg</code> as the value,
         * Amazon Lex V2 returns speech in the MPEG format.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the value is <code>audio/pcm</code>, the speech returned is audio/pcm in 16-bit, little-endian format.
         * </p>
         * </li>
         * <li>
         * <p>
         * The following are the accepted values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * audio/mpeg
         * </p>
         * </li>
         * <li>
         * <p>
         * audio/ogg
         * </p>
         * </li>
         * <li>
         * <p>
         * audio/pcm
         * </p>
         * </li>
         * <li>
         * <p>
         * audio/* (defaults to mpeg)
         * </p>
         * </li>
         * <li>
         * <p>
         * text/plain; charset=utf-8
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param responseContentType
         *        The message that Amazon Lex V2 returns in the response can be either text or speech based on the
         *        <code>responseContentType</code> value.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the value is <code>text/plain;charset=utf-8</code>, Amazon Lex V2 returns text in the response.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the value begins with <code>audio/</code>, Amazon Lex V2 returns speech in the response. Amazon Lex
         *        V2 uses Amazon Polly to generate the speech using the configuration that you specified in the
         *        <code>requestContentType</code> parameter. For example, if you specify <code>audio/mpeg</code> as the
         *        value, Amazon Lex V2 returns speech in the MPEG format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the value is <code>audio/pcm</code>, the speech returned is audio/pcm in 16-bit, little-endian
         *        format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The following are the accepted values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        audio/mpeg
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        audio/ogg
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        audio/pcm
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        audio/* (defaults to mpeg)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        text/plain; charset=utf-8
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseContentType(String responseContentType);

        /**
         * Sets the value of the SessionState property for this object.
         *
         * @param sessionState
         *        The new value for the SessionState property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionState(SessionState sessionState);

        /**
         * Sets the value of the SessionState property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SessionState.Builder} avoiding the need
         * to create one manually via {@link SessionState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionState.Builder#build()} is called immediately and its
         * result is passed to {@link #sessionState(SessionState)}.
         * 
         * @param sessionState
         *        a consumer that will call methods on {@link SessionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionState(SessionState)
         */
        default Builder sessionState(Consumer<SessionState.Builder> sessionState) {
            return sessionState(SessionState.builder().applyMutation(sessionState).build());
        }

        /**
         * <p>
         * A list of messages to send to the user.
         * </p>
         * <p>
         * If you set the <code>welcomeMessage</code> field, you must also set the <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_DialogAction.html"> <code>DialogAction</code>
         * </a> structure's <a href=
         * "https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_DialogAction.html#lexv2-Type-runtime_DialogAction-type"
         * > <code>type</code> </a> field.
         * </p>
         * 
         * @param welcomeMessages
         *        A list of messages to send to the user.</p>
         *        <p>
         *        If you set the <code>welcomeMessage</code> field, you must also set the <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_DialogAction.html">
         *        <code>DialogAction</code> </a> structure's <a href=
         *        "https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_DialogAction.html#lexv2-Type-runtime_DialogAction-type"
         *        > <code>type</code> </a> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder welcomeMessages(Collection<Message> welcomeMessages);

        /**
         * <p>
         * A list of messages to send to the user.
         * </p>
         * <p>
         * If you set the <code>welcomeMessage</code> field, you must also set the <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_DialogAction.html"> <code>DialogAction</code>
         * </a> structure's <a href=
         * "https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_DialogAction.html#lexv2-Type-runtime_DialogAction-type"
         * > <code>type</code> </a> field.
         * </p>
         * 
         * @param welcomeMessages
         *        A list of messages to send to the user.</p>
         *        <p>
         *        If you set the <code>welcomeMessage</code> field, you must also set the <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_DialogAction.html">
         *        <code>DialogAction</code> </a> structure's <a href=
         *        "https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_DialogAction.html#lexv2-Type-runtime_DialogAction-type"
         *        > <code>type</code> </a> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder welcomeMessages(Message... welcomeMessages);

        /**
         * <p>
         * A list of messages to send to the user.
         * </p>
         * <p>
         * If you set the <code>welcomeMessage</code> field, you must also set the <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_DialogAction.html"> <code>DialogAction</code>
         * </a> structure's <a href=
         * "https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_DialogAction.html#lexv2-Type-runtime_DialogAction-type"
         * > <code>type</code> </a> field.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexruntimev2.model.Message.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lexruntimev2.model.Message#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexruntimev2.model.Message.Builder#build()} is called immediately and
         * its result is passed to {@link #welcomeMessages(List<Message>)}.
         * 
         * @param welcomeMessages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexruntimev2.model.Message.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #welcomeMessages(java.util.Collection<Message>)
         */
        Builder welcomeMessages(Consumer<Message.Builder>... welcomeMessages);

        /**
         * <p>
         * Determines whether Amazon Lex V2 should send audio responses to the client application.
         * </p>
         * <p>
         * Set this field to false when the client is operating in a playback mode where audio responses are played to
         * the user. If the client isn't operating in playback mode, such as a text chat application, set this to true
         * so that Amazon Lex V2 doesn't wait for the prompt to finish playing on the client.
         * </p>
         * 
         * @param disablePlayback
         *        Determines whether Amazon Lex V2 should send audio responses to the client application. </p>
         *        <p>
         *        Set this field to false when the client is operating in a playback mode where audio responses are
         *        played to the user. If the client isn't operating in playback mode, such as a text chat application,
         *        set this to true so that Amazon Lex V2 doesn't wait for the prompt to finish playing on the client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disablePlayback(Boolean disablePlayback);

        /**
         * <p>
         * A unique identifier that your application assigns to the event. You can use this to identify events in logs.
         * </p>
         * 
         * @param eventId
         *        A unique identifier that your application assigns to the event. You can use this to identify events in
         *        logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * A timestamp set by the client of the date and time that the event was sent to Amazon Lex V2.
         * </p>
         * 
         * @param clientTimestampMillis
         *        A timestamp set by the client of the date and time that the event was sent to Amazon Lex V2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientTimestampMillis(Long clientTimestampMillis);
    }

    protected static class BuilderImpl implements Builder {
        private Map<String, String> requestAttributes = DefaultSdkAutoConstructMap.getInstance();

        private String responseContentType;

        private SessionState sessionState;

        private List<Message> welcomeMessages = DefaultSdkAutoConstructList.getInstance();

        private Boolean disablePlayback;

        private String eventId;

        private Long clientTimestampMillis;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ConfigurationEvent model) {
            requestAttributes(model.requestAttributes);
            responseContentType(model.responseContentType);
            sessionState(model.sessionState);
            welcomeMessages(model.welcomeMessages);
            disablePlayback(model.disablePlayback);
            eventId(model.eventId);
            clientTimestampMillis(model.clientTimestampMillis);
        }

        public final Map<String, String> getRequestAttributes() {
            if (requestAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return requestAttributes;
        }

        public final void setRequestAttributes(Map<String, String> requestAttributes) {
            this.requestAttributes = StringMapCopier.copy(requestAttributes);
        }

        @Override
        public final Builder requestAttributes(Map<String, String> requestAttributes) {
            this.requestAttributes = StringMapCopier.copy(requestAttributes);
            return this;
        }

        public final String getResponseContentType() {
            return responseContentType;
        }

        public final void setResponseContentType(String responseContentType) {
            this.responseContentType = responseContentType;
        }

        @Override
        public final Builder responseContentType(String responseContentType) {
            this.responseContentType = responseContentType;
            return this;
        }

        public final SessionState.Builder getSessionState() {
            return sessionState != null ? sessionState.toBuilder() : null;
        }

        public final void setSessionState(SessionState.BuilderImpl sessionState) {
            this.sessionState = sessionState != null ? sessionState.build() : null;
        }

        @Override
        public final Builder sessionState(SessionState sessionState) {
            this.sessionState = sessionState;
            return this;
        }

        public final List<Message.Builder> getWelcomeMessages() {
            List<Message.Builder> result = MessagesCopier.copyToBuilder(this.welcomeMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWelcomeMessages(Collection<Message.BuilderImpl> welcomeMessages) {
            this.welcomeMessages = MessagesCopier.copyFromBuilder(welcomeMessages);
        }

        @Override
        public final Builder welcomeMessages(Collection<Message> welcomeMessages) {
            this.welcomeMessages = MessagesCopier.copy(welcomeMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder welcomeMessages(Message... welcomeMessages) {
            welcomeMessages(Arrays.asList(welcomeMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder welcomeMessages(Consumer<Message.Builder>... welcomeMessages) {
            welcomeMessages(Stream.of(welcomeMessages).map(c -> Message.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDisablePlayback() {
            return disablePlayback;
        }

        public final void setDisablePlayback(Boolean disablePlayback) {
            this.disablePlayback = disablePlayback;
        }

        @Override
        public final Builder disablePlayback(Boolean disablePlayback) {
            this.disablePlayback = disablePlayback;
            return this;
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final Long getClientTimestampMillis() {
            return clientTimestampMillis;
        }

        public final void setClientTimestampMillis(Long clientTimestampMillis) {
            this.clientTimestampMillis = clientTimestampMillis;
        }

        @Override
        public final Builder clientTimestampMillis(Long clientTimestampMillis) {
            this.clientTimestampMillis = clientTimestampMillis;
            return this;
        }

        @Override
        public ConfigurationEvent build() {
            return new ConfigurationEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
