/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IntentState {
    FAILED("Failed"),
    FULFILLED("Fulfilled"),
    IN_PROGRESS("InProgress"),
    READY_FOR_FULFILLMENT("ReadyForFulfillment"),
    WAITING("Waiting"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IntentState> VALUE_MAP;
    private final String value;

    private IntentState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IntentState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IntentState> knownValues() {
        EnumSet<IntentState> knownValues = EnumSet.allOf(IntentState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IntentState.class, IntentState::toString);
    }
}

