/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.lexruntime.model.ConfirmationStatus;
import software.amazon.awssdk.services.lexruntime.model.DialogActionType;
import software.amazon.awssdk.services.lexruntime.model.FulfillmentState;
import software.amazon.awssdk.services.lexruntime.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IntentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IntentSummary> {
    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IntentSummary.getter(IntentSummary::intentName)).setter(IntentSummary.setter(Builder::intentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentName").build()}).build();
    private static final SdkField<Map<String, String>> SLOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(IntentSummary.getter(IntentSummary::slots)).setter(IntentSummary.setter(Builder::slots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slots").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CONFIRMATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IntentSummary.getter(IntentSummary::confirmationStatusAsString)).setter(IntentSummary.setter(Builder::confirmationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confirmationStatus").build()}).build();
    private static final SdkField<String> DIALOG_ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IntentSummary.getter(IntentSummary::dialogActionTypeAsString)).setter(IntentSummary.setter(Builder::dialogActionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogActionType").build()}).build();
    private static final SdkField<String> FULFILLMENT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IntentSummary.getter(IntentSummary::fulfillmentStateAsString)).setter(IntentSummary.setter(Builder::fulfillmentState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fulfillmentState").build()}).build();
    private static final SdkField<String> SLOT_TO_ELICIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IntentSummary.getter(IntentSummary::slotToElicit)).setter(IntentSummary.setter(Builder::slotToElicit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotToElicit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_NAME_FIELD, SLOTS_FIELD, CONFIRMATION_STATUS_FIELD, DIALOG_ACTION_TYPE_FIELD, FULFILLMENT_STATE_FIELD, SLOT_TO_ELICIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String intentName;
    private final Map<String, String> slots;
    private final String confirmationStatus;
    private final String dialogActionType;
    private final String fulfillmentState;
    private final String slotToElicit;

    private IntentSummary(BuilderImpl builder) {
        this.intentName = builder.intentName;
        this.slots = builder.slots;
        this.confirmationStatus = builder.confirmationStatus;
        this.dialogActionType = builder.dialogActionType;
        this.fulfillmentState = builder.fulfillmentState;
        this.slotToElicit = builder.slotToElicit;
    }

    public String intentName() {
        return this.intentName;
    }

    public Map<String, String> slots() {
        return this.slots;
    }

    public ConfirmationStatus confirmationStatus() {
        return ConfirmationStatus.fromValue(this.confirmationStatus);
    }

    public String confirmationStatusAsString() {
        return this.confirmationStatus;
    }

    public DialogActionType dialogActionType() {
        return DialogActionType.fromValue(this.dialogActionType);
    }

    public String dialogActionTypeAsString() {
        return this.dialogActionType;
    }

    public FulfillmentState fulfillmentState() {
        return FulfillmentState.fromValue(this.fulfillmentState);
    }

    public String fulfillmentStateAsString() {
        return this.fulfillmentState;
    }

    public String slotToElicit() {
        return this.slotToElicit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.intentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.slots());
        hashCode = 31 * hashCode + Objects.hashCode(this.confirmationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dialogActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fulfillmentStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotToElicit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntentSummary)) {
            return false;
        }
        IntentSummary other = (IntentSummary)obj;
        return Objects.equals(this.intentName(), other.intentName()) && Objects.equals(this.slots(), other.slots()) && Objects.equals(this.confirmationStatusAsString(), other.confirmationStatusAsString()) && Objects.equals(this.dialogActionTypeAsString(), other.dialogActionTypeAsString()) && Objects.equals(this.fulfillmentStateAsString(), other.fulfillmentStateAsString()) && Objects.equals(this.slotToElicit(), other.slotToElicit());
    }

    public String toString() {
        return ToString.builder((String)"IntentSummary").add("IntentName", (Object)this.intentName()).add("Slots", (Object)(this.slots() == null ? null : "*** Sensitive Data Redacted ***")).add("ConfirmationStatus", (Object)this.confirmationStatusAsString()).add("DialogActionType", (Object)this.dialogActionTypeAsString()).add("FulfillmentState", (Object)this.fulfillmentStateAsString()).add("SlotToElicit", (Object)this.slotToElicit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "intentName": {
                return Optional.ofNullable(clazz.cast(this.intentName()));
            }
            case "slots": {
                return Optional.ofNullable(clazz.cast(this.slots()));
            }
            case "confirmationStatus": {
                return Optional.ofNullable(clazz.cast(this.confirmationStatusAsString()));
            }
            case "dialogActionType": {
                return Optional.ofNullable(clazz.cast(this.dialogActionTypeAsString()));
            }
            case "fulfillmentState": {
                return Optional.ofNullable(clazz.cast(this.fulfillmentStateAsString()));
            }
            case "slotToElicit": {
                return Optional.ofNullable(clazz.cast(this.slotToElicit()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IntentSummary, T> g) {
        return obj -> g.apply((IntentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String intentName;
        private Map<String, String> slots = DefaultSdkAutoConstructMap.getInstance();
        private String confirmationStatus;
        private String dialogActionType;
        private String fulfillmentState;
        private String slotToElicit;

        private BuilderImpl() {
        }

        private BuilderImpl(IntentSummary model) {
            this.intentName(model.intentName);
            this.slots(model.slots);
            this.confirmationStatus(model.confirmationStatus);
            this.dialogActionType(model.dialogActionType);
            this.fulfillmentState(model.fulfillmentState);
            this.slotToElicit(model.slotToElicit);
        }

        public final String getIntentName() {
            return this.intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        public final Map<String, String> getSlots() {
            return this.slots;
        }

        @Override
        public final Builder slots(Map<String, String> slots) {
            this.slots = StringMapCopier.copy(slots);
            return this;
        }

        public final void setSlots(Map<String, String> slots) {
            this.slots = StringMapCopier.copy(slots);
        }

        public final String getConfirmationStatusAsString() {
            return this.confirmationStatus;
        }

        @Override
        public final Builder confirmationStatus(String confirmationStatus) {
            this.confirmationStatus = confirmationStatus;
            return this;
        }

        @Override
        public final Builder confirmationStatus(ConfirmationStatus confirmationStatus) {
            this.confirmationStatus(confirmationStatus == null ? null : confirmationStatus.toString());
            return this;
        }

        public final void setConfirmationStatus(String confirmationStatus) {
            this.confirmationStatus = confirmationStatus;
        }

        public final String getDialogActionTypeAsString() {
            return this.dialogActionType;
        }

        @Override
        public final Builder dialogActionType(String dialogActionType) {
            this.dialogActionType = dialogActionType;
            return this;
        }

        @Override
        public final Builder dialogActionType(DialogActionType dialogActionType) {
            this.dialogActionType(dialogActionType == null ? null : dialogActionType.toString());
            return this;
        }

        public final void setDialogActionType(String dialogActionType) {
            this.dialogActionType = dialogActionType;
        }

        public final String getFulfillmentStateAsString() {
            return this.fulfillmentState;
        }

        @Override
        public final Builder fulfillmentState(String fulfillmentState) {
            this.fulfillmentState = fulfillmentState;
            return this;
        }

        @Override
        public final Builder fulfillmentState(FulfillmentState fulfillmentState) {
            this.fulfillmentState(fulfillmentState == null ? null : fulfillmentState.toString());
            return this;
        }

        public final void setFulfillmentState(String fulfillmentState) {
            this.fulfillmentState = fulfillmentState;
        }

        public final String getSlotToElicit() {
            return this.slotToElicit;
        }

        @Override
        public final Builder slotToElicit(String slotToElicit) {
            this.slotToElicit = slotToElicit;
            return this;
        }

        public final void setSlotToElicit(String slotToElicit) {
            this.slotToElicit = slotToElicit;
        }

        public IntentSummary build() {
            return new IntentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IntentSummary> {
        public Builder intentName(String var1);

        public Builder slots(Map<String, String> var1);

        public Builder confirmationStatus(String var1);

        public Builder confirmationStatus(ConfirmationStatus var1);

        public Builder dialogActionType(String var1);

        public Builder dialogActionType(DialogActionType var1);

        public Builder fulfillmentState(String var1);

        public Builder fulfillmentState(FulfillmentState var1);

        public Builder slotToElicit(String var1);
    }
}

