/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lexruntime.DefaultLexRuntimeAsyncClient;
import software.amazon.awssdk.services.lexruntime.DefaultLexRuntimeBaseClientBuilder;
import software.amazon.awssdk.services.lexruntime.LexRuntimeAsyncClient;
import software.amazon.awssdk.services.lexruntime.LexRuntimeAsyncClientBuilder;
import software.amazon.awssdk.services.lexruntime.LexRuntimeServiceClientConfiguration;
import software.amazon.awssdk.services.lexruntime.endpoints.LexRuntimeEndpointProvider;

@SdkInternalApi
final class DefaultLexRuntimeAsyncClientBuilder
extends DefaultLexRuntimeBaseClientBuilder<LexRuntimeAsyncClientBuilder, LexRuntimeAsyncClient>
implements LexRuntimeAsyncClientBuilder {
    DefaultLexRuntimeAsyncClientBuilder() {
    }

    @Override
    public DefaultLexRuntimeAsyncClientBuilder endpointProvider(LexRuntimeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final LexRuntimeAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultLexRuntimeAsyncClientBuilder.validateClientOptions(clientConfiguration);
        LexRuntimeServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultLexRuntimeAsyncClient client = new DefaultLexRuntimeAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private LexRuntimeServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return LexRuntimeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

