/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lexruntime.DefaultLexRuntimeBaseClientBuilder;
import software.amazon.awssdk.services.lexruntime.DefaultLexRuntimeClient;
import software.amazon.awssdk.services.lexruntime.LexRuntimeClient;
import software.amazon.awssdk.services.lexruntime.LexRuntimeClientBuilder;
import software.amazon.awssdk.services.lexruntime.LexRuntimeServiceClientConfiguration;
import software.amazon.awssdk.services.lexruntime.endpoints.LexRuntimeEndpointProvider;

@SdkInternalApi
final class DefaultLexRuntimeClientBuilder
extends DefaultLexRuntimeBaseClientBuilder<LexRuntimeClientBuilder, LexRuntimeClient>
implements LexRuntimeClientBuilder {
    DefaultLexRuntimeClientBuilder() {
    }

    @Override
    public DefaultLexRuntimeClientBuilder endpointProvider(LexRuntimeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final LexRuntimeClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultLexRuntimeClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        LexRuntimeServiceClientConfiguration serviceClientConfiguration = LexRuntimeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultLexRuntimeClient(serviceClientConfiguration, clientConfiguration);
    }
}

