/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexruntime.model.LexRuntimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSessionRequest
extends LexRuntimeRequest
implements ToCopyableBuilder<Builder, GetSessionRequest> {
    private static final SdkField<String> BOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botName").getter(GetSessionRequest.getter(GetSessionRequest::botName)).setter(GetSessionRequest.setter(Builder::botName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botName").build()}).build();
    private static final SdkField<String> BOT_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botAlias").getter(GetSessionRequest.getter(GetSessionRequest::botAlias)).setter(GetSessionRequest.setter(Builder::botAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botAlias").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(GetSessionRequest.getter(GetSessionRequest::userId)).setter(GetSessionRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("userId").build()}).build();
    private static final SdkField<String> CHECKPOINT_LABEL_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("checkpointLabelFilter").getter(GetSessionRequest.getter(GetSessionRequest::checkpointLabelFilter)).setter(GetSessionRequest.setter(Builder::checkpointLabelFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("checkpointLabelFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_NAME_FIELD, BOT_ALIAS_FIELD, USER_ID_FIELD, CHECKPOINT_LABEL_FILTER_FIELD));
    private final String botName;
    private final String botAlias;
    private final String userId;
    private final String checkpointLabelFilter;

    private GetSessionRequest(BuilderImpl builder) {
        super(builder);
        this.botName = builder.botName;
        this.botAlias = builder.botAlias;
        this.userId = builder.userId;
        this.checkpointLabelFilter = builder.checkpointLabelFilter;
    }

    public final String botName() {
        return this.botName;
    }

    public final String botAlias() {
        return this.botAlias;
    }

    public final String userId() {
        return this.userId;
    }

    public final String checkpointLabelFilter() {
        return this.checkpointLabelFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botName());
        hashCode = 31 * hashCode + Objects.hashCode(this.botAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkpointLabelFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionRequest)) {
            return false;
        }
        GetSessionRequest other = (GetSessionRequest)((Object)obj);
        return Objects.equals(this.botName(), other.botName()) && Objects.equals(this.botAlias(), other.botAlias()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.checkpointLabelFilter(), other.checkpointLabelFilter());
    }

    public final String toString() {
        return ToString.builder((String)"GetSessionRequest").add("BotName", (Object)this.botName()).add("BotAlias", (Object)this.botAlias()).add("UserId", (Object)this.userId()).add("CheckpointLabelFilter", (Object)this.checkpointLabelFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botName": {
                return Optional.ofNullable(clazz.cast(this.botName()));
            }
            case "botAlias": {
                return Optional.ofNullable(clazz.cast(this.botAlias()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "checkpointLabelFilter": {
                return Optional.ofNullable(clazz.cast(this.checkpointLabelFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSessionRequest, T> g) {
        return obj -> g.apply((GetSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexRuntimeRequest.BuilderImpl
    implements Builder {
        private String botName;
        private String botAlias;
        private String userId;
        private String checkpointLabelFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionRequest model) {
            super(model);
            this.botName(model.botName);
            this.botAlias(model.botAlias);
            this.userId(model.userId);
            this.checkpointLabelFilter(model.checkpointLabelFilter);
        }

        public final String getBotName() {
            return this.botName;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        @Override
        @Transient
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final String getBotAlias() {
            return this.botAlias;
        }

        public final void setBotAlias(String botAlias) {
            this.botAlias = botAlias;
        }

        @Override
        @Transient
        public final Builder botAlias(String botAlias) {
            this.botAlias = botAlias;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        @Transient
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getCheckpointLabelFilter() {
            return this.checkpointLabelFilter;
        }

        public final void setCheckpointLabelFilter(String checkpointLabelFilter) {
            this.checkpointLabelFilter = checkpointLabelFilter;
        }

        @Override
        @Transient
        public final Builder checkpointLabelFilter(String checkpointLabelFilter) {
            this.checkpointLabelFilter = checkpointLabelFilter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSessionRequest build() {
            return new GetSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSessionRequest> {
        public Builder botName(String var1);

        public Builder botAlias(String var1);

        public Builder userId(String var1);

        public Builder checkpointLabelFilter(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

