/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexruntime.model.ActiveContext;
import software.amazon.awssdk.services.lexruntime.model.ActiveContextsListCopier;
import software.amazon.awssdk.services.lexruntime.model.DialogAction;
import software.amazon.awssdk.services.lexruntime.model.IntentSummary;
import software.amazon.awssdk.services.lexruntime.model.IntentSummaryListCopier;
import software.amazon.awssdk.services.lexruntime.model.LexRuntimeRequest;
import software.amazon.awssdk.services.lexruntime.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutSessionRequest
extends LexRuntimeRequest
implements ToCopyableBuilder<Builder, PutSessionRequest> {
    private static final SdkField<String> BOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botName").getter(PutSessionRequest.getter(PutSessionRequest::botName)).setter(PutSessionRequest.setter(Builder::botName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botName").build()}).build();
    private static final SdkField<String> BOT_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botAlias").getter(PutSessionRequest.getter(PutSessionRequest::botAlias)).setter(PutSessionRequest.setter(Builder::botAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botAlias").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(PutSessionRequest.getter(PutSessionRequest::userId)).setter(PutSessionRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("userId").build()}).build();
    private static final SdkField<Map<String, String>> SESSION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("sessionAttributes").getter(PutSessionRequest.getter(PutSessionRequest::sessionAttributes)).setter(PutSessionRequest.setter(Builder::sessionAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<DialogAction> DIALOG_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dialogAction").getter(PutSessionRequest.getter(PutSessionRequest::dialogAction)).setter(PutSessionRequest.setter(Builder::dialogAction)).constructor(DialogAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogAction").build()}).build();
    private static final SdkField<List<IntentSummary>> RECENT_INTENT_SUMMARY_VIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recentIntentSummaryView").getter(PutSessionRequest.getter(PutSessionRequest::recentIntentSummaryView)).setter(PutSessionRequest.setter(Builder::recentIntentSummaryView)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recentIntentSummaryView").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IntentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ACCEPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accept").getter(PutSessionRequest.getter(PutSessionRequest::accept)).setter(PutSessionRequest.setter(Builder::accept)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Accept").build()}).build();
    private static final SdkField<List<ActiveContext>> ACTIVE_CONTEXTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("activeContexts").getter(PutSessionRequest.getter(PutSessionRequest::activeContexts)).setter(PutSessionRequest.setter(Builder::activeContexts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeContexts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActiveContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_NAME_FIELD, BOT_ALIAS_FIELD, USER_ID_FIELD, SESSION_ATTRIBUTES_FIELD, DIALOG_ACTION_FIELD, RECENT_INTENT_SUMMARY_VIEW_FIELD, ACCEPT_FIELD, ACTIVE_CONTEXTS_FIELD));
    private final String botName;
    private final String botAlias;
    private final String userId;
    private final Map<String, String> sessionAttributes;
    private final DialogAction dialogAction;
    private final List<IntentSummary> recentIntentSummaryView;
    private final String accept;
    private final List<ActiveContext> activeContexts;

    private PutSessionRequest(BuilderImpl builder) {
        super(builder);
        this.botName = builder.botName;
        this.botAlias = builder.botAlias;
        this.userId = builder.userId;
        this.sessionAttributes = builder.sessionAttributes;
        this.dialogAction = builder.dialogAction;
        this.recentIntentSummaryView = builder.recentIntentSummaryView;
        this.accept = builder.accept;
        this.activeContexts = builder.activeContexts;
    }

    public String botName() {
        return this.botName;
    }

    public String botAlias() {
        return this.botAlias;
    }

    public String userId() {
        return this.userId;
    }

    public boolean hasSessionAttributes() {
        return this.sessionAttributes != null && !(this.sessionAttributes instanceof SdkAutoConstructMap);
    }

    public Map<String, String> sessionAttributes() {
        return this.sessionAttributes;
    }

    public DialogAction dialogAction() {
        return this.dialogAction;
    }

    public boolean hasRecentIntentSummaryView() {
        return this.recentIntentSummaryView != null && !(this.recentIntentSummaryView instanceof SdkAutoConstructList);
    }

    public List<IntentSummary> recentIntentSummaryView() {
        return this.recentIntentSummaryView;
    }

    public String accept() {
        return this.accept;
    }

    public boolean hasActiveContexts() {
        return this.activeContexts != null && !(this.activeContexts instanceof SdkAutoConstructList);
    }

    public List<ActiveContext> activeContexts() {
        return this.activeContexts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botName());
        hashCode = 31 * hashCode + Objects.hashCode(this.botAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessionAttributes() ? this.sessionAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dialogAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecentIntentSummaryView() ? this.recentIntentSummaryView() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.accept());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActiveContexts() ? this.activeContexts() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSessionRequest)) {
            return false;
        }
        PutSessionRequest other = (PutSessionRequest)((Object)obj);
        return Objects.equals(this.botName(), other.botName()) && Objects.equals(this.botAlias(), other.botAlias()) && Objects.equals(this.userId(), other.userId()) && this.hasSessionAttributes() == other.hasSessionAttributes() && Objects.equals(this.sessionAttributes(), other.sessionAttributes()) && Objects.equals(this.dialogAction(), other.dialogAction()) && this.hasRecentIntentSummaryView() == other.hasRecentIntentSummaryView() && Objects.equals(this.recentIntentSummaryView(), other.recentIntentSummaryView()) && Objects.equals(this.accept(), other.accept()) && this.hasActiveContexts() == other.hasActiveContexts() && Objects.equals(this.activeContexts(), other.activeContexts());
    }

    public String toString() {
        return ToString.builder((String)"PutSessionRequest").add("BotName", (Object)this.botName()).add("BotAlias", (Object)this.botAlias()).add("UserId", (Object)this.userId()).add("SessionAttributes", (Object)(this.sessionAttributes() == null ? null : "*** Sensitive Data Redacted ***")).add("DialogAction", (Object)this.dialogAction()).add("RecentIntentSummaryView", this.hasRecentIntentSummaryView() ? this.recentIntentSummaryView() : null).add("Accept", (Object)this.accept()).add("ActiveContexts", (Object)(this.activeContexts() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botName": {
                return Optional.ofNullable(clazz.cast(this.botName()));
            }
            case "botAlias": {
                return Optional.ofNullable(clazz.cast(this.botAlias()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "sessionAttributes": {
                return Optional.ofNullable(clazz.cast(this.sessionAttributes()));
            }
            case "dialogAction": {
                return Optional.ofNullable(clazz.cast(this.dialogAction()));
            }
            case "recentIntentSummaryView": {
                return Optional.ofNullable(clazz.cast(this.recentIntentSummaryView()));
            }
            case "accept": {
                return Optional.ofNullable(clazz.cast(this.accept()));
            }
            case "activeContexts": {
                return Optional.ofNullable(clazz.cast(this.activeContexts()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutSessionRequest, T> g) {
        return obj -> g.apply((PutSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexRuntimeRequest.BuilderImpl
    implements Builder {
        private String botName;
        private String botAlias;
        private String userId;
        private Map<String, String> sessionAttributes = DefaultSdkAutoConstructMap.getInstance();
        private DialogAction dialogAction;
        private List<IntentSummary> recentIntentSummaryView = DefaultSdkAutoConstructList.getInstance();
        private String accept;
        private List<ActiveContext> activeContexts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutSessionRequest model) {
            super(model);
            this.botName(model.botName);
            this.botAlias(model.botAlias);
            this.userId(model.userId);
            this.sessionAttributes(model.sessionAttributes);
            this.dialogAction(model.dialogAction);
            this.recentIntentSummaryView(model.recentIntentSummaryView);
            this.accept(model.accept);
            this.activeContexts(model.activeContexts);
        }

        public final String getBotName() {
            return this.botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final String getBotAlias() {
            return this.botAlias;
        }

        @Override
        public final Builder botAlias(String botAlias) {
            this.botAlias = botAlias;
            return this;
        }

        public final void setBotAlias(String botAlias) {
            this.botAlias = botAlias;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final Map<String, String> getSessionAttributes() {
            if (this.sessionAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.sessionAttributes;
        }

        @Override
        public final Builder sessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
            return this;
        }

        public final void setSessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
        }

        public final DialogAction.Builder getDialogAction() {
            return this.dialogAction != null ? this.dialogAction.toBuilder() : null;
        }

        @Override
        public final Builder dialogAction(DialogAction dialogAction) {
            this.dialogAction = dialogAction;
            return this;
        }

        public final void setDialogAction(DialogAction.BuilderImpl dialogAction) {
            this.dialogAction = dialogAction != null ? dialogAction.build() : null;
        }

        public final Collection<IntentSummary.Builder> getRecentIntentSummaryView() {
            if (this.recentIntentSummaryView instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recentIntentSummaryView != null ? (Collection)this.recentIntentSummaryView.stream().map(IntentSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recentIntentSummaryView(Collection<IntentSummary> recentIntentSummaryView) {
            this.recentIntentSummaryView = IntentSummaryListCopier.copy(recentIntentSummaryView);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recentIntentSummaryView(IntentSummary ... recentIntentSummaryView) {
            this.recentIntentSummaryView(Arrays.asList(recentIntentSummaryView));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recentIntentSummaryView(Consumer<IntentSummary.Builder> ... recentIntentSummaryView) {
            this.recentIntentSummaryView(Stream.of(recentIntentSummaryView).map(c -> (IntentSummary)((IntentSummary.Builder)IntentSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecentIntentSummaryView(Collection<IntentSummary.BuilderImpl> recentIntentSummaryView) {
            this.recentIntentSummaryView = IntentSummaryListCopier.copyFromBuilder(recentIntentSummaryView);
        }

        public final String getAccept() {
            return this.accept;
        }

        @Override
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        public final Collection<ActiveContext.Builder> getActiveContexts() {
            if (this.activeContexts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.activeContexts != null ? (Collection)this.activeContexts.stream().map(ActiveContext::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder activeContexts(Collection<ActiveContext> activeContexts) {
            this.activeContexts = ActiveContextsListCopier.copy(activeContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeContexts(ActiveContext ... activeContexts) {
            this.activeContexts(Arrays.asList(activeContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeContexts(Consumer<ActiveContext.Builder> ... activeContexts) {
            this.activeContexts(Stream.of(activeContexts).map(c -> (ActiveContext)((ActiveContext.Builder)ActiveContext.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActiveContexts(Collection<ActiveContext.BuilderImpl> activeContexts) {
            this.activeContexts = ActiveContextsListCopier.copyFromBuilder(activeContexts);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSessionRequest build() {
            return new PutSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutSessionRequest> {
        public Builder botName(String var1);

        public Builder botAlias(String var1);

        public Builder userId(String var1);

        public Builder sessionAttributes(Map<String, String> var1);

        public Builder dialogAction(DialogAction var1);

        default public Builder dialogAction(Consumer<DialogAction.Builder> dialogAction) {
            return this.dialogAction((DialogAction)((DialogAction.Builder)DialogAction.builder().applyMutation(dialogAction)).build());
        }

        public Builder recentIntentSummaryView(Collection<IntentSummary> var1);

        public Builder recentIntentSummaryView(IntentSummary ... var1);

        public Builder recentIntentSummaryView(Consumer<IntentSummary.Builder> ... var1);

        public Builder accept(String var1);

        public Builder activeContexts(Collection<ActiveContext> var1);

        public Builder activeContexts(ActiveContext ... var1);

        public Builder activeContexts(Consumer<ActiveContext.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

