/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexruntime.model.DialogState;
import software.amazon.awssdk.services.lexruntime.model.LexRuntimeResponse;
import software.amazon.awssdk.services.lexruntime.model.MessageFormatType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PostContentResponse
extends LexRuntimeResponse
implements ToCopyableBuilder<Builder, PostContentResponse> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PostContentResponse.getter(PostContentResponse::contentType)).setter(PostContentResponse.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PostContentResponse.getter(PostContentResponse::intentName)).setter(PostContentResponse.setter(Builder::intentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-intent-name").build()}).build();
    private static final SdkField<String> SLOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PostContentResponse.getter(PostContentResponse::slots)).setter(PostContentResponse.setter(Builder::slots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-slots").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> SESSION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PostContentResponse.getter(PostContentResponse::sessionAttributes)).setter(PostContentResponse.setter(Builder::sessionAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-session-attributes").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PostContentResponse.getter(PostContentResponse::message)).setter(PostContentResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-message").build()}).build();
    private static final SdkField<String> MESSAGE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PostContentResponse.getter(PostContentResponse::messageFormatAsString)).setter(PostContentResponse.setter(Builder::messageFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-message-format").build()}).build();
    private static final SdkField<String> DIALOG_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PostContentResponse.getter(PostContentResponse::dialogStateAsString)).setter(PostContentResponse.setter(Builder::dialogState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-dialog-state").build()}).build();
    private static final SdkField<String> SLOT_TO_ELICIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PostContentResponse.getter(PostContentResponse::slotToElicit)).setter(PostContentResponse.setter(Builder::slotToElicit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-slot-to-elicit").build()}).build();
    private static final SdkField<String> INPUT_TRANSCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PostContentResponse.getter(PostContentResponse::inputTranscript)).setter(PostContentResponse.setter(Builder::inputTranscript)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-input-transcript").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD, INTENT_NAME_FIELD, SLOTS_FIELD, SESSION_ATTRIBUTES_FIELD, MESSAGE_FIELD, MESSAGE_FORMAT_FIELD, DIALOG_STATE_FIELD, SLOT_TO_ELICIT_FIELD, INPUT_TRANSCRIPT_FIELD));
    private final String contentType;
    private final String intentName;
    private final String slots;
    private final String sessionAttributes;
    private final String message;
    private final String messageFormat;
    private final String dialogState;
    private final String slotToElicit;
    private final String inputTranscript;

    private PostContentResponse(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.intentName = builder.intentName;
        this.slots = builder.slots;
        this.sessionAttributes = builder.sessionAttributes;
        this.message = builder.message;
        this.messageFormat = builder.messageFormat;
        this.dialogState = builder.dialogState;
        this.slotToElicit = builder.slotToElicit;
        this.inputTranscript = builder.inputTranscript;
    }

    public String contentType() {
        return this.contentType;
    }

    public String intentName() {
        return this.intentName;
    }

    public String slots() {
        return this.slots;
    }

    public String sessionAttributes() {
        return this.sessionAttributes;
    }

    public String message() {
        return this.message;
    }

    public MessageFormatType messageFormat() {
        return MessageFormatType.fromValue(this.messageFormat);
    }

    public String messageFormatAsString() {
        return this.messageFormat;
    }

    public DialogState dialogState() {
        return DialogState.fromValue(this.dialogState);
    }

    public String dialogStateAsString() {
        return this.dialogState;
    }

    public String slotToElicit() {
        return this.slotToElicit;
    }

    public String inputTranscript() {
        return this.inputTranscript;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.intentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.slots());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dialogStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotToElicit());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputTranscript());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostContentResponse)) {
            return false;
        }
        PostContentResponse other = (PostContentResponse)((Object)obj);
        return Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.intentName(), other.intentName()) && Objects.equals(this.slots(), other.slots()) && Objects.equals(this.sessionAttributes(), other.sessionAttributes()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.messageFormatAsString(), other.messageFormatAsString()) && Objects.equals(this.dialogStateAsString(), other.dialogStateAsString()) && Objects.equals(this.slotToElicit(), other.slotToElicit()) && Objects.equals(this.inputTranscript(), other.inputTranscript());
    }

    public String toString() {
        return ToString.builder((String)"PostContentResponse").add("ContentType", (Object)this.contentType()).add("IntentName", (Object)this.intentName()).add("Slots", (Object)this.slots()).add("SessionAttributes", (Object)this.sessionAttributes()).add("Message", (Object)this.message()).add("MessageFormat", (Object)this.messageFormatAsString()).add("DialogState", (Object)this.dialogStateAsString()).add("SlotToElicit", (Object)this.slotToElicit()).add("InputTranscript", (Object)this.inputTranscript()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "intentName": {
                return Optional.ofNullable(clazz.cast(this.intentName()));
            }
            case "slots": {
                return Optional.ofNullable(clazz.cast(this.slots()));
            }
            case "sessionAttributes": {
                return Optional.ofNullable(clazz.cast(this.sessionAttributes()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "messageFormat": {
                return Optional.ofNullable(clazz.cast(this.messageFormatAsString()));
            }
            case "dialogState": {
                return Optional.ofNullable(clazz.cast(this.dialogStateAsString()));
            }
            case "slotToElicit": {
                return Optional.ofNullable(clazz.cast(this.slotToElicit()));
            }
            case "inputTranscript": {
                return Optional.ofNullable(clazz.cast(this.inputTranscript()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostContentResponse, T> g) {
        return obj -> g.apply((PostContentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexRuntimeResponse.BuilderImpl
    implements Builder {
        private String contentType;
        private String intentName;
        private String slots;
        private String sessionAttributes;
        private String message;
        private String messageFormat;
        private String dialogState;
        private String slotToElicit;
        private String inputTranscript;

        private BuilderImpl() {
        }

        private BuilderImpl(PostContentResponse model) {
            super(model);
            this.contentType(model.contentType);
            this.intentName(model.intentName);
            this.slots(model.slots);
            this.sessionAttributes(model.sessionAttributes);
            this.message(model.message);
            this.messageFormat(model.messageFormat);
            this.dialogState(model.dialogState);
            this.slotToElicit(model.slotToElicit);
            this.inputTranscript(model.inputTranscript);
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getIntentName() {
            return this.intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        public final String getSlots() {
            return this.slots;
        }

        @Override
        public final Builder slots(String slots) {
            this.slots = slots;
            return this;
        }

        public final void setSlots(String slots) {
            this.slots = slots;
        }

        public final String getSessionAttributes() {
            return this.sessionAttributes;
        }

        @Override
        public final Builder sessionAttributes(String sessionAttributes) {
            this.sessionAttributes = sessionAttributes;
            return this;
        }

        public final void setSessionAttributes(String sessionAttributes) {
            this.sessionAttributes = sessionAttributes;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getMessageFormat() {
            return this.messageFormat;
        }

        @Override
        public final Builder messageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        @Override
        public final Builder messageFormat(MessageFormatType messageFormat) {
            this.messageFormat(messageFormat.toString());
            return this;
        }

        public final void setMessageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
        }

        public final String getDialogState() {
            return this.dialogState;
        }

        @Override
        public final Builder dialogState(String dialogState) {
            this.dialogState = dialogState;
            return this;
        }

        @Override
        public final Builder dialogState(DialogState dialogState) {
            this.dialogState(dialogState.toString());
            return this;
        }

        public final void setDialogState(String dialogState) {
            this.dialogState = dialogState;
        }

        public final String getSlotToElicit() {
            return this.slotToElicit;
        }

        @Override
        public final Builder slotToElicit(String slotToElicit) {
            this.slotToElicit = slotToElicit;
            return this;
        }

        public final void setSlotToElicit(String slotToElicit) {
            this.slotToElicit = slotToElicit;
        }

        public final String getInputTranscript() {
            return this.inputTranscript;
        }

        @Override
        public final Builder inputTranscript(String inputTranscript) {
            this.inputTranscript = inputTranscript;
            return this;
        }

        public final void setInputTranscript(String inputTranscript) {
            this.inputTranscript = inputTranscript;
        }

        @Override
        public PostContentResponse build() {
            return new PostContentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PostContentResponse> {
        public Builder contentType(String var1);

        public Builder intentName(String var1);

        public Builder slots(String var1);

        public Builder sessionAttributes(String var1);

        public Builder message(String var1);

        public Builder messageFormat(String var1);

        public Builder messageFormat(MessageFormatType var1);

        public Builder dialogState(String var1);

        public Builder dialogState(DialogState var1);

        public Builder slotToElicit(String var1);

        public Builder inputTranscript(String var1);
    }
}

