/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lexruntime.model.GenericAttachment;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GenericAttachmentMarshaller {
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("title").isBinary(false).build();
    private static final MarshallingInfo<String> SUBTITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subTitle").isBinary(false).build();
    private static final MarshallingInfo<String> ATTACHMENTLINKURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attachmentLinkUrl").isBinary(false).build();
    private static final MarshallingInfo<String> IMAGEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageUrl").isBinary(false).build();
    private static final MarshallingInfo<List> BUTTONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("buttons").isBinary(false).build();
    private static final GenericAttachmentMarshaller INSTANCE = new GenericAttachmentMarshaller();

    private GenericAttachmentMarshaller() {
    }

    public static GenericAttachmentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GenericAttachment genericAttachment, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)genericAttachment, (String)"genericAttachment");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)genericAttachment.title(), TITLE_BINDING);
            protocolMarshaller.marshall((Object)genericAttachment.subTitle(), SUBTITLE_BINDING);
            protocolMarshaller.marshall((Object)genericAttachment.attachmentLinkUrl(), ATTACHMENTLINKURL_BINDING);
            protocolMarshaller.marshall((Object)genericAttachment.imageUrl(), IMAGEURL_BINDING);
            protocolMarshaller.marshall(genericAttachment.buttons(), BUTTONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

