/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.lexruntime.model.LexRuntimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PostContentRequest
extends LexRuntimeRequest
implements ToCopyableBuilder<Builder, PostContentRequest> {
    private final String botName;
    private final String botAlias;
    private final String userId;
    private final String sessionAttributes;
    private final String requestAttributes;
    private final String contentType;
    private final String accept;

    private PostContentRequest(BuilderImpl builder) {
        super(builder);
        this.botName = builder.botName;
        this.botAlias = builder.botAlias;
        this.userId = builder.userId;
        this.sessionAttributes = builder.sessionAttributes;
        this.requestAttributes = builder.requestAttributes;
        this.contentType = builder.contentType;
        this.accept = builder.accept;
    }

    public String botName() {
        return this.botName;
    }

    public String botAlias() {
        return this.botAlias;
    }

    public String userId() {
        return this.userId;
    }

    public String sessionAttributes() {
        return this.sessionAttributes;
    }

    public String requestAttributes() {
        return this.requestAttributes;
    }

    public String contentType() {
        return this.contentType;
    }

    public String accept() {
        return this.accept;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.botName());
        hashCode = 31 * hashCode + Objects.hashCode(this.botAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.accept());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostContentRequest)) {
            return false;
        }
        PostContentRequest other = (PostContentRequest)((Object)obj);
        return Objects.equals(this.botName(), other.botName()) && Objects.equals(this.botAlias(), other.botAlias()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.sessionAttributes(), other.sessionAttributes()) && Objects.equals(this.requestAttributes(), other.requestAttributes()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.accept(), other.accept());
    }

    public String toString() {
        return ToString.builder((String)"PostContentRequest").add("BotName", (Object)this.botName()).add("BotAlias", (Object)this.botAlias()).add("UserId", (Object)this.userId()).add("SessionAttributes", (Object)this.sessionAttributes()).add("RequestAttributes", (Object)this.requestAttributes()).add("ContentType", (Object)this.contentType()).add("Accept", (Object)this.accept()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botName": {
                return Optional.ofNullable(clazz.cast(this.botName()));
            }
            case "botAlias": {
                return Optional.ofNullable(clazz.cast(this.botAlias()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "sessionAttributes": {
                return Optional.ofNullable(clazz.cast(this.sessionAttributes()));
            }
            case "requestAttributes": {
                return Optional.ofNullable(clazz.cast(this.requestAttributes()));
            }
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "accept": {
                return Optional.ofNullable(clazz.cast(this.accept()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LexRuntimeRequest.BuilderImpl
    implements Builder {
        private String botName;
        private String botAlias;
        private String userId;
        private String sessionAttributes;
        private String requestAttributes;
        private String contentType;
        private String accept;

        private BuilderImpl() {
        }

        private BuilderImpl(PostContentRequest model) {
            super(model);
            this.botName(model.botName);
            this.botAlias(model.botAlias);
            this.userId(model.userId);
            this.sessionAttributes(model.sessionAttributes);
            this.requestAttributes(model.requestAttributes);
            this.contentType(model.contentType);
            this.accept(model.accept);
        }

        public final String getBotName() {
            return this.botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final String getBotAlias() {
            return this.botAlias;
        }

        @Override
        public final Builder botAlias(String botAlias) {
            this.botAlias = botAlias;
            return this;
        }

        public final void setBotAlias(String botAlias) {
            this.botAlias = botAlias;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getSessionAttributes() {
            return this.sessionAttributes;
        }

        @Override
        public final Builder sessionAttributes(String sessionAttributes) {
            this.sessionAttributes = sessionAttributes;
            return this;
        }

        public final void setSessionAttributes(String sessionAttributes) {
            this.sessionAttributes = sessionAttributes;
        }

        public final String getRequestAttributes() {
            return this.requestAttributes;
        }

        @Override
        public final Builder requestAttributes(String requestAttributes) {
            this.requestAttributes = requestAttributes;
            return this;
        }

        public final void setRequestAttributes(String requestAttributes) {
            this.requestAttributes = requestAttributes;
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getAccept() {
            return this.accept;
        }

        @Override
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PostContentRequest build() {
            return new PostContentRequest(this);
        }
    }

    public static interface Builder
    extends LexRuntimeRequest.Builder,
    CopyableBuilder<Builder, PostContentRequest> {
        public Builder botName(String var1);

        public Builder botAlias(String var1);

        public Builder userId(String var1);

        public Builder sessionAttributes(String var1);

        public Builder requestAttributes(String var1);

        public Builder contentType(String var1);

        public Builder accept(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

