/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexruntime.transform.ButtonMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Button
implements StructuredPojo,
ToCopyableBuilder<Builder, Button> {
    private final String text;
    private final String value;

    private Button(BuilderImpl builder) {
        this.text = builder.text;
        this.value = builder.value;
    }

    public String text() {
        return this.text;
    }

    public String value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Button)) {
            return false;
        }
        Button other = (Button)obj;
        return Objects.equals(this.text(), other.text()) && Objects.equals(this.value(), other.value());
    }

    public String toString() {
        return ToString.builder((String)"Button").add("Text", (Object)this.text()).add("Value", (Object)this.value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ButtonMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String text;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Button model) {
            this.text(model.text);
            this.value(model.value);
        }

        public final String getText() {
            return this.text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public Button build() {
            return new Button(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Button> {
        public Builder text(String var1);

        public Builder value(String var1);
    }
}

