/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the audio for an utterance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UtteranceAudioInputSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<UtteranceAudioInputSpecification.Builder, UtteranceAudioInputSpecification> {
    private static final SdkField<String> AUDIO_FILE_S3_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("audioFileS3Location").getter(getter(UtteranceAudioInputSpecification::audioFileS3Location))
            .setter(setter(Builder::audioFileS3Location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioFileS3Location").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_FILE_S3_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String audioFileS3Location;

    private UtteranceAudioInputSpecification(BuilderImpl builder) {
        this.audioFileS3Location = builder.audioFileS3Location;
    }

    /**
     * <p>
     * Amazon S3 file pointing to the audio.
     * </p>
     * 
     * @return Amazon S3 file pointing to the audio.
     */
    public final String audioFileS3Location() {
        return audioFileS3Location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioFileS3Location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UtteranceAudioInputSpecification)) {
            return false;
        }
        UtteranceAudioInputSpecification other = (UtteranceAudioInputSpecification) obj;
        return Objects.equals(audioFileS3Location(), other.audioFileS3Location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UtteranceAudioInputSpecification").add("AudioFileS3Location", audioFileS3Location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "audioFileS3Location":
            return Optional.ofNullable(clazz.cast(audioFileS3Location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("audioFileS3Location", AUDIO_FILE_S3_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UtteranceAudioInputSpecification, T> g) {
        return obj -> g.apply((UtteranceAudioInputSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UtteranceAudioInputSpecification> {
        /**
         * <p>
         * Amazon S3 file pointing to the audio.
         * </p>
         * 
         * @param audioFileS3Location
         *        Amazon S3 file pointing to the audio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioFileS3Location(String audioFileS3Location);
    }

    static final class BuilderImpl implements Builder {
        private String audioFileS3Location;

        private BuilderImpl() {
        }

        private BuilderImpl(UtteranceAudioInputSpecification model) {
            audioFileS3Location(model.audioFileS3Location);
        }

        public final String getAudioFileS3Location() {
            return audioFileS3Location;
        }

        public final void setAudioFileS3Location(String audioFileS3Location) {
            this.audioFileS3Location = audioFileS3Location;
        }

        @Override
        public final Builder audioFileS3Location(String audioFileS3Location) {
            this.audioFileS3Location = audioFileS3Location;
            return this;
        }

        @Override
        public UtteranceAudioInputSpecification build() {
            return new UtteranceAudioInputSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
