/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a slot output by the test set execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserTurnSlotOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<UserTurnSlotOutput.Builder, UserTurnSlotOutput> {
    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(UserTurnSlotOutput::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<List<UserTurnSlotOutput>> VALUES_FIELD = SdkField
            .<List<UserTurnSlotOutput>> builder(MarshallingType.LIST)
            .memberName("values")
            .getter(getter(UserTurnSlotOutput::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserTurnSlotOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserTurnSlotOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, UserTurnSlotOutput>> SUB_SLOTS_FIELD = SdkField
            .<Map<String, UserTurnSlotOutput>> builder(MarshallingType.MAP)
            .memberName("subSlots")
            .getter(getter(UserTurnSlotOutput::subSlots))
            .setter(setter(Builder::subSlots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subSlots").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<UserTurnSlotOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserTurnSlotOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, VALUES_FIELD,
            SUB_SLOTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String value;

    private final List<UserTurnSlotOutput> values;

    private final Map<String, UserTurnSlotOutput> subSlots;

    private UserTurnSlotOutput(BuilderImpl builder) {
        this.value = builder.value;
        this.values = builder.values;
        this.subSlots = builder.subSlots;
    }

    /**
     * <p>
     * The value output by the slot recognition.
     * </p>
     * 
     * @return The value output by the slot recognition.
     */
    public final String value() {
        return value;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Values that are output by the slot recognition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return Values that are output by the slot recognition.
     */
    public final List<UserTurnSlotOutput> values() {
        return values;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubSlots property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubSlots() {
        return subSlots != null && !(subSlots instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of items mapping the name of the subslots to information about those subslots.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubSlots} method.
     * </p>
     * 
     * @return A list of items mapping the name of the subslots to information about those subslots.
     */
    public final Map<String, UserTurnSlotOutput> subSlots() {
        return subSlots;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubSlots() ? subSlots() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserTurnSlotOutput)) {
            return false;
        }
        UserTurnSlotOutput other = (UserTurnSlotOutput) obj;
        return Objects.equals(value(), other.value()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values()) && hasSubSlots() == other.hasSubSlots()
                && Objects.equals(subSlots(), other.subSlots());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserTurnSlotOutput").add("Value", value()).add("Values", hasValues() ? values() : null)
                .add("SubSlots", hasSubSlots() ? subSlots() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "values":
            return Optional.ofNullable(clazz.cast(values()));
        case "subSlots":
            return Optional.ofNullable(clazz.cast(subSlots()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("value", VALUE_FIELD);
        map.put("values", VALUES_FIELD);
        map.put("subSlots", SUB_SLOTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserTurnSlotOutput, T> g) {
        return obj -> g.apply((UserTurnSlotOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserTurnSlotOutput> {
        /**
         * <p>
         * The value output by the slot recognition.
         * </p>
         * 
         * @param value
         *        The value output by the slot recognition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * Values that are output by the slot recognition.
         * </p>
         * 
         * @param values
         *        Values that are output by the slot recognition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<UserTurnSlotOutput> values);

        /**
         * <p>
         * Values that are output by the slot recognition.
         * </p>
         * 
         * @param values
         *        Values that are output by the slot recognition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(UserTurnSlotOutput... values);

        /**
         * <p>
         * Values that are output by the slot recognition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.UserTurnSlotOutput.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.UserTurnSlotOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.UserTurnSlotOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #values(List<UserTurnSlotOutput>)}.
         * 
         * @param values
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.UserTurnSlotOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(java.util.Collection<UserTurnSlotOutput>)
         */
        Builder values(Consumer<Builder>... values);

        /**
         * <p>
         * A list of items mapping the name of the subslots to information about those subslots.
         * </p>
         * 
         * @param subSlots
         *        A list of items mapping the name of the subslots to information about those subslots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subSlots(Map<String, UserTurnSlotOutput> subSlots);
    }

    static final class BuilderImpl implements Builder {
        private String value;

        private List<UserTurnSlotOutput> values = DefaultSdkAutoConstructList.getInstance();

        private Map<String, UserTurnSlotOutput> subSlots = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UserTurnSlotOutput model) {
            value(model.value);
            values(model.values);
            subSlots(model.subSlots);
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final List<Builder> getValues() {
            List<Builder> result = UserTurnSlotOutputListCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<BuilderImpl> values) {
            this.values = UserTurnSlotOutputListCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<UserTurnSlotOutput> values) {
            this.values = UserTurnSlotOutputListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(UserTurnSlotOutput... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<Builder>... values) {
            values(Stream.of(values).map(c -> UserTurnSlotOutput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, Builder> getSubSlots() {
            Map<String, Builder> result = UserTurnSlotOutputMapCopier.copyToBuilder(this.subSlots);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSubSlots(Map<String, BuilderImpl> subSlots) {
            this.subSlots = UserTurnSlotOutputMapCopier.copyFromBuilder(subSlots);
        }

        @Override
        public final Builder subSlots(Map<String, UserTurnSlotOutput> subSlots) {
            this.subSlots = UserTurnSlotOutputMapCopier.copy(subSlots);
            return this;
        }

        @Override
        public UserTurnSlotOutput build() {
            return new UserTurnSlotOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
