/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBotLocaleResponse extends LexModelsV2Response implements
        ToCopyableBuilder<UpdateBotLocaleResponse.Builder, UpdateBotLocaleResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(UpdateBotLocaleResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(UpdateBotLocaleResponse::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(UpdateBotLocaleResponse::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<String> LOCALE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeName").getter(getter(UpdateBotLocaleResponse::localeName)).setter(setter(Builder::localeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateBotLocaleResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Double> NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("nluIntentConfidenceThreshold")
            .getter(getter(UpdateBotLocaleResponse::nluIntentConfidenceThreshold))
            .setter(setter(Builder::nluIntentConfidenceThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nluIntentConfidenceThreshold")
                    .build()).build();

    private static final SdkField<VoiceSettings> VOICE_SETTINGS_FIELD = SdkField
            .<VoiceSettings> builder(MarshallingType.SDK_POJO).memberName("voiceSettings")
            .getter(getter(UpdateBotLocaleResponse::voiceSettings)).setter(setter(Builder::voiceSettings))
            .constructor(VoiceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("voiceSettings").build()).build();

    private static final SdkField<UnifiedSpeechSettings> UNIFIED_SPEECH_SETTINGS_FIELD = SdkField
            .<UnifiedSpeechSettings> builder(MarshallingType.SDK_POJO).memberName("unifiedSpeechSettings")
            .getter(getter(UpdateBotLocaleResponse::unifiedSpeechSettings)).setter(setter(Builder::unifiedSpeechSettings))
            .constructor(UnifiedSpeechSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unifiedSpeechSettings").build())
            .build();

    private static final SdkField<SpeechRecognitionSettings> SPEECH_RECOGNITION_SETTINGS_FIELD = SdkField
            .<SpeechRecognitionSettings> builder(MarshallingType.SDK_POJO).memberName("speechRecognitionSettings")
            .getter(getter(UpdateBotLocaleResponse::speechRecognitionSettings))
            .setter(setter(Builder::speechRecognitionSettings)).constructor(SpeechRecognitionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speechRecognitionSettings").build())
            .build();

    private static final SdkField<String> BOT_LOCALE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botLocaleStatus").getter(getter(UpdateBotLocaleResponse::botLocaleStatusAsString))
            .setter(setter(Builder::botLocaleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botLocaleStatus").build()).build();

    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("failureReasons")
            .getter(getter(UpdateBotLocaleResponse::failureReasons))
            .setter(setter(Builder::failureReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(UpdateBotLocaleResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(UpdateBotLocaleResponse::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<List<String>> RECOMMENDED_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("recommendedActions")
            .getter(getter(UpdateBotLocaleResponse::recommendedActions))
            .setter(setter(Builder::recommendedActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<GenerativeAISettings> GENERATIVE_AI_SETTINGS_FIELD = SdkField
            .<GenerativeAISettings> builder(MarshallingType.SDK_POJO).memberName("generativeAISettings")
            .getter(getter(UpdateBotLocaleResponse::generativeAISettings)).setter(setter(Builder::generativeAISettings))
            .constructor(GenerativeAISettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generativeAISettings").build())
            .build();

    private static final SdkField<String> SPEECH_DETECTION_SENSITIVITY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("speechDetectionSensitivity")
            .getter(getter(UpdateBotLocaleResponse::speechDetectionSensitivityAsString))
            .setter(setter(Builder::speechDetectionSensitivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speechDetectionSensitivity").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_ID_FIELD, LOCALE_NAME_FIELD, DESCRIPTION_FIELD, NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD,
            VOICE_SETTINGS_FIELD, UNIFIED_SPEECH_SETTINGS_FIELD, SPEECH_RECOGNITION_SETTINGS_FIELD, BOT_LOCALE_STATUS_FIELD,
            FAILURE_REASONS_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, RECOMMENDED_ACTIONS_FIELD,
            GENERATIVE_AI_SETTINGS_FIELD, SPEECH_DETECTION_SENSITIVITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final String localeName;

    private final String description;

    private final Double nluIntentConfidenceThreshold;

    private final VoiceSettings voiceSettings;

    private final UnifiedSpeechSettings unifiedSpeechSettings;

    private final SpeechRecognitionSettings speechRecognitionSettings;

    private final String botLocaleStatus;

    private final List<String> failureReasons;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private final List<String> recommendedActions;

    private final GenerativeAISettings generativeAISettings;

    private final String speechDetectionSensitivity;

    private UpdateBotLocaleResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.localeName = builder.localeName;
        this.description = builder.description;
        this.nluIntentConfidenceThreshold = builder.nluIntentConfidenceThreshold;
        this.voiceSettings = builder.voiceSettings;
        this.unifiedSpeechSettings = builder.unifiedSpeechSettings;
        this.speechRecognitionSettings = builder.speechRecognitionSettings;
        this.botLocaleStatus = builder.botLocaleStatus;
        this.failureReasons = builder.failureReasons;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.recommendedActions = builder.recommendedActions;
        this.generativeAISettings = builder.generativeAISettings;
        this.speechDetectionSensitivity = builder.speechDetectionSensitivity;
    }

    /**
     * <p>
     * The identifier of the bot that contains the updated locale.
     * </p>
     * 
     * @return The identifier of the bot that contains the updated locale.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot that contains the updated locale.
     * </p>
     * 
     * @return The version of the bot that contains the updated locale.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The language and locale of the updated bot locale.
     * </p>
     * 
     * @return The language and locale of the updated bot locale.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The updated locale name for the locale.
     * </p>
     * 
     * @return The updated locale name for the locale.
     */
    public final String localeName() {
        return localeName;
    }

    /**
     * <p>
     * The updated description of the locale.
     * </p>
     * 
     * @return The updated description of the locale.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The updated confidence threshold for inserting the <code>AMAZON.FallbackIntent</code> and
     * <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.
     * </p>
     * 
     * @return The updated confidence threshold for inserting the <code>AMAZON.FallbackIntent</code> and
     *         <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.
     */
    public final Double nluIntentConfidenceThreshold() {
        return nluIntentConfidenceThreshold;
    }

    /**
     * <p>
     * The updated Amazon Polly voice to use for voice interaction with the user.
     * </p>
     * 
     * @return The updated Amazon Polly voice to use for voice interaction with the user.
     */
    public final VoiceSettings voiceSettings() {
        return voiceSettings;
    }

    /**
     * <p>
     * The updated unified speech settings for the bot locale.
     * </p>
     * 
     * @return The updated unified speech settings for the bot locale.
     */
    public final UnifiedSpeechSettings unifiedSpeechSettings() {
        return unifiedSpeechSettings;
    }

    /**
     * <p>
     * The updated speech-to-text settings for the bot locale.
     * </p>
     * 
     * @return The updated speech-to-text settings for the bot locale.
     */
    public final SpeechRecognitionSettings speechRecognitionSettings() {
        return speechRecognitionSettings;
    }

    /**
     * <p>
     * The current status of the locale. When the bot status is <code>Built</code> the locale is ready for use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botLocaleStatus}
     * will return {@link BotLocaleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #botLocaleStatusAsString}.
     * </p>
     * 
     * @return The current status of the locale. When the bot status is <code>Built</code> the locale is ready for use.
     * @see BotLocaleStatus
     */
    public final BotLocaleStatus botLocaleStatus() {
        return BotLocaleStatus.fromValue(botLocaleStatus);
    }

    /**
     * <p>
     * The current status of the locale. When the bot status is <code>Built</code> the locale is ready for use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botLocaleStatus}
     * will return {@link BotLocaleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #botLocaleStatusAsString}.
     * </p>
     * 
     * @return The current status of the locale. When the bot status is <code>Built</code> the locale is ready for use.
     * @see BotLocaleStatus
     */
    public final String botLocaleStatusAsString() {
        return botLocaleStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailureReasons property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailureReasons() {
        return failureReasons != null && !(failureReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the <code>botLocaleStatus</code> is <code>Failed</code>, the <code>failureReasons</code> field lists the
     * errors that occurred while building the bot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailureReasons} method.
     * </p>
     * 
     * @return If the <code>botLocaleStatus</code> is <code>Failed</code>, the <code>failureReasons</code> field lists
     *         the errors that occurred while building the bot.
     */
    public final List<String> failureReasons() {
        return failureReasons;
    }

    /**
     * <p>
     * A timestamp of the date and time that the locale was created.
     * </p>
     * 
     * @return A timestamp of the date and time that the locale was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * A timestamp of the date and time that the locale was last updated.
     * </p>
     * 
     * @return A timestamp of the date and time that the locale was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecommendedActions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecommendedActions() {
        return recommendedActions != null && !(recommendedActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Recommended actions to take to resolve an error in the <code>failureReasons</code> field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecommendedActions} method.
     * </p>
     * 
     * @return Recommended actions to take to resolve an error in the <code>failureReasons</code> field.
     */
    public final List<String> recommendedActions() {
        return recommendedActions;
    }

    /**
     * <p>
     * Contains settings for generative AI features powered by Amazon Bedrock for your bot locale.
     * </p>
     * 
     * @return Contains settings for generative AI features powered by Amazon Bedrock for your bot locale.
     */
    public final GenerativeAISettings generativeAISettings() {
        return generativeAISettings;
    }

    /**
     * <p>
     * The updated sensitivity level for voice activity detection (VAD) in the bot locale.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #speechDetectionSensitivity} will return {@link SpeechDetectionSensitivity#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #speechDetectionSensitivityAsString}.
     * </p>
     * 
     * @return The updated sensitivity level for voice activity detection (VAD) in the bot locale.
     * @see SpeechDetectionSensitivity
     */
    public final SpeechDetectionSensitivity speechDetectionSensitivity() {
        return SpeechDetectionSensitivity.fromValue(speechDetectionSensitivity);
    }

    /**
     * <p>
     * The updated sensitivity level for voice activity detection (VAD) in the bot locale.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #speechDetectionSensitivity} will return {@link SpeechDetectionSensitivity#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #speechDetectionSensitivityAsString}.
     * </p>
     * 
     * @return The updated sensitivity level for voice activity detection (VAD) in the bot locale.
     * @see SpeechDetectionSensitivity
     */
    public final String speechDetectionSensitivityAsString() {
        return speechDetectionSensitivity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(localeName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(nluIntentConfidenceThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(voiceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(unifiedSpeechSettings());
        hashCode = 31 * hashCode + Objects.hashCode(speechRecognitionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(botLocaleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailureReasons() ? failureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecommendedActions() ? recommendedActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(generativeAISettings());
        hashCode = 31 * hashCode + Objects.hashCode(speechDetectionSensitivityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBotLocaleResponse)) {
            return false;
        }
        UpdateBotLocaleResponse other = (UpdateBotLocaleResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId()) && Objects.equals(localeName(), other.localeName())
                && Objects.equals(description(), other.description())
                && Objects.equals(nluIntentConfidenceThreshold(), other.nluIntentConfidenceThreshold())
                && Objects.equals(voiceSettings(), other.voiceSettings())
                && Objects.equals(unifiedSpeechSettings(), other.unifiedSpeechSettings())
                && Objects.equals(speechRecognitionSettings(), other.speechRecognitionSettings())
                && Objects.equals(botLocaleStatusAsString(), other.botLocaleStatusAsString())
                && hasFailureReasons() == other.hasFailureReasons() && Objects.equals(failureReasons(), other.failureReasons())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && hasRecommendedActions() == other.hasRecommendedActions()
                && Objects.equals(recommendedActions(), other.recommendedActions())
                && Objects.equals(generativeAISettings(), other.generativeAISettings())
                && Objects.equals(speechDetectionSensitivityAsString(), other.speechDetectionSensitivityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBotLocaleResponse").add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("LocaleName", localeName()).add("Description", description())
                .add("NluIntentConfidenceThreshold", nluIntentConfidenceThreshold()).add("VoiceSettings", voiceSettings())
                .add("UnifiedSpeechSettings", unifiedSpeechSettings())
                .add("SpeechRecognitionSettings", speechRecognitionSettings()).add("BotLocaleStatus", botLocaleStatusAsString())
                .add("FailureReasons", hasFailureReasons() ? failureReasons() : null).add("CreationDateTime", creationDateTime())
                .add("LastUpdatedDateTime", lastUpdatedDateTime())
                .add("RecommendedActions", hasRecommendedActions() ? recommendedActions() : null)
                .add("GenerativeAISettings", generativeAISettings())
                .add("SpeechDetectionSensitivity", speechDetectionSensitivityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "localeName":
            return Optional.ofNullable(clazz.cast(localeName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "nluIntentConfidenceThreshold":
            return Optional.ofNullable(clazz.cast(nluIntentConfidenceThreshold()));
        case "voiceSettings":
            return Optional.ofNullable(clazz.cast(voiceSettings()));
        case "unifiedSpeechSettings":
            return Optional.ofNullable(clazz.cast(unifiedSpeechSettings()));
        case "speechRecognitionSettings":
            return Optional.ofNullable(clazz.cast(speechRecognitionSettings()));
        case "botLocaleStatus":
            return Optional.ofNullable(clazz.cast(botLocaleStatusAsString()));
        case "failureReasons":
            return Optional.ofNullable(clazz.cast(failureReasons()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "recommendedActions":
            return Optional.ofNullable(clazz.cast(recommendedActions()));
        case "generativeAISettings":
            return Optional.ofNullable(clazz.cast(generativeAISettings()));
        case "speechDetectionSensitivity":
            return Optional.ofNullable(clazz.cast(speechDetectionSensitivityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        map.put("localeName", LOCALE_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("nluIntentConfidenceThreshold", NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD);
        map.put("voiceSettings", VOICE_SETTINGS_FIELD);
        map.put("unifiedSpeechSettings", UNIFIED_SPEECH_SETTINGS_FIELD);
        map.put("speechRecognitionSettings", SPEECH_RECOGNITION_SETTINGS_FIELD);
        map.put("botLocaleStatus", BOT_LOCALE_STATUS_FIELD);
        map.put("failureReasons", FAILURE_REASONS_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        map.put("recommendedActions", RECOMMENDED_ACTIONS_FIELD);
        map.put("generativeAISettings", GENERATIVE_AI_SETTINGS_FIELD);
        map.put("speechDetectionSensitivity", SPEECH_DETECTION_SENSITIVITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBotLocaleResponse, T> g) {
        return obj -> g.apply((UpdateBotLocaleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBotLocaleResponse> {
        /**
         * <p>
         * The identifier of the bot that contains the updated locale.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot that contains the updated locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot that contains the updated locale.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot that contains the updated locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The language and locale of the updated bot locale.
         * </p>
         * 
         * @param localeId
         *        The language and locale of the updated bot locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The updated locale name for the locale.
         * </p>
         * 
         * @param localeName
         *        The updated locale name for the locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeName(String localeName);

        /**
         * <p>
         * The updated description of the locale.
         * </p>
         * 
         * @param description
         *        The updated description of the locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The updated confidence threshold for inserting the <code>AMAZON.FallbackIntent</code> and
         * <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.
         * </p>
         * 
         * @param nluIntentConfidenceThreshold
         *        The updated confidence threshold for inserting the <code>AMAZON.FallbackIntent</code> and
         *        <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold);

        /**
         * <p>
         * The updated Amazon Polly voice to use for voice interaction with the user.
         * </p>
         * 
         * @param voiceSettings
         *        The updated Amazon Polly voice to use for voice interaction with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceSettings(VoiceSettings voiceSettings);

        /**
         * <p>
         * The updated Amazon Polly voice to use for voice interaction with the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link VoiceSettings.Builder} avoiding the need
         * to create one manually via {@link VoiceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VoiceSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #voiceSettings(VoiceSettings)}.
         * 
         * @param voiceSettings
         *        a consumer that will call methods on {@link VoiceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceSettings(VoiceSettings)
         */
        default Builder voiceSettings(Consumer<VoiceSettings.Builder> voiceSettings) {
            return voiceSettings(VoiceSettings.builder().applyMutation(voiceSettings).build());
        }

        /**
         * <p>
         * The updated unified speech settings for the bot locale.
         * </p>
         * 
         * @param unifiedSpeechSettings
         *        The updated unified speech settings for the bot locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unifiedSpeechSettings(UnifiedSpeechSettings unifiedSpeechSettings);

        /**
         * <p>
         * The updated unified speech settings for the bot locale.
         * </p>
         * This is a convenience method that creates an instance of the {@link UnifiedSpeechSettings.Builder} avoiding
         * the need to create one manually via {@link UnifiedSpeechSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UnifiedSpeechSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #unifiedSpeechSettings(UnifiedSpeechSettings)}.
         * 
         * @param unifiedSpeechSettings
         *        a consumer that will call methods on {@link UnifiedSpeechSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unifiedSpeechSettings(UnifiedSpeechSettings)
         */
        default Builder unifiedSpeechSettings(Consumer<UnifiedSpeechSettings.Builder> unifiedSpeechSettings) {
            return unifiedSpeechSettings(UnifiedSpeechSettings.builder().applyMutation(unifiedSpeechSettings).build());
        }

        /**
         * <p>
         * The updated speech-to-text settings for the bot locale.
         * </p>
         * 
         * @param speechRecognitionSettings
         *        The updated speech-to-text settings for the bot locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speechRecognitionSettings(SpeechRecognitionSettings speechRecognitionSettings);

        /**
         * <p>
         * The updated speech-to-text settings for the bot locale.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpeechRecognitionSettings.Builder}
         * avoiding the need to create one manually via {@link SpeechRecognitionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpeechRecognitionSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #speechRecognitionSettings(SpeechRecognitionSettings)}.
         * 
         * @param speechRecognitionSettings
         *        a consumer that will call methods on {@link SpeechRecognitionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #speechRecognitionSettings(SpeechRecognitionSettings)
         */
        default Builder speechRecognitionSettings(Consumer<SpeechRecognitionSettings.Builder> speechRecognitionSettings) {
            return speechRecognitionSettings(SpeechRecognitionSettings.builder().applyMutation(speechRecognitionSettings).build());
        }

        /**
         * <p>
         * The current status of the locale. When the bot status is <code>Built</code> the locale is ready for use.
         * </p>
         * 
         * @param botLocaleStatus
         *        The current status of the locale. When the bot status is <code>Built</code> the locale is ready for
         *        use.
         * @see BotLocaleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotLocaleStatus
         */
        Builder botLocaleStatus(String botLocaleStatus);

        /**
         * <p>
         * The current status of the locale. When the bot status is <code>Built</code> the locale is ready for use.
         * </p>
         * 
         * @param botLocaleStatus
         *        The current status of the locale. When the bot status is <code>Built</code> the locale is ready for
         *        use.
         * @see BotLocaleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotLocaleStatus
         */
        Builder botLocaleStatus(BotLocaleStatus botLocaleStatus);

        /**
         * <p>
         * If the <code>botLocaleStatus</code> is <code>Failed</code>, the <code>failureReasons</code> field lists the
         * errors that occurred while building the bot.
         * </p>
         * 
         * @param failureReasons
         *        If the <code>botLocaleStatus</code> is <code>Failed</code>, the <code>failureReasons</code> field
         *        lists the errors that occurred while building the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(Collection<String> failureReasons);

        /**
         * <p>
         * If the <code>botLocaleStatus</code> is <code>Failed</code>, the <code>failureReasons</code> field lists the
         * errors that occurred while building the bot.
         * </p>
         * 
         * @param failureReasons
         *        If the <code>botLocaleStatus</code> is <code>Failed</code>, the <code>failureReasons</code> field
         *        lists the errors that occurred while building the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(String... failureReasons);

        /**
         * <p>
         * A timestamp of the date and time that the locale was created.
         * </p>
         * 
         * @param creationDateTime
         *        A timestamp of the date and time that the locale was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * A timestamp of the date and time that the locale was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        A timestamp of the date and time that the locale was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * Recommended actions to take to resolve an error in the <code>failureReasons</code> field.
         * </p>
         * 
         * @param recommendedActions
         *        Recommended actions to take to resolve an error in the <code>failureReasons</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedActions(Collection<String> recommendedActions);

        /**
         * <p>
         * Recommended actions to take to resolve an error in the <code>failureReasons</code> field.
         * </p>
         * 
         * @param recommendedActions
         *        Recommended actions to take to resolve an error in the <code>failureReasons</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedActions(String... recommendedActions);

        /**
         * <p>
         * Contains settings for generative AI features powered by Amazon Bedrock for your bot locale.
         * </p>
         * 
         * @param generativeAISettings
         *        Contains settings for generative AI features powered by Amazon Bedrock for your bot locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generativeAISettings(GenerativeAISettings generativeAISettings);

        /**
         * <p>
         * Contains settings for generative AI features powered by Amazon Bedrock for your bot locale.
         * </p>
         * This is a convenience method that creates an instance of the {@link GenerativeAISettings.Builder} avoiding
         * the need to create one manually via {@link GenerativeAISettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GenerativeAISettings.Builder#build()} is called immediately and
         * its result is passed to {@link #generativeAISettings(GenerativeAISettings)}.
         * 
         * @param generativeAISettings
         *        a consumer that will call methods on {@link GenerativeAISettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generativeAISettings(GenerativeAISettings)
         */
        default Builder generativeAISettings(Consumer<GenerativeAISettings.Builder> generativeAISettings) {
            return generativeAISettings(GenerativeAISettings.builder().applyMutation(generativeAISettings).build());
        }

        /**
         * <p>
         * The updated sensitivity level for voice activity detection (VAD) in the bot locale.
         * </p>
         * 
         * @param speechDetectionSensitivity
         *        The updated sensitivity level for voice activity detection (VAD) in the bot locale.
         * @see SpeechDetectionSensitivity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpeechDetectionSensitivity
         */
        Builder speechDetectionSensitivity(String speechDetectionSensitivity);

        /**
         * <p>
         * The updated sensitivity level for voice activity detection (VAD) in the bot locale.
         * </p>
         * 
         * @param speechDetectionSensitivity
         *        The updated sensitivity level for voice activity detection (VAD) in the bot locale.
         * @see SpeechDetectionSensitivity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpeechDetectionSensitivity
         */
        Builder speechDetectionSensitivity(SpeechDetectionSensitivity speechDetectionSensitivity);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private String localeId;

        private String localeName;

        private String description;

        private Double nluIntentConfidenceThreshold;

        private VoiceSettings voiceSettings;

        private UnifiedSpeechSettings unifiedSpeechSettings;

        private SpeechRecognitionSettings speechRecognitionSettings;

        private String botLocaleStatus;

        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private List<String> recommendedActions = DefaultSdkAutoConstructList.getInstance();

        private GenerativeAISettings generativeAISettings;

        private String speechDetectionSensitivity;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBotLocaleResponse model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            localeName(model.localeName);
            description(model.description);
            nluIntentConfidenceThreshold(model.nluIntentConfidenceThreshold);
            voiceSettings(model.voiceSettings);
            unifiedSpeechSettings(model.unifiedSpeechSettings);
            speechRecognitionSettings(model.speechRecognitionSettings);
            botLocaleStatus(model.botLocaleStatus);
            failureReasons(model.failureReasons);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            recommendedActions(model.recommendedActions);
            generativeAISettings(model.generativeAISettings);
            speechDetectionSensitivity(model.speechDetectionSensitivity);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getLocaleName() {
            return localeName;
        }

        public final void setLocaleName(String localeName) {
            this.localeName = localeName;
        }

        @Override
        public final Builder localeName(String localeName) {
            this.localeName = localeName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Double getNluIntentConfidenceThreshold() {
            return nluIntentConfidenceThreshold;
        }

        public final void setNluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold) {
            this.nluIntentConfidenceThreshold = nluIntentConfidenceThreshold;
        }

        @Override
        public final Builder nluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold) {
            this.nluIntentConfidenceThreshold = nluIntentConfidenceThreshold;
            return this;
        }

        public final VoiceSettings.Builder getVoiceSettings() {
            return voiceSettings != null ? voiceSettings.toBuilder() : null;
        }

        public final void setVoiceSettings(VoiceSettings.BuilderImpl voiceSettings) {
            this.voiceSettings = voiceSettings != null ? voiceSettings.build() : null;
        }

        @Override
        public final Builder voiceSettings(VoiceSettings voiceSettings) {
            this.voiceSettings = voiceSettings;
            return this;
        }

        public final UnifiedSpeechSettings.Builder getUnifiedSpeechSettings() {
            return unifiedSpeechSettings != null ? unifiedSpeechSettings.toBuilder() : null;
        }

        public final void setUnifiedSpeechSettings(UnifiedSpeechSettings.BuilderImpl unifiedSpeechSettings) {
            this.unifiedSpeechSettings = unifiedSpeechSettings != null ? unifiedSpeechSettings.build() : null;
        }

        @Override
        public final Builder unifiedSpeechSettings(UnifiedSpeechSettings unifiedSpeechSettings) {
            this.unifiedSpeechSettings = unifiedSpeechSettings;
            return this;
        }

        public final SpeechRecognitionSettings.Builder getSpeechRecognitionSettings() {
            return speechRecognitionSettings != null ? speechRecognitionSettings.toBuilder() : null;
        }

        public final void setSpeechRecognitionSettings(SpeechRecognitionSettings.BuilderImpl speechRecognitionSettings) {
            this.speechRecognitionSettings = speechRecognitionSettings != null ? speechRecognitionSettings.build() : null;
        }

        @Override
        public final Builder speechRecognitionSettings(SpeechRecognitionSettings speechRecognitionSettings) {
            this.speechRecognitionSettings = speechRecognitionSettings;
            return this;
        }

        public final String getBotLocaleStatus() {
            return botLocaleStatus;
        }

        public final void setBotLocaleStatus(String botLocaleStatus) {
            this.botLocaleStatus = botLocaleStatus;
        }

        @Override
        public final Builder botLocaleStatus(String botLocaleStatus) {
            this.botLocaleStatus = botLocaleStatus;
            return this;
        }

        @Override
        public final Builder botLocaleStatus(BotLocaleStatus botLocaleStatus) {
            this.botLocaleStatus(botLocaleStatus == null ? null : botLocaleStatus.toString());
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String... failureReasons) {
            failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final Collection<String> getRecommendedActions() {
            if (recommendedActions instanceof SdkAutoConstructList) {
                return null;
            }
            return recommendedActions;
        }

        public final void setRecommendedActions(Collection<String> recommendedActions) {
            this.recommendedActions = RecommendedActionsCopier.copy(recommendedActions);
        }

        @Override
        public final Builder recommendedActions(Collection<String> recommendedActions) {
            this.recommendedActions = RecommendedActionsCopier.copy(recommendedActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedActions(String... recommendedActions) {
            recommendedActions(Arrays.asList(recommendedActions));
            return this;
        }

        public final GenerativeAISettings.Builder getGenerativeAISettings() {
            return generativeAISettings != null ? generativeAISettings.toBuilder() : null;
        }

        public final void setGenerativeAISettings(GenerativeAISettings.BuilderImpl generativeAISettings) {
            this.generativeAISettings = generativeAISettings != null ? generativeAISettings.build() : null;
        }

        @Override
        public final Builder generativeAISettings(GenerativeAISettings generativeAISettings) {
            this.generativeAISettings = generativeAISettings;
            return this;
        }

        public final String getSpeechDetectionSensitivity() {
            return speechDetectionSensitivity;
        }

        public final void setSpeechDetectionSensitivity(String speechDetectionSensitivity) {
            this.speechDetectionSensitivity = speechDetectionSensitivity;
        }

        @Override
        public final Builder speechDetectionSensitivity(String speechDetectionSensitivity) {
            this.speechDetectionSensitivity = speechDetectionSensitivity;
            return this;
        }

        @Override
        public final Builder speechDetectionSensitivity(SpeechDetectionSensitivity speechDetectionSensitivity) {
            this.speechDetectionSensitivity(speechDetectionSensitivity == null ? null : speechDetectionSensitivity.toString());
            return this;
        }

        @Override
        public UpdateBotLocaleResponse build() {
            return new UpdateBotLocaleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
