/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Unified configuration settings that combine speech recognition and synthesis capabilities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnifiedSpeechSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<UnifiedSpeechSettings.Builder, UnifiedSpeechSettings> {
    private static final SdkField<SpeechFoundationModel> SPEECH_FOUNDATION_MODEL_FIELD = SdkField
            .<SpeechFoundationModel> builder(MarshallingType.SDK_POJO).memberName("speechFoundationModel")
            .getter(getter(UnifiedSpeechSettings::speechFoundationModel)).setter(setter(Builder::speechFoundationModel))
            .constructor(SpeechFoundationModel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speechFoundationModel").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SPEECH_FOUNDATION_MODEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SpeechFoundationModel speechFoundationModel;

    private UnifiedSpeechSettings(BuilderImpl builder) {
        this.speechFoundationModel = builder.speechFoundationModel;
    }

    /**
     * <p>
     * The foundation model configuration to use for unified speech processing capabilities.
     * </p>
     * 
     * @return The foundation model configuration to use for unified speech processing capabilities.
     */
    public final SpeechFoundationModel speechFoundationModel() {
        return speechFoundationModel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(speechFoundationModel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnifiedSpeechSettings)) {
            return false;
        }
        UnifiedSpeechSettings other = (UnifiedSpeechSettings) obj;
        return Objects.equals(speechFoundationModel(), other.speechFoundationModel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnifiedSpeechSettings").add("SpeechFoundationModel", speechFoundationModel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "speechFoundationModel":
            return Optional.ofNullable(clazz.cast(speechFoundationModel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("speechFoundationModel", SPEECH_FOUNDATION_MODEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnifiedSpeechSettings, T> g) {
        return obj -> g.apply((UnifiedSpeechSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnifiedSpeechSettings> {
        /**
         * <p>
         * The foundation model configuration to use for unified speech processing capabilities.
         * </p>
         * 
         * @param speechFoundationModel
         *        The foundation model configuration to use for unified speech processing capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speechFoundationModel(SpeechFoundationModel speechFoundationModel);

        /**
         * <p>
         * The foundation model configuration to use for unified speech processing capabilities.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpeechFoundationModel.Builder} avoiding
         * the need to create one manually via {@link SpeechFoundationModel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpeechFoundationModel.Builder#build()} is called immediately and
         * its result is passed to {@link #speechFoundationModel(SpeechFoundationModel)}.
         * 
         * @param speechFoundationModel
         *        a consumer that will call methods on {@link SpeechFoundationModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #speechFoundationModel(SpeechFoundationModel)
         */
        default Builder speechFoundationModel(Consumer<SpeechFoundationModel.Builder> speechFoundationModel) {
            return speechFoundationModel(SpeechFoundationModel.builder().applyMutation(speechFoundationModel).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SpeechFoundationModel speechFoundationModel;

        private BuilderImpl() {
        }

        private BuilderImpl(UnifiedSpeechSettings model) {
            speechFoundationModel(model.speechFoundationModel);
        }

        public final SpeechFoundationModel.Builder getSpeechFoundationModel() {
            return speechFoundationModel != null ? speechFoundationModel.toBuilder() : null;
        }

        public final void setSpeechFoundationModel(SpeechFoundationModel.BuilderImpl speechFoundationModel) {
            this.speechFoundationModel = speechFoundationModel != null ? speechFoundationModel.build() : null;
        }

        @Override
        public final Builder speechFoundationModel(SpeechFoundationModel speechFoundationModel) {
            this.speechFoundationModel = speechFoundationModel;
            return this;
        }

        @Override
        public UnifiedSpeechSettings build() {
            return new UnifiedSpeechSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
