/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines settings to enable text conversation logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TextLogSetting implements SdkPojo, Serializable, ToCopyableBuilder<TextLogSetting.Builder, TextLogSetting> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(TextLogSetting::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<TextLogDestination> DESTINATION_FIELD = SdkField
            .<TextLogDestination> builder(MarshallingType.SDK_POJO).memberName("destination")
            .getter(getter(TextLogSetting::destination)).setter(setter(Builder::destination))
            .constructor(TextLogDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<Boolean> SELECTIVE_LOGGING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("selectiveLoggingEnabled").getter(getter(TextLogSetting::selectiveLoggingEnabled))
            .setter(setter(Builder::selectiveLoggingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectiveLoggingEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            DESTINATION_FIELD, SELECTIVE_LOGGING_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final TextLogDestination destination;

    private final Boolean selectiveLoggingEnabled;

    private TextLogSetting(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.destination = builder.destination;
        this.selectiveLoggingEnabled = builder.selectiveLoggingEnabled;
    }

    /**
     * <p>
     * Determines whether conversation logs should be stored for an alias.
     * </p>
     * 
     * @return Determines whether conversation logs should be stored for an alias.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * Returns the value of the Destination property for this object.
     * 
     * @return The value of the Destination property for this object.
     */
    public final TextLogDestination destination() {
        return destination;
    }

    /**
     * <p>
     * The option to enable selective conversation log capture for text.
     * </p>
     * 
     * @return The option to enable selective conversation log capture for text.
     */
    public final Boolean selectiveLoggingEnabled() {
        return selectiveLoggingEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(selectiveLoggingEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextLogSetting)) {
            return false;
        }
        TextLogSetting other = (TextLogSetting) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(destination(), other.destination())
                && Objects.equals(selectiveLoggingEnabled(), other.selectiveLoggingEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextLogSetting").add("Enabled", enabled()).add("Destination", destination())
                .add("SelectiveLoggingEnabled", selectiveLoggingEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "selectiveLoggingEnabled":
            return Optional.ofNullable(clazz.cast(selectiveLoggingEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enabled", ENABLED_FIELD);
        map.put("destination", DESTINATION_FIELD);
        map.put("selectiveLoggingEnabled", SELECTIVE_LOGGING_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TextLogSetting, T> g) {
        return obj -> g.apply((TextLogSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextLogSetting> {
        /**
         * <p>
         * Determines whether conversation logs should be stored for an alias.
         * </p>
         * 
         * @param enabled
         *        Determines whether conversation logs should be stored for an alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * Sets the value of the Destination property for this object.
         *
         * @param destination
         *        The new value for the Destination property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(TextLogDestination destination);

        /**
         * Sets the value of the Destination property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TextLogDestination.Builder} avoiding the
         * need to create one manually via {@link TextLogDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextLogDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(TextLogDestination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link TextLogDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(TextLogDestination)
         */
        default Builder destination(Consumer<TextLogDestination.Builder> destination) {
            return destination(TextLogDestination.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * The option to enable selective conversation log capture for text.
         * </p>
         * 
         * @param selectiveLoggingEnabled
         *        The option to enable selective conversation log capture for text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectiveLoggingEnabled(Boolean selectiveLoggingEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private TextLogDestination destination;

        private Boolean selectiveLoggingEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(TextLogSetting model) {
            enabled(model.enabled);
            destination(model.destination);
            selectiveLoggingEnabled(model.selectiveLoggingEnabled);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final TextLogDestination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(TextLogDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(TextLogDestination destination) {
            this.destination = destination;
            return this;
        }

        public final Boolean getSelectiveLoggingEnabled() {
            return selectiveLoggingEnabled;
        }

        public final void setSelectiveLoggingEnabled(Boolean selectiveLoggingEnabled) {
            this.selectiveLoggingEnabled = selectiveLoggingEnabled;
        }

        @Override
        public final Builder selectiveLoggingEnabled(Boolean selectiveLoggingEnabled) {
            this.selectiveLoggingEnabled = selectiveLoggingEnabled;
            return this;
        }

        @Override
        public TextLogSetting build() {
            return new TextLogSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
