/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the text input specifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TextInputSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<TextInputSpecification.Builder, TextInputSpecification> {
    private static final SdkField<Integer> START_TIMEOUT_MS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("startTimeoutMs").getter(getter(TextInputSpecification::startTimeoutMs))
            .setter(setter(Builder::startTimeoutMs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeoutMs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIMEOUT_MS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer startTimeoutMs;

    private TextInputSpecification(BuilderImpl builder) {
        this.startTimeoutMs = builder.startTimeoutMs;
    }

    /**
     * <p>
     * Time for which a bot waits before re-prompting a customer for text input.
     * </p>
     * 
     * @return Time for which a bot waits before re-prompting a customer for text input.
     */
    public final Integer startTimeoutMs() {
        return startTimeoutMs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTimeoutMs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextInputSpecification)) {
            return false;
        }
        TextInputSpecification other = (TextInputSpecification) obj;
        return Objects.equals(startTimeoutMs(), other.startTimeoutMs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextInputSpecification").add("StartTimeoutMs", startTimeoutMs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "startTimeoutMs":
            return Optional.ofNullable(clazz.cast(startTimeoutMs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("startTimeoutMs", START_TIMEOUT_MS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TextInputSpecification, T> g) {
        return obj -> g.apply((TextInputSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextInputSpecification> {
        /**
         * <p>
         * Time for which a bot waits before re-prompting a customer for text input.
         * </p>
         * 
         * @param startTimeoutMs
         *        Time for which a bot waits before re-prompting a customer for text input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeoutMs(Integer startTimeoutMs);
    }

    static final class BuilderImpl implements Builder {
        private Integer startTimeoutMs;

        private BuilderImpl() {
        }

        private BuilderImpl(TextInputSpecification model) {
            startTimeoutMs(model.startTimeoutMs);
        }

        public final Integer getStartTimeoutMs() {
            return startTimeoutMs;
        }

        public final void setStartTimeoutMs(Integer startTimeoutMs) {
            this.startTimeoutMs = startTimeoutMs;
        }

        @Override
        public final Builder startTimeoutMs(Integer startTimeoutMs) {
            this.startTimeoutMs = startTimeoutMs;
            return this;
        }

        @Override
        public TextInputSpecification build() {
            return new TextInputSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
